/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.support;

import com.databricks.internal.sdk.support.WaitStarter;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class Wait<T, R> {
    private final WaitStarter<T> impl;
    private final R response;
    private Consumer<T> progress;

    public Wait(WaitStarter<T> impl) {
        this(impl, null);
    }

    public Wait(WaitStarter<T> impl, R response) {
        this.impl = impl;
        this.response = response;
    }

    public Wait<T, R> onProgress(Consumer<T> progress) {
        this.progress = progress;
        return this;
    }

    public T get() throws TimeoutException {
        return this.get(Duration.ofMinutes(20L));
    }

    public T get(Duration timeout) throws TimeoutException {
        return this.impl.apply(timeout, this.progress);
    }

    public R getResponse() {
        return this.response;
    }
}

