/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.marketplace.CreateExchangeFilterRequest;
import com.databricks.internal.sdk.service.marketplace.CreateExchangeFilterResponse;
import com.databricks.internal.sdk.service.marketplace.DeleteExchangeFilterRequest;
import com.databricks.internal.sdk.service.marketplace.ListExchangeFiltersRequest;
import com.databricks.internal.sdk.service.marketplace.ListExchangeFiltersResponse;
import com.databricks.internal.sdk.service.marketplace.ProviderExchangeFiltersService;
import com.databricks.internal.sdk.service.marketplace.UpdateExchangeFilterRequest;
import com.databricks.internal.sdk.service.marketplace.UpdateExchangeFilterResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProviderExchangeFiltersImpl
implements ProviderExchangeFiltersService {
    private final ApiClient apiClient;

    public ProviderExchangeFiltersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateExchangeFilterResponse create(CreateExchangeFilterRequest request) {
        String path = "/api/2.0/marketplace-exchange/filters";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateExchangeFilterResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteExchangeFilterRequest request) {
        String path = String.format("/api/2.0/marketplace-exchange/filters/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListExchangeFiltersResponse list(ListExchangeFiltersRequest request) {
        String path = "/api/2.0/marketplace-exchange/filters";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListExchangeFiltersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateExchangeFilterResponse update(UpdateExchangeFilterRequest request) {
        String path = String.format("/api/2.0/marketplace-exchange/filters/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateExchangeFilterResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

