/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iamv2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iamv2.GetWorkspaceAccessDetailLocalRequest;
import com.databricks.internal.sdk.service.iamv2.ResolveGroupProxyRequest;
import com.databricks.internal.sdk.service.iamv2.ResolveGroupResponse;
import com.databricks.internal.sdk.service.iamv2.ResolveServicePrincipalProxyRequest;
import com.databricks.internal.sdk.service.iamv2.ResolveServicePrincipalResponse;
import com.databricks.internal.sdk.service.iamv2.ResolveUserProxyRequest;
import com.databricks.internal.sdk.service.iamv2.ResolveUserResponse;
import com.databricks.internal.sdk.service.iamv2.WorkspaceAccessDetail;
import com.databricks.internal.sdk.service.iamv2.WorkspaceIamV2Service;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceIamV2Impl
implements WorkspaceIamV2Service {
    private final ApiClient apiClient;

    public WorkspaceIamV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public WorkspaceAccessDetail getWorkspaceAccessDetailLocal(GetWorkspaceAccessDetailLocalRequest request) {
        String path = String.format("/api/2.0/identity/workspaceAccessDetails/%s", request.getPrincipalId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WorkspaceAccessDetail.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResolveGroupResponse resolveGroupProxy(ResolveGroupProxyRequest request) {
        String path = "/api/2.0/identity/groups/resolveByExternalId";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ResolveGroupResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResolveServicePrincipalResponse resolveServicePrincipalProxy(ResolveServicePrincipalProxyRequest request) {
        String path = "/api/2.0/identity/servicePrincipals/resolveByExternalId";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ResolveServicePrincipalResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResolveUserResponse resolveUserProxy(ResolveUserProxyRequest request) {
        String path = "/api/2.0/identity/users/resolveByExternalId";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ResolveUserResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

