/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.oauth.CachedTokenSource;
import com.databricks.internal.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.internal.sdk.core.oauth.SessionCredentialsTokenSource;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenCache;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCredentials
implements CredentialsProvider,
Serializable {
    private static final long serialVersionUID = 3083941540130596650L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionCredentials.class);
    private final SessionCredentialsTokenSource tokenSource;

    private SessionCredentials(Builder b) {
        this.tokenSource = new SessionCredentialsTokenSource(b.token, b.hc, b.tokenUrl, b.clientId, b.clientSecret, Optional.ofNullable(b.redirectUrl), Optional.ofNullable(b.tokenCache));
    }

    @Override
    public String authType() {
        return "oauth-u2m";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        CachedTokenSource cachedTokenSource = new CachedTokenSource.Builder(this.tokenSource).setToken(this.tokenSource.getToken()).build();
        return OAuthHeaderFactory.fromTokenSource(cachedTokenSource);
    }

    static class Builder {
        private HttpClient hc;
        private Token token;
        private String tokenUrl;
        private String redirectUrl;
        private String clientId;
        private String clientSecret;
        private TokenCache tokenCache;

        Builder() {
        }

        public Builder withHttpClient(HttpClient hc) {
            this.hc = hc;
            return this;
        }

        public Builder withToken(Token token) {
            this.token = token;
            return this;
        }

        public Builder withTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder withRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withTokenCache(TokenCache tokenCache) {
            this.tokenCache = tokenCache;
            return this;
        }

        public SessionCredentials build() {
            return new SessionCredentials(this);
        }
    }
}

