/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.operator.bc;

import com.databricks.internal.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.databricks.internal.bouncycastle.crypto.Signer;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.crypto.signers.Ed25519Signer;
import com.databricks.internal.bouncycastle.crypto.signers.Ed448Signer;
import com.databricks.internal.bouncycastle.crypto.util.PublicKeyFactory;
import com.databricks.internal.bouncycastle.operator.OperatorCreationException;
import com.databricks.internal.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcEdDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    public static final byte[] DEFAULT_CONTEXT = new byte[0];

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(EdECObjectIdentifiers.id_Ed448)) {
            return new Ed448Signer(DEFAULT_CONTEXT);
        }
        return new Ed25519Signer();
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

