/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cms;

import com.databricks.internal.bouncycastle.asn1.DEROctetString;
import com.databricks.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.databricks.internal.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.databricks.internal.bouncycastle.asn1.cms.RecipientIdentifier;
import com.databricks.internal.bouncycastle.asn1.cms.RecipientInfo;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.RecipientInfoGenerator;
import com.databricks.internal.bouncycastle.operator.AsymmetricKeyWrapper;
import com.databricks.internal.bouncycastle.operator.GenericKey;
import com.databricks.internal.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = asymmetricKeyWrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] byArray, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = asymmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(byArray)));
    }
}

