/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cms;

import com.databricks.internal.bouncycastle.asn1.cms.KEKIdentifier;
import com.databricks.internal.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.CMSSecureReadable;
import com.databricks.internal.bouncycastle.cms.KEKRecipient;
import com.databricks.internal.bouncycastle.cms.KEKRecipientId;
import com.databricks.internal.bouncycastle.cms.Recipient;
import com.databricks.internal.bouncycastle.cms.RecipientInformation;
import com.databricks.internal.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

