/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.hc.core5.net;

import com.databricks.internal.apache.hc.core5.http.NameValuePair;
import com.databricks.internal.apache.hc.core5.http.message.BasicNameValuePair;
import com.databricks.internal.apache.hc.core5.net.PercentCodec;
import com.databricks.internal.apache.hc.core5.net.URIBuilder;
import com.databricks.internal.apache.hc.core5.util.Args;
import com.databricks.internal.apache.hc.core5.util.Tokenizer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

@Deprecated
public class URLEncodedUtils {
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final BitSet URL_ENCODER;

    public static List<NameValuePair> parse(URI uri, Charset charset) {
        Args.notNull(uri, "URI");
        String query = uri.getRawQuery();
        if (query != null && !query.isEmpty()) {
            return URLEncodedUtils.parse(query, charset);
        }
        return new ArrayList<NameValuePair>(0);
    }

    public static List<NameValuePair> parse(CharSequence s2, Charset charset) {
        if (s2 == null) {
            return new ArrayList<NameValuePair>(0);
        }
        return URLEncodedUtils.parse(s2, charset, '&', ';');
    }

    public static List<NameValuePair> parse(CharSequence s2, Charset charset, char ... separators) {
        Args.notNull(s2, "Char sequence");
        Tokenizer tokenParser = Tokenizer.INSTANCE;
        BitSet delimSet = new BitSet();
        for (char separator : separators) {
            delimSet.set(separator);
        }
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, s2.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            delimSet.set(61);
            String name = tokenParser.parseToken(s2, cursor, delimSet);
            String value = null;
            if (!cursor.atEnd()) {
                char delim = s2.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (delim == '=') {
                    delimSet.clear(61);
                    value = tokenParser.parseToken(s2, cursor, delimSet);
                    if (!cursor.atEnd()) {
                        cursor.updatePos(cursor.getPos() + 1);
                    }
                }
            }
            if (name.isEmpty()) continue;
            list.add(new BasicNameValuePair(PercentCodec.decode(name, charset, true), PercentCodec.decode(value, charset, true)));
        }
        return list;
    }

    public static List<String> parsePathSegments(CharSequence s2, Charset charset) {
        return URIBuilder.parsePath(s2, charset);
    }

    public static List<String> parsePathSegments(CharSequence s2) {
        return URLEncodedUtils.parsePathSegments(s2, StandardCharsets.UTF_8);
    }

    public static String formatSegments(Iterable<String> segments, Charset charset) {
        Args.notNull(segments, "Segments");
        StringBuilder buf = new StringBuilder();
        URIBuilder.formatPath(buf, segments, false, charset);
        return buf.toString();
    }

    public static String formatSegments(String ... segments) {
        return URLEncodedUtils.formatSegments(Arrays.asList(segments), StandardCharsets.UTF_8);
    }

    public static String format(Iterable<? extends NameValuePair> parameters, char parameterSeparator, Charset charset) {
        Args.notNull(parameters, "Parameters");
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (NameValuePair nameValuePair : parameters) {
            if (i > 0) {
                buf.append(parameterSeparator);
            }
            PercentCodec.encode(buf, nameValuePair.getName(), charset, URL_ENCODER, true);
            if (nameValuePair.getValue() != null) {
                buf.append('=');
                PercentCodec.encode(buf, nameValuePair.getValue(), charset, URL_ENCODER, true);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String format(Iterable<? extends NameValuePair> parameters, Charset charset) {
        return URLEncodedUtils.format(parameters, '&', charset);
    }

    static {
        int i;
        URL_ENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URL_ENCODER.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URL_ENCODER.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URL_ENCODER.set(i);
        }
        URL_ENCODER.set(95);
        URL_ENCODER.set(45);
        URL_ENCODER.set(46);
        URL_ENCODER.set(42);
    }
}

