/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;

public abstract class AbstractTinyIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    protected boolean m_isSigned;

    protected AbstractTinyIntBinArithFunctor(boolean bl) {
        this.m_isSigned = bl;
    }

    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        short s;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        short s2 = iSqlDataWrapper.getTinyInt();
        short s3 = this.calculate(s2, s = iSqlDataWrapper2.getTinyInt());
        if (!this.checkRange(s3)) {
            throw SQLEngineExceptionFactory.numArithOverflowException();
        }
        eTDataRequest.getData().setTinyInt(s3);
        return false;
    }

    protected abstract short calculate(short var1, short var2) throws ErrorException;

    private boolean checkRange(long l) {
        if (this.m_isSigned) {
            return -128L <= l && l <= 127L;
        }
        return 0L <= l && l <= 255L;
    }
}

