/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.temptable.column;

import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.databricks.client.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.sql.Timestamp;

public final class TimestampColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -7615131358345588142L;
    private Timestamp[] m_data;
    private final int m_columnNumber;

    public TimestampColumnSlice(int n, int n2) {
        this.m_data = new Timestamp[n];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    @Override
    public void setNull(int n) {
        this.m_data[n] = null;
    }

    @Override
    public Timestamp getTimestamp(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.TIMESTAMP;
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) {
        this.m_data[n] = timestamp;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        TimestampColumnSlice timestampColumnSlice = (TimestampColumnSlice)iColumnSlice;
        System.arraycopy(timestampColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getObjectShellSize() + (double)javaSize.getLongSize() + (double)javaSize.getIntSize() + (double)javaSize.getObjectRefSize();
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

