/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.relation.join;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IMemManagerAgent;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.relation.join.FileRowTracker;
import com.databricks.client.sqlengine.executor.etree.relation.join.IMasterJoinUnit;
import com.databricks.client.sqlengine.executor.etree.temptable.IRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.ITemporaryTable;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryTable;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.databricks.client.sqlengine.utilities.ExternalAlgorithmUtil;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;

class RelationWrapperJoinUnit
implements IMasterJoinUnit {
    private static final String PACKAGE_NAME = RelationWrapperJoinUnit.class.getPackage().getName();
    private static final String CLASS_NAME = RelationWrapperJoinUnit.class.getSimpleName();
    private static final int ROW_TRACKER_BUFFER_SIZE = 4096;
    private ETRelationalExpr m_relation;
    private long m_currentRowNum;
    private FileRowTracker m_tracker = null;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_externProperty;
    private boolean m_trackOuterRows;
    private ITemporaryTable m_cache;
    private long m_memoryAssigned;
    private long m_requiredMemory;

    public RelationWrapperJoinUnit(ETRelationalExpr eTRelationalExpr, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, boolean bl) throws ErrorException {
        if (null != externalAlgorithmProperties.getLogger()) {
            LogUtilities.logFunctionEntrance(externalAlgorithmProperties.getLogger(), new Object[0]);
        }
        this.m_relation = eTRelationalExpr;
        this.m_currentRowNum = -1L;
        this.m_externProperty = externalAlgorithmProperties;
        this.m_trackOuterRows = bl;
        this.m_memoryAssigned = 0L;
        if (this.m_trackOuterRows) {
            this.m_cache = this.createCache();
            this.m_requiredMemory = this.m_cache.getRequiredMemory() + 4096L;
        } else {
            this.m_requiredMemory = 0L;
        }
    }

    @Override
    public IRowView getRow() {
        return null;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_trackOuterRows ? this.m_cache.retrieveData(n, eTDataRequest) : this.m_relation.retrieveData(n, eTDataRequest);
    }

    public void reset() throws ErrorException {
        this.resetRelation();
        if (this.m_trackOuterRows) {
            assert (this.m_tracker != null);
            this.m_tracker.reset();
        }
    }

    public void resetRelation() throws ErrorException {
        if (this.m_trackOuterRows) {
            assert (this.m_cache != null);
            this.m_cache.reset();
        } else {
            assert (this.m_relation.isOpen());
            this.m_relation.reset();
        }
        this.m_currentRowNum = -1L;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        boolean bl;
        if (this.m_trackOuterRows) {
            assert (this.m_cache != null);
            bl = this.m_cache.moveToNextRow();
        } else {
            assert (this.m_relation.isOpen());
            bl = this.m_relation.move();
        }
        if (bl) {
            ++this.m_currentRowNum;
        }
        return bl;
    }

    @Override
    public void match() throws ErrorException {
        if (this.m_tracker != null) {
            this.m_tracker.set(this.m_currentRowNum);
        }
    }

    public boolean isCurRowUnmatched() throws ErrorException {
        if (!this.m_trackOuterRows) {
            throw new IllegalStateException("Outer rows is not tracked.");
        }
        return !this.m_tracker.isSet(this.m_currentRowNum);
    }

    @Override
    public void close() {
        if (null != this.m_externProperty.getLogger()) {
            this.m_externProperty.getLogger().logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "close");
        }
    }

    public void closeRelation(boolean bl) {
        if (null != this.m_externProperty.getLogger()) {
            this.m_externProperty.getLogger().logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "closeRelation");
        }
        if (this.m_relation.isOpen()) {
            this.m_relation.close(bl);
        }
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        if (this.m_cache != null) {
            this.m_cache.close(bl);
            this.m_cache = null;
        }
    }

    public long getRequiredMemory() {
        return this.m_requiredMemory;
    }

    public void openRelation() throws ErrorException {
        if (null != this.m_externProperty.getLogger()) {
            this.m_externProperty.getLogger().logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "openRelation");
        }
        this.m_relation.open(CursorType.FORWARD_ONLY);
        if (this.m_trackOuterRows) {
            if (this.m_tracker != null) {
                this.m_tracker.close();
                this.m_tracker = null;
            }
            this.m_tracker = new FileRowTracker(this.m_externProperty.getStorageDir(), 4096L, this.m_externProperty.getLogger());
            if (this.m_cache == null) {
                this.m_cache = this.createCache();
            }
            this.m_cache.assign(this.m_memoryAssigned - 4096L);
            this.m_cache.open();
            this.m_cache.writeFromRelation(this.m_relation);
            this.m_cache.reset();
            this.m_relation.close(this.m_relation.canReopenAfterClosed());
        }
    }

    public long assignMemory(long l) {
        if (null != this.m_externProperty.getLogger()) {
            this.m_externProperty.getLogger().logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "assignMemory");
        }
        if (this.m_memoryAssigned < this.m_requiredMemory) {
            long l2 = this.m_requiredMemory - this.m_memoryAssigned;
            if (l2 <= l) {
                this.m_memoryAssigned = this.m_requiredMemory;
                assert (this.m_cache != null);
                this.m_cache.assign(this.m_memoryAssigned);
                if (null != this.m_externProperty.getLogger()) {
                    this.m_externProperty.getLogger().logTrace(PACKAGE_NAME, CLASS_NAME, "assignMemory", "Assigned : " + l2);
                }
                return l2;
            }
            this.m_memoryAssigned += l;
            if (null != this.m_externProperty.getLogger()) {
                this.m_externProperty.getLogger().logTrace(PACKAGE_NAME, CLASS_NAME, "assignMemory", "Assigned : " + l);
            }
            return l;
        }
        return 0L;
    }

    private ITemporaryTable createCache() throws ErrorException {
        int n = this.m_relation.getColumnCount();
        boolean[] blArray = new boolean[n];
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.m_relation.getColumn(i));
            blArray[i] = this.m_relation.getDataNeeded(i);
        }
        TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties = new TemporaryTableBuilder.TemporaryTableProperties(this.m_externProperty.getStorageDir(), this.m_externProperty.getCellMemoryLimit(), this.m_externProperty.getBlockSize(), ExternalAlgorithmUtil.calculateRowSize(arrayList, blArray, this.m_externProperty.getCellMemoryLimit()), this.m_externProperty.getMaxNumOpenFiles(), this.m_externProperty.getLogger(), "Join");
        TemporaryTable temporaryTable = new TemporaryTable(arrayList, temporaryTableProperties, blArray);
        temporaryTable.registerManagerAgent(new IMemManagerAgent(){

            @Override
            public void unregisterConsumer() {
            }

            @Override
            public void recycleMemory(long l) {
            }

            @Override
            public long require(long l, long l2) {
                return -1L;
            }
        });
        return temporaryTable;
    }

    @Override
    public void processUnmatchedOuterRow() {
    }
}

