/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aetree.statement;

import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEWithClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public class AETreeCopyUtil {
    public static <T extends IAENode> T copySubtree(IAENode iAENode) {
        IAENode iAENode2 = (IAENode)iAENode.getClass().cast(Objects.requireNonNull(iAENode.copy()));
        AETreeCopyUtil.finalizeSubtreeCopy(iAENode2);
        return (T)iAENode2;
    }

    public static void finalizeStatementCopy(IAEStatement iAEStatement) {
        AETreeCopyUtil.finalizeCopy(iAEStatement, false);
    }

    public static void finalizeSubtreeCopy(IAENode iAENode) {
        assert (!(iAENode instanceof IAEStatement));
        AETreeCopyUtil.finalizeCopy(iAENode, true);
    }

    private static void finalizeCopy(IAENode iAENode, boolean bl) {
        try {
            iAENode.acceptVisitor(new CopyFinalizer(bl));
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    private static class CopyFinalizer
    extends AEDefaultVisitor<Void> {
        private final Map<AERelationalExpr, AERelationalExpr> m_relExprMap = new IdentityHashMap<AERelationalExpr, AERelationalExpr>();
        private final Map<AEWithClause, AEWithClause> m_withClauseMap = new IdentityHashMap<AEWithClause, AEWithClause>();
        private final boolean m_isSubTree;

        public CopyFinalizer(boolean bl) {
            this.m_isSubTree = bl;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            IAENode iAENode2;
            Object object;
            if (iAENode instanceof AERelationalExpr) {
                object = (AERelationalExpr)iAENode;
                iAENode2 = Objects.requireNonNull(((AERelationalExpr)object).getOrigin());
                assert (iAENode2 != null);
                assert (!this.m_relExprMap.containsKey(iAENode2));
                this.m_relExprMap.put((AERelationalExpr)iAENode2, (AERelationalExpr)object);
            } else if (iAENode instanceof AEWithClause) {
                object = (AEWithClause)iAENode;
                iAENode2 = ((AEWithClause)iAENode).getOrigin();
                assert (iAENode2 != null);
                assert (!this.m_withClauseMap.containsKey(iAENode2));
                this.m_withClauseMap.put((AEWithClause)iAENode2, (AEWithClause)object);
            } else if (iAENode instanceof AEColumnReference) {
                object = (AEColumnReference)iAENode;
                iAENode2 = (AENamedRelationalExpr)this.m_relExprMap.get(((AEColumnReference)object).getNamedRelationalExpr());
                if (iAENode2 == null) {
                    if (!this.m_isSubTree) {
                        throw new RuntimeException(SQLEngineExceptionFactory.invalidAETreeException());
                    }
                } else {
                    ((AEColumnReference)object).setNamedRelationalExpr((AENamedRelationalExpr)iAENode2);
                }
            } else if (iAENode instanceof AEProxyColumn) {
                object = (AEProxyColumn)iAENode;
                iAENode2 = this.m_relExprMap.get(((AEProxyColumn)object).getRelationalExpr());
                if (iAENode2 == null) {
                    if (!this.m_isSubTree) {
                        throw new RuntimeException(SQLEngineExceptionFactory.invalidAETreeException());
                    }
                } else {
                    ((AEProxyColumn)object).setRelationalExpr((AERelationalExpr)iAENode2);
                }
            } else if (iAENode instanceof AECommonTableExpr) {
                object = (AECommonTableExpr)iAENode;
                iAENode2 = ((AECommonTableExpr)object).getReferencedWithClause();
                AEWithClause aEWithClause = this.m_withClauseMap.get(iAENode2);
                if (aEWithClause == null) {
                    if (!this.m_isSubTree) {
                        throw new RuntimeException(SQLEngineExceptionFactory.invalidAETreeException());
                    }
                } else {
                    ((AECommonTableExpr)object).updateWithClause(aEWithClause);
                }
            }
            if (iAENode.getNumChildren() > 0) {
                object = iAENode.getChildItr();
                while (object.hasNext()) {
                    ((IAENode)object.next()).acceptVisitor(this);
                }
            }
            return null;
        }
    }
}

