/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aeoptimizer;

import com.databricks.client.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.databricks.client.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.databricks.client.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Objects;

public class AEPassdownJoin {
    private final DSIExtOperationHandlerFactory m_opHandlerFactory;

    public AEPassdownJoin(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        this.m_opHandlerFactory = Objects.requireNonNull(dSIExtOperationHandlerFactory);
    }

    public AERelationalExpr passdown(AEJoin aEJoin) {
        return this.passdown(aEJoin, aEJoin.getJoinType(), aEJoin.getJoinCondition());
    }

    public AETable passdown(AECrossJoin aECrossJoin) {
        return (AETable)this.passdown(aECrossJoin, AEJoin.AEJoinType.INNER_JOIN, new AEBooleanTrue());
    }

    private AERelationalExpr passdown(AEBinaryRelationalExpr aEBinaryRelationalExpr, AEJoin.AEJoinType aEJoinType, AEBooleanExpr aEBooleanExpr) {
        DSIExtJResultSet dSIExtJResultSet;
        Object object;
        assert (aEBooleanExpr != null);
        AETable aETable = (AETable)aEBinaryRelationalExpr.getLeftOperand();
        AETable aETable2 = (AETable)aEBinaryRelationalExpr.getRightOperand();
        IBooleanExprHandler iBooleanExprHandler = this.m_opHandlerFactory.createJoinHandler(aETable.getTable(), aETable2.getTable(), aEJoinType);
        if (null == iBooleanExprHandler) {
            return null;
        }
        if (AEJoin.AEJoinType.INNER_JOIN == aEJoinType) {
            object = new AEPassdownFilter(iBooleanExprHandler).passdown(aEBooleanExpr);
            dSIExtJResultSet = ((Pair)object).key();
            aEBooleanExpr = ((Pair)object).value();
        } else {
            if (iBooleanExprHandler.passdown(aEBooleanExpr)) {
                aEBooleanExpr = null;
            }
            dSIExtJResultSet = iBooleanExprHandler.takeResult();
        }
        if (dSIExtJResultSet == null) {
            return null;
        }
        try {
            object = new AETable(dSIExtJResultSet);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        ((AENamedRelationalExpr)object).overrideCorrelationSpec(aETable, aETable2, null);
        this.resolveColumns(aETable, (AETable)object);
        this.resolveColumns(aETable2, (AETable)object);
        if (null == aEBooleanExpr || aEBooleanExpr instanceof AEBooleanTrue) {
            return object;
        }
        return this.passdownJoinCond(aEBooleanExpr, (AETable)object);
    }

    private AERelationalExpr passdownJoinCond(AEBooleanExpr aEBooleanExpr, AETable aETable) {
        assert (aEBooleanExpr != null);
        assert (!(aEBooleanExpr instanceof AEBooleanTrue));
        assert (aETable != null);
        assert (aETable.getTable() != null);
        IBooleanExprHandler iBooleanExprHandler = this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
        if (iBooleanExprHandler != null) {
            Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aEBooleanExpr);
            if (pair.key() != null) {
                aETable.setTable(pair.key());
            }
            if (pair.value() == null) {
                return aETable;
            }
        }
        return new AESelect(aETable, aEBooleanExpr);
    }

    private void resolveColumns(AETable aETable, AETable aETable2) {
        DSIExtJResultSet dSIExtJResultSet = aETable2.getTable();
        DSIExtJResultSet dSIExtJResultSet2 = aETable.getTable();
        AETreeWalker aETreeWalker = new AETreeWalker(this.getRoot(aETable));
        while (aETreeWalker.hasNext()) {
            int n;
            AEColumnReference aEColumnReference;
            IAENode iAENode = aETreeWalker.next();
            if (!(iAENode instanceof AEColumnReference) || (aEColumnReference = (AEColumnReference)iAENode).getNamedRelationalExpr() != aETable) continue;
            try {
                n = dSIExtJResultSet.resolveColumn(dSIExtJResultSet2, aEColumnReference.getColumnNum());
            }
            catch (ErrorException errorException) {
                throw new RuntimeException(errorException);
            }
            aEColumnReference.setNamedRelationalExpr(aETable2);
            aEColumnReference.setColumnNum(n);
        }
    }

    private IAENode getRoot(AETable aETable) {
        IAENode iAENode = aETable.getParent();
        while (iAENode.getParent() != null && !this.isSubQuery(iAENode)) {
            iAENode = iAENode.getParent();
        }
        return iAENode;
    }

    private boolean isSubQuery(IAENode iAENode) {
        return iAENode instanceof AESubQuery || iAENode instanceof AEValueSubQuery;
    }
}

