/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl;

import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.RSAKey;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class RSAKeyUtils {
    public static PrivateKey toRSAPrivateKey(RSAKey rsaJWK) throws JOSEException {
        if (!rsaJWK.isPrivate()) {
            throw new JOSEException("The RSA JWK doesn't contain a private part");
        }
        return rsaJWK.toPrivateKey();
    }

    public static int keyBitLength(PrivateKey privateKey) {
        if (!(privateKey instanceof RSAPrivateKey)) {
            return -1;
        }
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privateKey;
        try {
            return rsaPrivateKey.getModulus().bitLength();
        }
        catch (Exception e) {
            return -1;
        }
    }
}

