/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto;

import com.databricks.client.jdbc42.internal.nimbusjose.CriticalHeaderParamsAware;
import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSVerifier;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.CriticalHeaderParamsDeferral;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.RSASSA;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.RSASSAProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.RSAKey;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import com.databricks.client.jdbc42.internal.nimbusjose.util.Base64URL;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import java.util.Set;

@ThreadSafe
public class RSASSAVerifier
extends RSASSAProvider
implements JWSVerifier,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final RSAPublicKey publicKey;

    public RSASSAVerifier(RSAPublicKey publicKey) {
        this(publicKey, null);
    }

    public RSASSAVerifier(RSAKey rsaJWK) throws JOSEException {
        this(rsaJWK.toRSAPublicKey(), null);
    }

    public RSASSAVerifier(RSAPublicKey publicKey, Set<String> defCritHeaders) {
        this.publicKey = Objects.requireNonNull(publicKey);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getDeferredCriticalHeaderParams();
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        if (!this.critPolicy.headerPasses(header)) {
            return false;
        }
        Signature verifier = RSASSA.getSignerAndVerifier(header.getAlgorithm(), this.getJCAContext().getProvider());
        try {
            verifier.initVerify(this.publicKey);
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid public RSA key: " + e.getMessage(), e);
        }
        try {
            verifier.update(signedContent);
            return verifier.verify(signature.decode());
        }
        catch (SignatureException e) {
            return false;
        }
    }
}

