/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.message;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.EntryMessage;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.ExitMessage;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.FlowMessage;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.FlowMessageFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.Message;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.ParameterizedMessageFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.ReusableMessage;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.util.StringBuilderFormattable;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.util.StringBuilders;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.util.Strings;
import java.io.Serializable;

public class DefaultFlowMessageFactory
implements FlowMessageFactory,
Serializable {
    private static final String EXIT_DEFAULT_PREFIX = "Exit";
    private static final String ENTRY_DEFAULT_PREFIX = "Enter";
    private static final long serialVersionUID = 8578655591131397576L;
    public static final FlowMessageFactory INSTANCE = new DefaultFlowMessageFactory();
    private final String entryText;
    private final String exitText;

    public DefaultFlowMessageFactory() {
        this(ENTRY_DEFAULT_PREFIX, EXIT_DEFAULT_PREFIX);
    }

    public DefaultFlowMessageFactory(String entryText, String exitText) {
        this.entryText = entryText;
        this.exitText = exitText;
    }

    public String getEntryText() {
        return this.entryText;
    }

    public String getExitText() {
        return this.exitText;
    }

    @Override
    public EntryMessage newEntryMessage(String format, Object ... params) {
        Message message;
        boolean hasFormat = Strings.isNotEmpty(format);
        if (params == null || params.length == 0) {
            message = hasFormat ? ParameterizedMessageFactory.INSTANCE.newMessage(format) : null;
        } else if (hasFormat) {
            message = ParameterizedMessageFactory.INSTANCE.newMessage(format, params);
        } else {
            StringBuilder sb = new StringBuilder("params(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("{}");
            }
            sb.append(")");
            message = ParameterizedMessageFactory.INSTANCE.newMessage(sb.toString(), params);
        }
        return this.newEntryMessage(message);
    }

    @Override
    public EntryMessage newEntryMessage(Message message) {
        return new SimpleEntryMessage(this.entryText, this.makeImmutable(message));
    }

    private Message makeImmutable(Message message) {
        if (message instanceof ReusableMessage) {
            return ((ReusableMessage)message).memento();
        }
        return message;
    }

    @Override
    public ExitMessage newExitMessage(String format, Object result) {
        boolean hasFormat = Strings.isNotEmpty(format);
        Message message = result == null ? (hasFormat ? ParameterizedMessageFactory.INSTANCE.newMessage(format) : null) : ParameterizedMessageFactory.INSTANCE.newMessage(hasFormat ? format : "with({})", result);
        return this.newExitMessage(message);
    }

    @Override
    public ExitMessage newExitMessage(Message message) {
        return new SimpleExitMessage(this.exitText, message);
    }

    @Override
    public ExitMessage newExitMessage(EntryMessage message) {
        return new SimpleExitMessage(this.exitText, message);
    }

    @Override
    public ExitMessage newExitMessage(Object result, EntryMessage message) {
        return new SimpleExitMessage(this.exitText, result, message);
    }

    @Override
    public ExitMessage newExitMessage(Object result, Message message) {
        return new SimpleExitMessage(this.exitText, result, message);
    }

    private static final class SimpleEntryMessage
    extends AbstractFlowMessage
    implements EntryMessage {
        private static final long serialVersionUID = 1L;

        SimpleEntryMessage(String entryText, Message message) {
            super(entryText, message);
        }
    }

    private static final class SimpleExitMessage
    extends AbstractFlowMessage
    implements ExitMessage {
        private static final long serialVersionUID = 1L;
        private final Object result;
        private final boolean isVoid;

        SimpleExitMessage(String exitText, EntryMessage message) {
            this(exitText, message.getMessage());
        }

        SimpleExitMessage(String exitText, Message message) {
            super(exitText, message);
            this.result = null;
            this.isVoid = true;
        }

        SimpleExitMessage(String exitText, Object result, EntryMessage message) {
            this(exitText, result, message.getMessage());
        }

        SimpleExitMessage(String exitText, Object result, Message message) {
            super(exitText, message);
            this.result = result;
            this.isVoid = false;
        }

        @Override
        public String getFormattedMessage() {
            String formattedMessage = super.getFormattedMessage();
            if (this.isVoid) {
                return formattedMessage;
            }
            return formattedMessage + ": " + this.result;
        }
    }

    private static class AbstractFlowMessage
    implements FlowMessage,
    StringBuilderFormattable {
        private static final long serialVersionUID = 1L;
        private final Message message;
        private final String text;

        AbstractFlowMessage(String text, Message message) {
            this.message = message;
            this.text = text;
        }

        @Override
        public String getFormattedMessage() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormattedMessage();
            }
            return this.text;
        }

        @Override
        public String getFormat() {
            if (this.message != null) {
                return this.text + " " + this.message.getFormat();
            }
            return this.text;
        }

        @Override
        public Object[] getParameters() {
            if (this.message != null) {
                return this.message.getParameters();
            }
            return null;
        }

        @Override
        public Throwable getThrowable() {
            if (this.message != null) {
                return this.message.getThrowable();
            }
            return null;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void formatTo(StringBuilder buffer) {
            buffer.append(this.text);
            if (this.message != null) {
                buffer.append(" ");
                StringBuilders.appendValue(buffer, this.message);
            }
        }
    }
}

