/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.properties;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.LoggerContext;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.ConfigurationException;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.ConfigurationFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.ConfigurationSource;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.Order;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.plugins.Plugin;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@Plugin(name="PropertiesConfigurationFactory", category="ConfigurationFactory")
@Order(value=8)
public class PropertiesConfigurationFactory
extends ConfigurationFactory {
    @Override
    protected String[] getSupportedTypes() {
        return new String[]{".properties"};
    }

    @Override
    public PropertiesConfiguration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        Properties properties = new Properties();
        try (InputStream configStream = source.getInputStream();){
            properties.load(configStream);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to load " + source.toString(), ioe);
        }
        return new PropertiesConfigurationBuilder().setConfigurationSource(source).setRootProperties(properties).setLoggerContext(loggerContext).build();
    }
}

