/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector;

import com.databricks.client.jdbc42.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.client.jdbc42.internal.apache.arrow.memory.ReusableBuffer;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.BaseVariableWidthViewVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.NullCheckingForGet;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueIterableVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.ViewVarCharReaderImpl;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.reader.FieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableViewVarCharHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.ViewVarCharHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.Text;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.TransferPair;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.validate.ValidateUtil;

public final class ViewVarCharVector
extends BaseVariableWidthViewVector
implements ValueIterableVector<Text> {
    public ViewVarCharVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.VIEWVARCHAR.getType()), allocator);
    }

    public ViewVarCharVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public ViewVarCharVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new ViewVarCharReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.VIEWVARCHAR;
    }

    @Override
    public byte[] get(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        return this.getData(index);
    }

    @Override
    public Text getObject(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        Text result = new Text();
        this.read(index, result);
        return result;
    }

    @Override
    public void read(int index, ReusableBuffer<?> buffer) {
        this.getData(index, buffer);
    }

    public void get(int index, NullableViewVarCharHolder holder) {
        throw new UnsupportedOperationException("NullableViewVarCharHolder get operation not supported");
    }

    public void set(int index, ViewVarCharHolder holder) {
        throw new UnsupportedOperationException("ViewVarCharHolder set operation not supported");
    }

    public void setSafe(int index, ViewVarCharHolder holder) {
        throw new UnsupportedOperationException("ViewVarCharHolder setSafe operation not supported");
    }

    public void set(int index, NullableViewVarCharHolder holder) {
        throw new UnsupportedOperationException("NullableViewVarCharHolder set operation not supported");
    }

    public void setSafe(int index, NullableViewVarCharHolder holder) {
        throw new UnsupportedOperationException("NullableViewVarCharHolder setSafe operation not supported");
    }

    public void set(int index, Text text) {
        this.set(index, text.getBytes(), 0, (int)text.getLength());
    }

    public void setSafe(int index, Text text) {
        this.setSafe(index, text.getBytes(), 0, (int)text.getLength());
    }

    @Override
    public void validateScalars() {
        for (int i = 0; i < this.getValueCount(); ++i) {
            byte[] value = this.get(i);
            if (value == null) continue;
            ValidateUtil.validateOrThrow(Text.validateUTF8NoThrow(value), "Non-UTF-8 data in VarCharVector at position " + i + ".");
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((ViewVarCharVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        ViewVarCharVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new ViewVarCharVector(ref, ViewVarCharVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new ViewVarCharVector(field, allocator);
        }

        public TransferImpl(ViewVarCharVector to) {
            this.to = to;
        }

        @Override
        public ViewVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            ViewVarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            ViewVarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, ViewVarCharVector.this);
        }
    }
}

