/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc41;

import com.databricks.client.dsi.core.interfaces.IConnection;
import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.interfaces.IResults;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResultType;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.jdbc.common.SCallableStatement;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SForwardResultSet;
import com.databricks.client.jdbc.common.SResultSetMetaData;
import com.databricks.client.jdbc.jdbc41.S41Array;
import com.databricks.client.jdbc.jdbc41.S41ForwardResultSet;
import com.databricks.client.jdbc.jdbc41.S41ParameterMetaData;
import com.databricks.client.jdbc.jdbc41.S41ResultSetMetaData;
import com.databricks.client.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.utilities.JDBCVersion;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

public class S41CallableStatement
extends SCallableStatement {
    public S41CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S41UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S41ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults iResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = iResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (iterator.hasNext()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
                }
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(iResultSet));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet iResultSet) throws SQLException {
        try {
            List<? extends IColumn> list = iResultSet.getSelectColumns();
            if (null == list) {
                return null;
            }
            return new S41ResultSetMetaData(list, this.getLogger(), this.getWarningListener());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData s41ParameterMetaData = null;
                s41ParameterMetaData = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s41ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            if (clazz.equals(BigDecimal.class)) {
                return (T)this.getBigDecimal(n);
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                boolean bl = this.getBoolean(n);
                return (T)(this.wasNull() ? null : Boolean.valueOf(bl));
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                byte by = this.getByte(n);
                return (T)(this.wasNull() ? null : Byte.valueOf(by));
            }
            if (clazz.equals(byte[].class)) {
                return (T)this.getBytes(n);
            }
            if (clazz.equals(Date.class)) {
                return (T)this.getDate(n);
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                double d = this.getDouble(n);
                return (T)(this.wasNull() ? null : Double.valueOf(d));
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                float f = this.getFloat(n);
                return (T)(this.wasNull() ? null : Float.valueOf(f));
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                int n2 = this.getInt(n);
                return (T)(this.wasNull() ? null : Integer.valueOf(n2));
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                long l = this.getLong(n);
                return (T)(this.wasNull() ? null : Long.valueOf(l));
            }
            if (clazz.equals(Object.class)) {
                return (T)this.getObject(n);
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                short s = this.getShort(n);
                return (T)(this.wasNull() ? null : Short.valueOf(s));
            }
            if (clazz.equals(String.class)) {
                return (T)this.getString(n);
            }
            if (clazz.equals(Time.class)) {
                return (T)this.getTime(n);
            }
            if (clazz.equals(Timestamp.class)) {
                return (T)this.getTimestamp(n);
            }
            if (clazz.equals(Blob.class)) {
                return (T)this.getBlob(n);
            }
            if (clazz.equals(Clob.class)) {
                return (T)this.getClob(n);
            }
            if (clazz.equals(Array.class) || clazz.equals(URL.class) || clazz.equals(NClob.class) || clazz.equals(Ref.class) || clazz.equals(RowId.class) || clazz.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n), clazz.getName());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.getParameterIndex(string), clazz);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            IConnection iConnection = this.getParentConnection().getConnection();
            return new S41Array(dataWrapper.getArray(), iConnection, this.m_logger, this.m_warningListener);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

