/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.common;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceID;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.jdbc.common.BaseDatabaseMetaData;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SForwardResultSet;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.utilities.JDBCVersion;
import com.databricks.client.utilities.MetaDataFactory;
import com.databricks.client.utilities.TypeNames;
import com.databricks.client.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class SMetaDataProxy
extends SForwardResultSet {
    private MetadataSourceID m_metadataType = null;
    private int[] m_columnMap = null;
    private int m_dataTypeColIndex = -1;
    private DatabaseMetaData m_parentMetaData = null;

    protected SMetaDataProxy(DatabaseMetaData databaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger, JDBCVersion jDBCVersion) throws SQLException {
        super(((SConnection)databaseMetaData.getConnection()).getConnection(), iResultSet, iLogger);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{databaseMetaData, iResultSet, metadataSourceID, iLogger});
            this.m_parentMetaData = databaseMetaData;
            this.m_metadataType = metadataSourceID;
            this.m_warningListener = super.getWarningListener();
            this.m_warningListener.setLocale(this.getParentConnection().getLocale());
            this.m_jdbcVersion = jDBCVersion;
            this.m_streamBufferSize = this.getStreamBufferSize();
            this.initializeColumnMap(metadataSourceID);
            this.initializeDataTypeColIndex(metadataSourceID);
            this.initializeColumnNameMap();
            if (MetadataSourceID.CATALOG_ONLY == this.m_metadataType || MetadataSourceID.CATALOG_SCHEMA_ONLY == this.m_metadataType || MetadataSourceID.SCHEMA_ONLY == this.m_metadataType || MetadataSourceID.TABLETYPE_ONLY == this.m_metadataType) {
                while (this.m_cachedDataWrappers.size() < 4) {
                    this.m_cachedDataWrappers.add(new DataWrapper());
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_parentMetaData) {
            ((BaseDatabaseMetaData)this.m_parentMetaData).removeResultSet(this);
            this.m_parentMetaData = null;
        }
        super.close();
    }

    @Override
    public Array getArray(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getArray(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getAsciiStream(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return BigDecimal.valueOf(TypeUtilities.mapDataTypes(super.getInt(n2)));
            }
            return super.getBigDecimal(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int n3 = this.getMappedColumnIndex(n);
            if (n3 == this.m_dataTypeColIndex) {
                return BigDecimal.valueOf(TypeUtilities.mapDataTypes(super.getInt(n3)), n2);
            }
            return super.getBigDecimal(n3, n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getBinaryStream(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getBlob(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return false;
            }
            return super.getBoolean(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return 0;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return (byte)TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            return super.getByte(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getBytes(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getCharacterStream(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getClob(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getDate(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getDate(this.getMappedColumnIndex(n), calendar);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return 0.0;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            return super.getDouble(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return 0.0f;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            return super.getFloat(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_parentMetaData.getConnection().getHoldability();
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return 0;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            return super.getInt(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return 0L;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            return super.getLong(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    protected void generateMetadataList() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            List<ColumnMetadata> list = null;
            switch (this.m_metadataType) {
                case ATTRIBUTES: {
                    list = MetaDataFactory.createAttributeMetaData();
                    break;
                }
                case CATALOG_ONLY: {
                    list = MetaDataFactory.createCatalogOnlyMetaData();
                    break;
                }
                case COLUMN_PRIVILEGES: {
                    list = MetaDataFactory.createColumnPrivilegesMetaData();
                    break;
                }
                case COLUMNS: {
                    list = MetaDataFactory.createColumnsMetaData(this.m_jdbcVersion);
                    break;
                }
                case FOREIGN_KEYS: {
                    list = MetaDataFactory.createForeignKeysMetaData();
                    break;
                }
                case FUNCTION_COLUMNS_JDBC4: {
                    list = MetaDataFactory.createFunctionColumnsMetaData();
                    break;
                }
                case FUNCTIONS_JDBC4: {
                    list = MetaDataFactory.createFunctionsMetaData();
                    break;
                }
                case STATISTICS: {
                    list = MetaDataFactory.createIndexInfoMetaData();
                    break;
                }
                case PRIMARY_KEYS: {
                    list = MetaDataFactory.createPrimaryKeysMetaData();
                    break;
                }
                case PROCEDURE_COLUMNS: {
                    list = MetaDataFactory.createProcedureColumnsMetaData(this.m_jdbcVersion);
                    break;
                }
                case PROCEDURES: {
                    list = MetaDataFactory.createProceduresMetaData(this.m_jdbcVersion);
                    break;
                }
                case PSEUDO_COLUMNS_JDBC41: {
                    list = MetaDataFactory.createPseudoColumnsMetaData();
                    break;
                }
                case SCHEMA_ONLY: 
                case CATALOG_SCHEMA_ONLY: {
                    list = MetaDataFactory.createSchemasOnlyMetaData();
                    break;
                }
                case SPECIAL_COLUMNS: {
                    list = MetaDataFactory.createSpecialColumnsMetaData();
                    break;
                }
                case SUPERTABLES: {
                    list = MetaDataFactory.createSuperTablesMetaData();
                    break;
                }
                case SUPERTYPES: {
                    list = MetaDataFactory.createSuperTypesMetaData();
                    break;
                }
                case TABLE_PRIVILEGES: {
                    list = MetaDataFactory.createTablePrivilegesMetaData();
                    break;
                }
                case TABLETYPE_ONLY: {
                    list = MetaDataFactory.createTableTypesMetaData();
                    break;
                }
                case TABLES: {
                    list = MetaDataFactory.createTablesMetaData();
                    break;
                }
                case TYPE_INFO: {
                    list = MetaDataFactory.createTypeInfoMetaData();
                    break;
                }
                case UDT: {
                    list = MetaDataFactory.createUDTMetaData();
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_METADATA_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf((Object)this.m_metadataType));
                }
            }
            this.m_resultSetColumns = list;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            DataWrapper dataWrapper = this.getData(n2, -1L);
            try {
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                Object object = TypeConverter.toObject(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = dataWrapper.isNull();
                return object;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, map);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getObject(this.getMappedColumnIndex(n), map);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getRef(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return 0;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return (short)TypeUtilities.mapDataTypes(super.getInt(n2));
            }
            return super.getShort(n2);
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int n2 = this.getMappedColumnIndex(n);
            if (n2 == this.m_dataTypeColIndex) {
                return String.valueOf(TypeUtilities.mapDataTypes(super.getInt(n2)));
            }
            DataWrapper dataWrapper = this.getData(n2, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toString(dataWrapper, iColumn.getTypeMetadata());
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            DataWrapper dataWrapper = this.getData(this.getMappedColumnIndex(n), -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTime(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            DataWrapper dataWrapper = this.getData(this.getMappedColumnIndex(n), -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTimestamp(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getUnicodeStream(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        try {
            if (this.shouldReturnNull(n)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getURL(this.getMappedColumnIndex(n));
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public synchronized void checkIfOpen() throws SQLException {
        super.checkIfOpen();
        if (null == this.m_parentMetaData) {
            this.close();
            super.checkIfOpen();
            throw new RuntimeException("Should never get here!");
        }
    }

    @Override
    public void checkIfValidColumnNumber(int n) throws SQLException {
        for (int i = 0; i < this.m_columnMap.length; ++i) {
            if (this.m_columnMap[i] != n) continue;
            return;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
    }

    private int getMappedColumnIndex(int n) throws SQLException {
        if (null == this.m_columnMap) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_METADATA_COLUMNMAP, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        try {
            return this.m_columnMap[n - 1];
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
    }

    private void initializeColumnMap(MetadataSourceID metadataSourceID) {
        int n;
        switch (metadataSourceID) {
            case CATALOG_ONLY: {
                this.m_columnMap = new int[1];
                this.m_columnMap[0] = 1;
                break;
            }
            case SCHEMA_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                this.m_columnMap = new int[2];
                this.m_columnMap[0] = 2;
                this.m_columnMap[1] = 1;
                break;
            }
            case TABLETYPE_ONLY: {
                this.m_columnMap = new int[1];
                this.m_columnMap[0] = 4;
                break;
            }
            case COLUMN_PRIVILEGES: {
                this.m_columnMap = new int[8];
                break;
            }
            case COLUMNS: {
                this.m_columnMap = new int[24];
                break;
            }
            case FOREIGN_KEYS: {
                this.m_columnMap = new int[14];
                break;
            }
            case FUNCTION_COLUMNS_JDBC4: {
                this.m_columnMap = new int[17];
                break;
            }
            case PSEUDO_COLUMNS_JDBC41: {
                this.m_columnMap = new int[12];
                break;
            }
            case FUNCTIONS_JDBC4: {
                this.m_columnMap = new int[6];
                break;
            }
            case STATISTICS: {
                this.m_columnMap = new int[13];
                break;
            }
            case PRIMARY_KEYS: {
                this.m_columnMap = new int[6];
                break;
            }
            case PROCEDURE_COLUMNS: {
                this.m_columnMap = new int[20];
                break;
            }
            case PROCEDURES: {
                this.m_columnMap = new int[9];
                break;
            }
            case SPECIAL_COLUMNS: {
                this.m_columnMap = new int[8];
                break;
            }
            case SUPERTABLES: {
                this.m_columnMap = new int[4];
                break;
            }
            case SUPERTYPES: {
                this.m_columnMap = new int[6];
                break;
            }
            case TABLE_PRIVILEGES: {
                this.m_columnMap = new int[7];
                break;
            }
            case TABLES: {
                this.m_columnMap = new int[10];
                break;
            }
            case TYPE_INFO: {
                this.m_columnMap = new int[18];
                break;
            }
            case UDT: {
                this.m_columnMap = new int[7];
                break;
            }
            case ATTRIBUTES: {
                this.m_columnMap = new int[21];
                break;
            }
            default: {
                return;
            }
        }
        if (MetadataSourceID.CATALOG_ONLY != this.m_metadataType && MetadataSourceID.CATALOG_SCHEMA_ONLY != this.m_metadataType && MetadataSourceID.SCHEMA_ONLY != this.m_metadataType && MetadataSourceID.TABLETYPE_ONLY != this.m_metadataType) {
            for (n = 0; n < this.m_columnMap.length; ++n) {
                this.m_columnMap[n] = n + 1;
            }
        }
        if (MetadataSourceID.COLUMNS == this.m_metadataType) {
            for (n = 18; n < 22; ++n) {
                this.m_columnMap[n] = n + 2;
            }
            this.m_columnMap[22] = 19;
            this.m_columnMap[23] = 21;
        }
    }

    private void initializeDataTypeColIndex(MetadataSourceID metadataSourceID) {
        switch (metadataSourceID) {
            case ATTRIBUTES: 
            case COLUMNS: 
            case UDT: {
                this.m_dataTypeColIndex = 5;
                break;
            }
            case SPECIAL_COLUMNS: {
                this.m_dataTypeColIndex = 3;
                break;
            }
            case PROCEDURE_COLUMNS: {
                this.m_dataTypeColIndex = 6;
                break;
            }
            case TYPE_INFO: {
                this.m_dataTypeColIndex = 2;
                break;
            }
        }
    }

    private boolean shouldReturnNull(int n) {
        boolean bl = false;
        if (MetadataSourceID.COLUMNS.equals((Object)this.m_metadataType)) {
            bl = 18 < n && 23 > n;
        } else if (MetadataSourceID.TABLES.equals((Object)this.m_metadataType)) {
            bl = 5 < n && 11 > n;
        }
        return bl;
    }
}

