/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.telemetry;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.telemetry.TelemetryExecContext;
import com.databricks.client.hivecommon.telemetry.TelemetryTask;
import com.databricks.client.jdbc.common.CommonUtils;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.databricks.client.jdbc42.internal.apache.http.HttpHost;
import com.databricks.client.jdbc42.internal.apache.http.auth.AuthScope;
import com.databricks.client.jdbc42.internal.apache.http.auth.UsernamePasswordCredentials;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.NoopHostnameVerifier;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;

public class TelemetryManager {
    private TelemetryTask m_telemetryTask;
    private ILogger m_logger;
    private volatile boolean m_isEnabled;
    private Thread m_thread;

    public TelemetryManager(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        this.m_isEnabled = hiveJDBCSettings.m_enableTelemetry;
        this.m_logger = iLogger;
        if (this.m_isEnabled) {
            CloseableHttpClient closeableHttpClient = this.createHttpClient(hiveJDBCSettings);
            LogUtilities.logDebug("Telemetry has been enabled. Starting telemetry thread....", iLogger);
            this.m_telemetryTask = new TelemetryTask(hiveJDBCSettings, closeableHttpClient, iLogger);
            this.m_thread = new Thread(this.m_telemetryTask);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        } else {
            LogUtilities.logDebug("Telemetry has been disabled.", iLogger);
        }
    }

    public synchronized void stopTelemetryThread() {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.stopTelemetry();
                try {
                    this.m_thread.join();
                }
                catch (InterruptedException interruptedException) {
                    LogUtilities.logDebug("Interuption happened during closing of telemetry thread.", this.m_logger);
                }
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void addTelemetryLog(String string, long l) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.addTelemetryLog(string, l);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void addTelemetryLog(String string, long l, boolean bl, TelemetryExecContext telemetryExecContext) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.addTelemetryLog(string, l, "", bl, telemetryExecContext);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void addTelemetryLog() {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.addTelemetryLog(null, 0L);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void AddTelemetryErrorLog(String string, long l) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.addTelemetryErrorLog(null, null, string, l);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void AddTelemetryErrorLog(String string, String string2, long l) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.addTelemetryErrorLog(string, "", string2, l);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void AddTelemetryErrorLog(String string, ErrorException errorException, long l) {
        block7: {
            try {
                if (!this.m_isEnabled || errorException == null) break block7;
                String string2 = errorException.getMessage();
                if (errorException.getMessageParams() != null) {
                    for (String string3 : errorException.getMessageParams()) {
                        string2 = string2 + ", " + string3;
                    }
                } else if (errorException.getStackTrace() != null) {
                    for (StackTraceElement stackTraceElement : errorException.getStackTrace()) {
                        string2 = string2 + ", " + stackTraceElement.toString();
                    }
                }
                this.m_telemetryTask.addTelemetryErrorLog(string, errorException.getCustomState(), string2, l);
            }
            catch (Exception exception) {
                LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
                LogUtilities.logWarning(exception, this.m_logger);
            }
        }
    }

    public synchronized void AddTelemetryErrorLog(ErrorException errorException) {
        block7: {
            try {
                if (!this.m_isEnabled || errorException == null) break block7;
                String string = errorException.getMessage();
                if (errorException.getMessageParams() != null) {
                    for (String string2 : errorException.getMessageParams()) {
                        string = string + ", " + string2;
                    }
                } else if (errorException.getStackTrace() != null) {
                    for (StackTraceElement stackTraceElement : errorException.getStackTrace()) {
                        string = string + ", " + stackTraceElement.toString();
                    }
                }
                this.m_telemetryTask.addTelemetryErrorLog(null, errorException.getCustomState(), string, 0L);
            }
            catch (Exception exception) {
                LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
                LogUtilities.logWarning(exception, this.m_logger);
            }
        }
    }

    public synchronized void addOpenSessionLog(TOpenSessionResp tOpenSessionResp, long l) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.addOpenSessionLog(tOpenSessionResp, l);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void setAuthToken(String string) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.setAuthToken(string);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    public synchronized void setClientAppInfo(String string) {
        try {
            if (this.m_isEnabled) {
                this.m_telemetryTask.setClientAppInfo(string);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Failed to log telemetry.", this.m_logger);
            LogUtilities.logWarning(exception, this.m_logger);
        }
    }

    private CloseableHttpClient createHttpClient(HiveJDBCSettings hiveJDBCSettings) {
        CloseableHttpClient closeableHttpClient = null;
        int n = hiveJDBCSettings.m_timeout;
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n);
        try {
            Object object;
            SSLConnectionSocketFactory sSLConnectionSocketFactory = CommonUtils.getSSLConnectionSocketFactory(hiveJDBCSettings.m_host, hiveJDBCSettings.m_serverSSLSettings);
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setSSLSocketFactory(sSLConnectionSocketFactory);
            if (hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatch || hiveJDBCSettings.m_serverSSLSettings.m_allowSelfSigned) {
                httpClientBuilder.setSSLHostnameVerifier(new NoopHostnameVerifier());
            }
            if (hiveJDBCSettings.m_proxySettings.m_useProxy && !CommonUtils.isHostInProxyBypassList(hiveJDBCSettings.m_proxySettings, hiveJDBCSettings.m_host)) {
                object = hiveJDBCSettings.m_proxySettings;
                HttpHost httpHost = new HttpHost(((ProxySettings)object).m_proxyHost, ((ProxySettings)object).m_proxyPort);
                builder.setProxy(httpHost);
                if (((ProxySettings)object).m_proxyAuth == ProxySettings.ProxyAuthentication.BASIC) {
                    BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                    AuthScope authScope = new AuthScope(((ProxySettings)object).m_proxyHost, ((ProxySettings)object).m_proxyPort);
                    UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(((ProxySettings)object).m_proxyUid, ((ProxySettings)object).m_proxyPwd);
                    basicCredentialsProvider.setCredentials(authScope, usernamePasswordCredentials);
                    httpClientBuilder.setDefaultCredentialsProvider(basicCredentialsProvider);
                }
            }
            object = builder.build();
            closeableHttpClient = httpClientBuilder.setDefaultRequestConfig((RequestConfig)object).build();
        }
        catch (Exception exception) {
            this.m_isEnabled = false;
            LogUtilities.logInfo("Telemetry failed in creating http client.", this.m_logger);
            LogUtilities.logInfo(exception, this.m_logger);
        }
        return closeableHttpClient;
    }
}

