/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.exceptions.ErrorException;
import java.text.DateFormatSymbols;
import java.util.List;

public final class ETDayNameFn
extends ETScalarFn {
    private final int m_columnLength;
    private String[] m_weekDays;

    public ETDayNameFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        if (1 != list.size() || 1 != list2.size()) {
            throw new IllegalArgumentException("Invalid Number of arguments for DAYNAME scalar function.");
        }
        short s = list2.get(0).getTypeMetadata().getType();
        if (91 != s) {
            throw new IllegalArgumentException();
        }
        this.m_columnLength = (int)Math.min(iColumn.getColumnLength(), Integer.MAX_VALUE);
    }

    @Override
    public String getLogString() {
        return "ETDayNameFn";
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        this.m_weekDays = new DateFormatSymbols().getWeekdays();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String[] stringArray = this.m_weekDays;
        String string = stringArray[1 + iSqlDataWrapper.getDate().getDay()];
        eTDataRequest.getData().setChar(string);
        return DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), this.m_columnLength, this.getWarningListener());
    }
}

