/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.metadatautil;

import com.databricks.client.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.generated.CoercionTable;
import com.databricks.client.sqlengine.dsiext.dataengine.IColumnInfo;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.exceptions.ErrorException;

class AESqlTypeCoercer {
    private CoercionTable m_coercionTable = new CoercionTable();

    public int coerceType(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo2.getType());
        if (!(coercionOperation != AEMetadataCoercionHandler.CoercionOperation.CONCAT && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.LIKE || AESqlTypeCoercer.isAnyCharType(sqlTypes) && AESqlTypeCoercer.isAnyCharType(sqlTypes2))) {
            if (AESqlTypeCoercer.isAnyCharType(sqlTypes)) {
                return sqlTypes.getSqlType();
            }
            if (AESqlTypeCoercer.isAnyCharType(sqlTypes2)) {
                return sqlTypes2.getSqlType();
            }
            return SqlTypes.SQL_CHAR.getSqlType();
        }
        CoercionTable.Operation operation = this.getCoercionTableOpertion(coercionOperation);
        if (sqlTypes.isInteger() && !iColumnInfo.isSigned() && (!sqlTypes2.isNumber() || iColumnInfo2.isSigned())) {
            sqlTypes = AESqlTypeCoercer.upIntegerType(sqlTypes);
        } else if (sqlTypes2.isInteger() && !iColumnInfo2.isSigned() && (!sqlTypes.isNumber() || iColumnInfo.isSigned())) {
            sqlTypes2 = AESqlTypeCoercer.upIntegerType(sqlTypes2);
        }
        int n = sqlTypes.getSqlType();
        int n2 = sqlTypes2.getSqlType();
        if (!this.m_coercionTable.isCoercionSupported(operation, n, n2)) {
            throw SQLEngineExceptionFactory.unsupportedTypesException(n + " or " + n2);
        }
        int n3 = this.m_coercionTable.getEntry(operation, n, n2);
        if (n3 == Integer.MIN_VALUE) {
            throw SQLEngineExceptionFactory.incompatibleTypesException(operation.name(), sqlTypes.name() + " and " + sqlTypes2.name());
        }
        return n3;
    }

    public void overrideCoercionType(AEMetadataCoercionHandler.CoercionOperation coercionOperation, int n, int n2, int n3) throws ErrorException {
        if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.LIKE || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.CONCAT) {
            throw new IllegalArgumentException("can not override coercion type for LIKE or CONCAT operation.");
        }
        CoercionTable.Operation operation = this.getCoercionTableOpertion(coercionOperation);
        if (!this.m_coercionTable.isCoercionSupported(operation, n, n2)) {
            throw SQLEngineExceptionFactory.unsupportedTypesException(n + " or " + n2);
        }
        this.m_coercionTable.overrideEntry(operation, n, n2, n3);
    }

    private CoercionTable.Operation getCoercionTableOpertion(AEMetadataCoercionHandler.CoercionOperation coercionOperation) {
        switch (coercionOperation) {
            case COMPARISON: 
            case LIKE: 
            case IN: {
                return CoercionTable.Operation.BOOLEAN;
            }
            case SET_OPERATION: {
                return CoercionTable.Operation.SET_OPERATION;
            }
            case DIVISION: {
                return CoercionTable.Operation.DIVISION;
            }
            case MINUS: {
                return CoercionTable.Operation.BINARYMINUS;
            }
            case CONCAT: 
            case PLUS: {
                return CoercionTable.Operation.BINARYPLUS;
            }
            case MULTIPLICATION: {
                return CoercionTable.Operation.MULTIPLICATION;
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + coercionOperation.name());
    }

    public static SqlTypes upIntegerType(SqlTypes sqlTypes) {
        assert (sqlTypes.isInteger());
        switch (sqlTypes) {
            case SQL_TINYINT: {
                return SqlTypes.SQL_SMALLINT;
            }
            case SQL_SMALLINT: {
                return SqlTypes.SQL_INTEGER;
            }
            case SQL_INTEGER: 
            case SQL_BIGINT: {
                return SqlTypes.SQL_BIGINT;
            }
        }
        throw new IllegalArgumentException("type must be an integer type: " + (Object)((Object)sqlTypes));
    }

    private static boolean isAnyCharType(SqlTypes sqlTypes) {
        return sqlTypes.isWChar() || sqlTypes.isChar();
    }
}

