/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.common;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLTransportParameters {
    private final String TLS_PROTOCOL = "TLS";
    private final String TLS_1_2_PROTOCOL = "TLSv1.2";
    private String protocol;
    private String keyStore;
    private String keyPass;
    private String keyManagerType = KeyManagerFactory.getDefaultAlgorithm();
    private String keyStoreType = "JKS";
    private String keyStoreProvider;
    private String trustStore;
    private String trustPass;
    private String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
    private String trustStoreType = "JKS";
    private String trustStoreProvider;
    private String[] cipherSuites;
    private boolean clientAuth = false;
    public boolean isKeyStoreSet = false;
    private boolean isTrustStoreSet = false;
    private boolean allowSelfSigned = false;
    private boolean certNamesMismatch = false;
    private boolean hostNameInSAN = true;

    public SSLTransportParameters() {
        this.protocol = System.getProperty("java.version").startsWith("1.6.") ? "TLS" : "TLSv1.2";
    }

    public SSLTransportParameters(String string, String[] stringArray) {
        this(string, stringArray, false);
    }

    public SSLTransportParameters(String string, String[] stringArray, boolean bl) {
        if (string != null) {
            string = System.getProperty("java.version").startsWith("1.6.") ? "TLS" : "TLSv1.2";
        }
        this.cipherSuites = stringArray;
        this.clientAuth = bl;
    }

    public void setKeyStore(String string, String string2, String string3, String string4) {
        this.setKeyStore(string, string2, string3, string4, null);
    }

    public void setKeyStore(String string, String string2, String string3, String string4, String string5) {
        this.keyStore = string;
        this.keyPass = string2;
        if (string3 != null) {
            this.keyManagerType = string3;
        }
        if (string4 != null) {
            this.keyStoreType = string4;
        }
        if (string5 != null) {
            this.keyStoreProvider = string5;
        }
        this.isKeyStoreSet = true;
    }

    public void setKeyStore(String string, String string2) {
        this.setKeyStore(string, string2, null, null);
    }

    public void setTrustStore(String string, String string2, String string3, String string4, String string5) {
        this.trustStore = string;
        this.trustPass = string2;
        if (string3 != null) {
            this.trustManagerType = string3;
        }
        if (string4 != null) {
            this.trustStoreType = string4;
        }
        if (string5 != null) {
            this.trustStoreProvider = string5;
        }
        this.isTrustStoreSet = true;
    }

    public void setTrustStore(String string, String string2, String string3, String string4) {
        this.setTrustStore(string, string2, string3, string4, null);
    }

    public void setTrustStore(String string, String string2) {
        this.setTrustStore(string, string2, null, null);
    }

    public void requireClientAuth(boolean bl) {
        this.clientAuth = bl;
    }

    public void allowSelfSigned(boolean bl) {
        this.allowSelfSigned = bl;
    }

    public void certNamesMismatch(boolean bl) {
        this.certNamesMismatch = bl;
    }

    public void hostNameInSAN(boolean bl) {
        this.hostNameInSAN = bl;
    }

    public boolean isAllowSelfSigned() {
        return this.allowSelfSigned;
    }

    public boolean isCertNamesMismatch() {
        return this.certNamesMismatch;
    }

    public boolean isHostNameInSAN() {
        return this.hostNameInSAN;
    }

    public String getTrustManagerType() {
        return this.trustManagerType;
    }

    public String getTrustPass() {
        return this.trustPass;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public boolean isTrustStoreSet() {
        return this.isTrustStoreSet;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyManagerType() {
        return this.keyManagerType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public boolean getCertNamesMismatch() {
        return this.certNamesMismatch;
    }

    public boolean getAllowSelfSigned() {
        return this.allowSelfSigned;
    }
}

