/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowSet;
import dm.jdbc.driver.Row;
import java.sql.SQLException;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class DmdbRowSetWriter
implements RowSetWriter {
    private StringBuffer m_updateCommand = null;
    private StringBuffer m_insertCommand = null;
    private StringBuffer m_deleteCommand = null;
    private int m_columnCount = 0;
    private String m_tabName = "";
    private DmdbResultSetMetaData m_rsmd = null;
    private DmdbPreparedStatement m_updateStmt = null;
    private DmdbPreparedStatement m_insertStmt = null;
    private DmdbPreparedStatement m_deleteStmt = null;
    private DmdbConnection m_conn = null;

    private void initialize(DmdbRowSet caller) throws SQLException {
        this.m_rsmd = (DmdbResultSetMetaData)caller.getMetaData();
        this.m_columnCount = this.m_rsmd.do_getColumnCount();
        this.m_conn = caller.getConnection();
        this.m_tabName = caller.getTableName().toUpperCase();
        this.m_updateCommand = new StringBuffer("UPDATE " + this.m_tabName + " SET ");
        this.m_insertCommand = new StringBuffer("INSERT INTO " + this.m_tabName + "(");
        this.m_deleteCommand = new StringBuffer("DELETE FROM " + this.m_tabName + " WHERE ");
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            if (i2 > 0) {
                this.m_updateCommand.append(" , ");
                this.m_insertCommand.append(" , ");
            }
            this.m_updateCommand.append(this.m_rsmd.do_getColumnName(i2 + 1)).append(" = ?");
            this.m_insertCommand.append(this.m_rsmd.do_getColumnName(i2 + 1));
            ++i2;
        }
        this.m_insertCommand.append(") VALUES(");
        this.m_updateCommand.append(" WHERE ");
        int j2 = 0;
        while (j2 < this.m_columnCount) {
            if (j2 > 0) {
                this.m_insertCommand.append(",");
                this.m_updateCommand.append(" AND ");
                this.m_deleteCommand.append(" AND ");
            }
            this.m_insertCommand.append("?");
            this.m_updateCommand.append(this.m_rsmd.do_getColumnName(j2 + 1)).append("= ?");
            this.m_deleteCommand.append(this.m_rsmd.do_getColumnName(j2 + 1)).append("= ?");
            ++j2;
        }
        this.m_insertCommand.append(")");
        this.m_insertStmt = this.m_conn.do_prepareStatement(this.m_insertCommand.substring(0, this.m_insertCommand.length()));
        this.m_updateStmt = this.m_conn.do_prepareStatement(this.m_updateCommand.substring(0, this.m_updateCommand.length()));
        this.m_deleteStmt = this.m_conn.do_prepareStatement(this.m_deleteCommand.substring(0, this.m_deleteCommand.length()));
    }

    private boolean insertRow(Row row) throws SQLException {
        this.m_insertStmt.do_clearParameters();
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            Object obj = row.getColumn(i2);
            if (obj == null) {
                this.m_insertStmt.do_setNull(i2 + 1, this.m_rsmd.do_getColumnType(i2 + 1));
            } else {
                this.m_insertStmt.do_setObject(i2 + 1, obj);
            }
            ++i2;
        }
        return 1 == this.m_insertStmt.do_executeUpdate();
    }

    private boolean updateRow(Row row) throws SQLException {
        if (row.isOriginalWithNull()) {
            return this.updateWithNull(row);
        }
        return this.updateNonNull(row);
    }

    private boolean updateWithNull(Row row) throws SQLException {
        StringBuffer updateSql = new StringBuffer("UPDATE " + this.m_tabName + " SET ");
        StringBuffer updateSqlTail = new StringBuffer(" WHERE ");
        int[] tailCols = new int[this.m_columnCount];
        int tailCnt = this.m_columnCount;
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            if (i2 > 0) {
                updateSql.append(" , ");
                updateSqlTail.append(" AND ");
            }
            updateSql.append(this.m_rsmd.do_getColumnName(i2 + 1)).append(" = ?");
            updateSqlTail.append(this.m_rsmd.do_getColumnName(i2 + 1));
            if (row.isOriginalNull(i2)) {
                tailCols[i2] = -1;
                updateSqlTail.append(" IS NULL ");
            } else {
                tailCols[i2] = ++tailCnt;
                updateSqlTail.append(" = ? ");
            }
            ++i2;
        }
        updateSql.append(updateSqlTail);
        DmdbPreparedStatement pstmt = this.m_conn.do_prepareStatement(updateSql.substring(0, updateSql.length()));
        int i3 = 0;
        while (i3 < this.m_columnCount) {
            Object obj;
            Object orgObj = row.getColumn(i3);
            Object object = obj = row.isColumnChanged(i3) ? row.getChangedColumn(i3) : orgObj;
            if (obj == null) {
                pstmt.do_setNull(i3 + 1, this.m_rsmd.do_getColumnType(i3 + 1));
            } else {
                pstmt.do_setObject(i3 + 1, obj);
            }
            if (tailCols[i3] != -1) {
                pstmt.do_setObject(tailCols[i3], orgObj);
            }
            ++i3;
        }
        boolean sus = 1 == pstmt.do_executeUpdate();
        pstmt.do_close();
        updateSql = null;
        updateSqlTail = null;
        return sus;
    }

    private boolean updateNonNull(Row row) throws SQLException {
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            Object obj;
            Object orgObj = row.getColumn(i2);
            Object object = obj = row.isColumnChanged(i2) ? row.getChangedColumn(i2) : orgObj;
            if (obj == null) {
                this.m_updateStmt.do_setNull(i2 + 1, this.m_rsmd.do_getColumnType(i2 + 1));
            } else {
                this.m_updateStmt.do_setObject(i2 + 1, obj);
            }
            this.m_updateStmt.do_setObject(this.m_columnCount + i2 + 1, orgObj);
            ++i2;
        }
        return 1 == this.m_updateStmt.do_executeUpdate();
    }

    private boolean deleteRow(Row row) throws SQLException {
        if (row.isOriginalWithNull()) {
            return this.deleteWithNull(row);
        }
        return this.deleteNonNull(row);
    }

    private boolean deleteWithNull(Row row) throws SQLException {
        StringBuffer deleteSql = new StringBuffer("DELETE FROM " + this.m_tabName + " WHERE ");
        int[] tailCols = new int[this.m_columnCount];
        int tailCnt = 0;
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            if (i2 > 0) {
                deleteSql.append(" AND ");
            }
            if (row.isOriginalNull(i2)) {
                deleteSql.append(this.m_rsmd.do_getColumnName(i2 + 1)).append(" IS NULL ");
                tailCols[i2] = -1;
            } else {
                deleteSql.append(this.m_rsmd.do_getColumnName(i2 + 1)).append(" = ? ");
                tailCols[i2] = ++tailCnt;
            }
            ++i2;
        }
        DmdbPreparedStatement pstmt = this.m_conn.do_prepareStatement(deleteSql.substring(0, deleteSql.length()));
        int i3 = 0;
        while (i3 < this.m_columnCount) {
            if (tailCols[i3] != -1) {
                pstmt.do_setObject(tailCols[i3], row.getColumn(i3));
            }
            ++i3;
        }
        boolean sus = 1 == pstmt.do_executeUpdate();
        pstmt.do_close();
        pstmt = null;
        deleteSql = null;
        return sus;
    }

    private boolean deleteNonNull(Row row) throws SQLException {
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            this.m_deleteStmt.do_setObject(i2 + 1, row.getColumn(i2));
            ++i2;
        }
        return 1 == this.m_deleteStmt.do_executeUpdate();
    }

    private void release() throws SQLException {
        this.m_insertCommand = null;
        if (this.m_insertStmt != null && !this.m_insertStmt.closed) {
            this.m_insertStmt.do_close();
            this.m_insertStmt = null;
        }
        this.m_updateCommand = null;
        if (this.m_updateStmt != null && !this.m_updateStmt.closed) {
            this.m_updateStmt.do_close();
            this.m_updateStmt = null;
        }
        this.m_deleteCommand = null;
        if (this.m_deleteStmt != null && !this.m_deleteStmt.closed) {
            this.m_deleteStmt.do_close();
            this.m_deleteStmt = null;
        }
        this.m_columnCount = 0;
        this.m_rsmd = null;
        this.m_tabName = "";
    }

    @Override
    public boolean writeData(RowSetInternal dbRowSet) throws SQLException {
        DmdbRowSet caller = (DmdbRowSet)dbRowSet;
        this.initialize(caller);
        if (this.m_columnCount < 1) {
            this.release();
            return true;
        }
        boolean showDeleted = caller.getShowDeleted();
        if (this.m_conn.do_getAutoCommit()) {
            this.m_conn.do_setAutoCommit(false);
        }
        caller.setShowDeleted(true);
        caller.beforeFirst();
        boolean insertRs = true;
        boolean updateRs = true;
        boolean deleteRs = true;
        while (caller.next()) {
            Row row;
            if (caller.rowInserted()) {
                if (caller.rowDeleted()) continue;
                row = caller.getCurrentRow();
                insertRs = this.insertRow(row) && insertRs;
                continue;
            }
            if (caller.rowUpdated()) {
                row = caller.getCurrentRow();
                updateRs = this.updateRow(row) && updateRs;
                continue;
            }
            if (!caller.rowDeleted()) continue;
            row = caller.getCurrentRow();
            boolean bl = deleteRs = this.deleteRow(row) && deleteRs;
        }
        if (!(insertRs && updateRs && deleteRs)) {
            this.m_conn.do_rollback();
        } else {
            this.m_conn.do_commit();
            caller.setOriginal();
        }
        caller.setShowDeleted(showDeleted);
        this.release();
        if (!caller.keepConnecting() && this.m_conn != null && !this.m_conn.do_isClosed()) {
            this.m_conn.do_close();
            this.m_conn = null;
        }
        return true;
    }
}

