/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.a.a;
import dm.jdbc.a.b;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.filter.Filterable;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.cache.PStmtCacheInfo;
import dm.jdbc.internal.cache.StmtCacheInfo;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.internal.conf.EPGroup;
import dm.jdbc.internal.desc.BooleanExpression;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.ComplexTypeDesc;
import dm.jdbc.internal.desc.Const;
import dm.jdbc.internal.enums.ENCODING;
import dm.jdbc.internal.parser.LVal;
import dm.jdbc.internal.parser.SQLProcessor;
import dm.jdbc.internal.processor.DBAliveCheckThread;
import dm.jdbc.jni.MarkDll;
import dm.jdbc.plugin.fldr.Fldr;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrStatement;
import dm.jdbc.util.CacheMap;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbConnection
extends Filterable
implements IDmdbConnection,
Connection {
    public String url;
    public String user;
    public String password;
    public String host = "localhost";
    public int port = 5236;
    public int socketTimeout = 0;
    public int connectTimeout = 5000;
    public int sessionTimeout = 0;
    public boolean keepAlive = true;
    public boolean loginEncrypt = true;
    public String loginCertificate = null;
    public String cipherPath = null;
    public byte osAuthType;
    public String sslFilesPath = "";
    public String sslKeystorePass = "";
    public String sslProtocol;
    public String kerberosLoginConfPath = "";
    public String uKeyName = "";
    public String uKeyPin = "";
    public boolean localEncrypt = false;
    public String localEncryptEngine;
    public String zbCrypto = "";
    public String userNewPwd = "";
    public int compress = 0;
    public byte compressID = 0;
    public Charset sessEncode;
    public boolean enRsCache = false;
    public int rsCacheSize = 20;
    public int rsRefreshFreq = 10;
    public String[] keyWords = null;
    public int rwSeparate = 0;
    public int rwPercent = 25;
    public boolean rwAutoDistribute = true;
    public int rwStandbyRecoverTime = 60000;
    public boolean rwHA = false;
    public boolean rwIgnoreSql = false;
    public boolean mppLocal = false;
    public static final int MPP_FLDR_INSERT = 1;
    public static final int MPP_FLDR_SELECT = 2;
    public int mppOpt = 0;
    public String appName = "";
    public String osName = System.getProperty("os.name", "");
    public short localTimezone = Const.TIME_ZONE_DEFAULT;
    public int stmtPoolSize = 15;
    public int pstmtPoolSize = 0;
    public int pstmtPoolValidTime = 0;
    public boolean alwaysAllowCommit = true;
    public boolean autoCommit = true;
    public boolean escapeProcess = true;
    public boolean batchNotOnCall = false;
    public int batchType = 1;
    public boolean batchContinueOnError = false;
    public int batchAllowMaxErrors = 0;
    public int paramBindMode = 0;
    public boolean dbmdChkPrv = true;
    public boolean isBdtaRS = false;
    public int resultSetType = 1003;
    public int maxRows = 0;
    public int bufPrefetch = 0;
    public int lobMode = 1;
    public boolean fetchSizeEnabled = true;
    public List<String> serverOption = new ArrayList<String>();
    public boolean highConcurrency = false;
    public int compatibleMode = 0;
    public String databaseProductName = "";
    public boolean clobAsString = false;
    public boolean ignoreCase = true;
    public int genKeyNameCase = 1;
    public int columnNameCase = 0;
    public String unixSocketFile;
    public boolean markEnable = false;
    public String socketMark;
    public boolean gmsslEnable = false;
    public int afterGetMoreResults = 1;
    public boolean checkExecType = false;
    public boolean prepareOptimize = true;
    public int quoteReplace = 0;
    public BooleanExpression ignoreWarnings;
    public long sessionID = -1L;
    public String schema;
    public String guid;
    private Charset serverEncoding = Charset.forName(ENCODING.GB18030.stringValue());
    public int serverSeries = 0;
    public boolean constParaOpt = false;
    public short dbTimezone = 0;
    public int sslEncrypt = 0;
    public int maxSession;
    public int maxRowSize;
    public int svrMode;
    public int svrStat;
    public boolean caseSensitive = true;
    public boolean ddlAutoCommit;
    public int isoLevel = -1;
    public int trxStatus = 0;
    private boolean trxFinish = true;
    public int msgVersion = 11;
    public boolean malini2 = true;
    public boolean execute2 = false;
    public boolean newLobFlag = true;
    public boolean longLobFlag = true;
    public boolean supportNameParameter = false;
    public boolean lobEmptyCompOrcl = false;
    public int oracleDateLanguage = DmSvcConf.GLOBAL.getLanguage();
    public String formatDate;
    public String formatDatetime;
    public String formatDatetimeTZ;
    public String formatTime;
    public String formatTimeTZ;
    public String standbyHost;
    public int standbyPort;
    public int standbyCount;
    public boolean dscControl;
    public int rowidNBitsEpno;
    public long rowidMaxHpno;
    public int rowidMaxEpno;
    public int rowidNBitsReal;
    public String proxyClient;
    public Properties expandProperties = new Properties();
    public boolean lobOptimized;
    public int msgSeq;
    public int bufferType = 0;
    public boolean trueDebug = false;
    public static AtomicLong IDGenerator = new AtomicLong(0L);
    public DmProperties props;
    public EPGroup epGroup;
    public EP ep;
    public boolean rwStandby = false;
    private Object abortMutex = new Object();
    private ILogger LOG = LogFactory.getLog(DmdbConnection.class);
    public volatile int switchToEpSeqno = -1;
    public volatile String switchToHost = "";
    public volatile int switchToPort = 0;
    public a dbAccess;
    public boolean closed = true;
    public boolean readOnly = false;
    public int resultSetHoldability = 1;
    public SQLWarning sqlWarning;
    public Map<String, Class<?>> typeMap;
    public int lobReadWriteLen;
    public int lobOffRowLen;
    public CacheQueue<StmtCacheInfo> stmtPool;
    public List<DmdbStatement> activeStmtList = new ArrayList<DmdbStatement>();
    public CacheMap<String, PStmtCacheInfo> pstmtPool;
    public Executor closeExecutor;
    public static final SQLPermission ABORT_PERMISSION = new SQLPermission("abort");
    public static final SQLPermission SET_NETWORK_TIMEOUT_PERMISSION = new SQLPermission("setNetworkTimeout");
    public Map<Integer, DmdbConnection> tempMap = new HashMap<Integer, DmdbConnection>();
    public Map<Integer, Integer> errMap = new HashMap<Integer, Integer>();
    public long connectTime;
    public long[] reconnectErrors;

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public void setAttributes(DmProperties props) throws SQLException {
        String errorInfo;
        String roundHalfSwitch;
        if (props == null || props.size() == 0) {
            return;
        }
        this.url = props.getTrimString(Configuration.url);
        this.host = props.getTrimString(Configuration.host);
        this.port = props.getInt(Configuration.port);
        this.user = props.getProperty(Configuration.user.getName(), Configuration.user.getDefault());
        this.password = props.getProperty(Configuration.password.getName(), Configuration.password.getDefault());
        this.epGroup = (EPGroup)props.getObject(Configuration.epGroup.getName());
        this.rwSeparate = props.getInt(Configuration.rwSeparate);
        this.rwAutoDistribute = props.getBoolean(Configuration.rwAutoDistribute);
        this.rwPercent = props.getInt(Configuration.rwPercent);
        this.rwHA = props.getBoolean(Configuration.rwHA);
        this.rwStandbyRecoverTime = props.getMilliSecond(Configuration.rwStandbyRecoverTime);
        this.rwIgnoreSql = props.getBoolean(Configuration.rwIgnoreSql);
        this.rwStandby = props.getBoolean(Configuration.rwStandby);
        this.mppLocal = props.getBoolean(Configuration.mppLocal);
        this.mppOpt = props.getInt(Configuration.mppOpt);
        this.compress = props.getBoolean(Configuration.isCompress) ? 2 : 0;
        this.compress = props.getInt(Configuration.compress);
        this.compressID = (byte)props.getInt(Configuration.compressID);
        this.cipherPath = props.getTrimString(Configuration.cipherPath);
        this.loginEncrypt = props.getBoolean(Configuration.loginEncrypt);
        this.loginCertificate = props.getTrimString(Configuration.loginCertificate);
        this.sslProtocol = props.getTrimString(Configuration.sslProtocol);
        this.sslFilesPath = props.getTrimString(Configuration.sslFilesPath);
        this.sslKeystorePass = props.getTrimString(Configuration.sslKeystorePass);
        this.kerberosLoginConfPath = props.getTrimString(Configuration.kerberosLoginConfPath);
        this.zbCrypto = props.getTrimString(Configuration.shakeCrypto);
        this.userNewPwd = props.getString(Configuration.userNewPwd);
        this.osAuthType = Configuration.parseOsAuthType(props);
        this.uKeyName = props.getTrimString(Configuration.uKeyName);
        this.uKeyPin = props.getTrimString(Configuration.uKeyPin);
        this.localEncrypt = props.getBoolean(Configuration.LocalEncrypt);
        this.localEncryptEngine = props.getTrimString(Configuration.localEncryptEngine);
        this.unixSocketFile = props.getTrimString(Configuration.unixSocketFile);
        this.markEnable = StringUtil.isNotEmpty(DmSvcConf.GLOBAL.markConf);
        this.gmsslEnable = props.getBoolean(Configuration.gmsslEnable);
        this.appName = props.getTrimString(Configuration.appName);
        this.osName = props.getTrimString(Configuration.osName);
        this.databaseProductName = props.getTrimString(Configuration.databaseProductName);
        this.keepAlive = props.getBoolean(Configuration.keepAlive);
        this.socketTimeout = props.getMilliSecond(Configuration.socketTimeout);
        this.connectTimeout = props.getMilliSecond(Configuration.connectTimeout);
        this.sessionTimeout = props.getSecond(Configuration.sessionTimeout);
        this.localTimezone = (short)props.getInt(Configuration.localTimezone);
        String charsetName = props.getTrimString(Configuration.sessEncode);
        if (StringUtil.isNotEmpty(charsetName)) {
            if (!Charset.isSupported(charsetName)) {
                this.LOG.warn(this, "setAttributes", "unsupported sessEncode:" + charsetName);
            } else {
                this.sessEncode = Charset.forName(charsetName);
            }
        }
        this.alwaysAllowCommit = props.getBoolean(Configuration.alwaysAllowCommit);
        this.autoCommit = props.getBoolean(Configuration.autoCommit);
        this.dbmdChkPrv = props.getBoolean(Configuration.dbmdChkPrv);
        this.prepareOptimize = props.getBoolean(Configuration.prepareOptimize);
        this.checkExecType = props.getBoolean(Configuration.checkExecType);
        this.compatibleMode = Configuration.parseCompatibleMode(props);
        this.escapeProcess = props.getBoolean(Configuration.escapeProcess);
        this.keyWords = props.getStringArray(Configuration.keyWords);
        this.quoteReplace = props.getInt(Configuration.quoteReplace);
        this.ignoreCase = props.getBoolean(Configuration.ignoreCase);
        this.genKeyNameCase = Configuration.parseGenKeyCase(props.getTrimString(Configuration.genKeyNameCase));
        this.columnNameCase = Configuration.parseColumnNameCase(props.getTrimString(Configuration.columnNameCase));
        this.stmtPoolSize = props.getInt(Configuration.stmtPoolSize);
        this.pstmtPoolSize = props.getInt(Configuration.pstmtPoolSize);
        this.pstmtPoolValidTime = props.getMilliSecond(Configuration.pstmtPoolValidTime);
        this.paramBindMode = props.getInt(Configuration.paramBindMode);
        this.batchType = props.getInt(Configuration.batchType);
        this.batchContinueOnError = props.getBoolean(Configuration.batchContinueOnError);
        this.batchNotOnCall = props.getBoolean(Configuration.batchNotOnCall);
        this.batchAllowMaxErrors = props.getInt(Configuration.batchAllowMaxErrors);
        this.resultSetType = props.getInt(Configuration.resultSetType);
        this.afterGetMoreResults = props.getInt(Configuration.afterGetMoreResults);
        this.isBdtaRS = props.getBoolean(Configuration.isBdtaRS);
        this.maxRows = props.getInt(Configuration.maxRows);
        this.fetchSizeEnabled = props.getBoolean(Configuration.fetchSizeEnabled);
        this.bufPrefetch = props.getInt(Configuration.bufPrefetch);
        this.enRsCache = props.getBoolean(Configuration.enRsCache);
        this.rsCacheSize = props.getInt(Configuration.rsCacheSize);
        this.rsRefreshFreq = props.getSecond(Configuration.rsRefreshFreq);
        this.clobAsString = props.getBoolean(Configuration.clobAsString);
        this.lobMode = props.getInt(Configuration.lobMode);
        this.lobReadWriteLen = props.getInt(Configuration.lobReadWriteLen);
        this.lobOffRowLen = props.getInt(Configuration.lobOffRowLen);
        this.proxyClient = props.getTrimString(Configuration.proxyClient);
        this.bufferType = props.getInt(Configuration.bufferType);
        this.serverOption = Configuration.parseServerOption(props);
        this.ignoreWarnings = Configuration.parseIgnoreWarnings(props);
        this.highConcurrency = props.getBoolean(Configuration.highConcurrency);
        this.trueDebug = props.getBoolean(Configuration.trueDebug);
        if (StringUtil.isNotEmpty(props.getTrimString(Configuration.gwdsn))) {
            this.serverOption.add(String.valueOf(Configuration.gwdsn.getName()) + "=" + props.getTrimString(Configuration.gwdsn));
        }
        if (StringUtil.isNotEmpty(this.proxyClient)) {
            this.serverOption.add(String.valueOf(Configuration.proxyClient.getName()) + "=" + this.proxyClient);
        }
        if (this.user == null && this.osAuthType == 0) {
            this.user = "SYSDBA";
        } else if (this.osAuthType != 0 && StringUtil.isNotEmpty(this.user)) {
            DBError.ECJDBC_OSAUTH_ERROR.throwz(new Object[0]);
        } else if (this.osAuthType != 0) {
            this.user = System.getProperty("user.name", "");
            this.password = "";
        }
        if (this.localEncrypt) {
            this.user = StringUtil.decrypt(this.user, this.localEncryptEngine);
            this.password = StringUtil.decrypt(this.password, this.localEncryptEngine);
        }
        if (StringUtil.isNotEmpty(roundHalfSwitch = props.getProperty(Configuration.numTruncSwitch.getName()))) {
            DmdbNumeric.ROUND_HALF_SWITCH = roundHalfSwitch.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (StringUtil.isNotEmpty(errorInfo = props.getProperty(Configuration.errMap.getName()))) {
            this.setErrorMap(errorInfo);
        }
    }

    private void setErrorMap(String value) throws SQLException {
        String[] errorInfo;
        String[] stringArray = errorInfo = value.split(",");
        int n2 = errorInfo.length;
        int n3 = 0;
        while (n3 < n2) {
            String error = stringArray[n3];
            int index = error.indexOf(":");
            if (index <= 0) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            }
            Integer dmError = Integer.parseInt(error.substring(0, index).trim());
            Integer oracleError = Integer.parseInt(error.substring(index + 1).trim());
            this.errMap.put(dmError, oracleError);
            ++n3;
        }
    }

    public DmdbConnection(DmProperties props) throws SQLException {
        super(null, props);
        this.props = props;
        this.setAttributes(props);
        if (this.stmtPoolSize > 0) {
            this.stmtPool = new CacheQueue<StmtCacheInfo>(this.stmtPoolSize, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void beforeRemove(StmtCacheInfo eldest) {
                    try {
                        DmdbConnection dmdbConnection = DmdbConnection.this;
                        synchronized (dmdbConnection) {
                            DmdbConnection.this.dbAccess.b(eldest.handle);
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            };
        }
        if (this.pstmtPoolSize > 0) {
            this.pstmtPool = new CacheMap<String, PStmtCacheInfo>(this.pstmtPoolSize){

                @Override
                protected boolean needRemove(PStmtCacheInfo element) {
                    return DmdbConnection.this.pstmtPoolValidTime > 0 && System.currentTimeMillis() - element.ts > (long)DmdbConnection.this.pstmtPoolValidTime;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void beforeRemove(Map.Entry<String, PStmtCacheInfo> eldest) {
                    try {
                        DmdbConnection dmdbConnection = DmdbConnection.this;
                        synchronized (dmdbConnection) {
                            DmdbConnection.this.dbAccess.b(eldest.getValue().handle);
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            };
        }
    }

    public void openConnection() throws SQLException {
        try {
            try {
                this.dbAccess = this.markEnable ? new b(this) : new a(this);
                this.dbAccess.e();
                this.connectTime = System.nanoTime();
                this.closed = false;
                this.do_setSchema(this.props.getProperty(Configuration.schema.getName()));
                this.resetClientInfo();
                DBAliveCheckThread.addConnection(this);
                if (this.epGroup != null) {
                    this.epGroup.incrementSession(this);
                }
            }
            catch (SQLException e2) {
                if (!this.closed) {
                    this.free();
                }
                throw e2;
            }
        }
        finally {
            if (this.closed) {
                this.free();
            }
        }
    }

    private void resetClientInfo() throws SQLException {
        this.props.setProperty("ApplicationName", this.appName);
        this.props.setProperty("ClientUser", this.user);
        this.props.setProperty("ClientHostname", this.host);
        this.props.setProperty("svrStat", String.valueOf(this.svrStat));
        this.props.setProperty("svrMode", String.valueOf(this.svrMode));
        this.props.setProperty("guid", this.guid);
        this.props.setProperty("dscControl", String.valueOf(this.dscControl));
    }

    public DmdbStatement do_createStatement() throws SQLException {
        return this.do_createStatement(this.resultSetType, 1007, this.resultSetHoldability);
    }

    public DmdbStatement do_createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.do_createStatement(resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    public DmdbStatement do_createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        DmdbStatement stmt = new DmdbStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, true);
        this.activeStmtList.add(stmt);
        return stmt;
    }

    public DmdbStatement createCursorStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        DmdbStatement stmt = new DmdbStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        stmt.poolable = false;
        this.activeStmtList.add(stmt);
        return stmt;
    }

    public FldrStatement do_fldrStatement(FldrConfig config) throws SQLException {
        this.checkClosed();
        if (config == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return new FldrStatement(this, config);
    }

    public DmdbPreparedStatement do_prepareStatement(String sql) throws SQLException {
        return this.do_prepareStatement(sql, this.resultSetType, 1007, this.resultSetHoldability);
    }

    public DmdbPreparedStatement do_prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.do_prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    public DmdbPreparedStatement do_prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
        this.activeStmtList.add(pstmt);
        return pstmt;
    }

    public DmdbPreparedStatement do_prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this, sql, autoGeneratedKeys, true);
        this.activeStmtList.add(pstmt);
        return pstmt;
    }

    public DmdbPreparedStatement do_prepareStatement(String sql, int[] columnIndexs) throws SQLException {
        this.checkClosed();
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this, sql, columnIndexs, true);
        this.activeStmtList.add(pstmt);
        return pstmt;
    }

    public DmdbPreparedStatement do_prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.msgVersion >= 3) {
            this.checkClosed();
            if (this.getGenKeyNameCase() != 0) {
                int i2 = 0;
                while (i2 < columnNames.length) {
                    if (!StringUtil.isEmpty(columnNames[i2])) {
                        if (this.getGenKeyNameCase() == 1) {
                            columnNames[i2] = columnNames[i2].toUpperCase();
                        } else if (this.getGenKeyNameCase() == 2) {
                            columnNames[i2] = columnNames[i2].toLowerCase();
                        }
                    }
                    ++i2;
                }
            }
            DmdbPreparedStatement pstmt = new DmdbPreparedStatement(this, sql, columnNames, true);
            this.activeStmtList.add(pstmt);
            return pstmt;
        }
        if (columnNames != null && columnNames.length > 0) {
            String secondWord;
            List<LVal> wordList = null;
            try {
                wordList = SQLProcessor.lexSkipWhitespace(sql, 2);
            }
            catch (Throwable throwable) {}
            int count = wordList == null ? 0 : wordList.size();
            String firstWord = count > 0 ? wordList.get((int)0).value : null;
            String string = secondWord = count > 1 ? wordList.get((int)1).value : null;
            if (StringUtil.equalsIgnoreCase("update", firstWord) || StringUtil.equals("delete", firstWord) || StringUtil.equalsIgnoreCase("insert", firstWord) && StringUtil.equalsIgnoreCase("into", secondWord)) {
                StringBuilder sf = new StringBuilder(256);
                sf.append(sql);
                while (sf.charAt(sf.length() - 1) == ';') {
                    sf.deleteCharAt(sf.length() - 1);
                }
                sf.append(" return ");
                sf.append(StringUtil.join(columnNames, ", "));
                sf.append(" into ");
                sf.append(StringUtil.join("?", columnNames.length, ", "));
                sql = sf.toString();
            }
        }
        DmdbPreparedStatement pstmt = this.do_prepareStatement(sql, columnNames != null && columnNames.length > 0 ? 1 : 2);
        pstmt.generateKeyColumnNames = columnNames;
        return pstmt;
    }

    public DmdbCallableStatement do_prepareCall(String sql) throws SQLException {
        return this.do_prepareCall(sql, 1003, 1007, this.resultSetHoldability);
    }

    public DmdbCallableStatement do_prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.do_prepareCall(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    public DmdbCallableStatement do_prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        DmdbCallableStatement cstmt = new DmdbCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
        this.activeStmtList.add(cstmt);
        return cstmt;
    }

    public String do_nativeSQL(String sql) throws SQLException {
        try {
            return SQLProcessor.escape(sql, this.keyWords);
        }
        catch (IOException e2) {
            DBError.ECJDBC_SQL_ESCAPE_FAILED.throwException(e2);
            return sql;
        }
    }

    public void do_commit() throws SQLException {
        this.checkClosed();
        if (!this.autoCommit) {
            this.dbAccess.commit();
        } else if (!this.alwaysAllowCommit) {
            DBError.ECJDBC_COMMIT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
    }

    public void do_rollback() throws SQLException {
        this.checkClosed();
        if (!this.autoCommit) {
            this.dbAccess.rollback();
        } else if (!this.alwaysAllowCommit) {
            DBError.ECJDBC_ROLLBACK_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Object object = this.abortMutex;
        synchronized (object) {
            if (!this.closed && this.epGroup != null) {
                this.epGroup.decrementSession(this);
            }
            if (this.dbAccess != null) {
                this.dbAccess.close();
            }
            this.closed = true;
            if (this.activeStmtList != null) {
                for (DmdbStatement stmt : this.activeStmtList) {
                    stmt.free();
                }
            }
            if (this.stmtPool != null) {
                this.stmtPool.clear();
            }
            if (this.pstmtPool != null) {
                this.pstmtPool.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_close() throws SQLException {
        Object object = this.abortMutex;
        synchronized (object) {
            try {
                if (this.compatibleOracle() && !this.closed) {
                    this.do_commit();
                }
            }
            catch (Exception exception) {}
            this.free();
            if (this.activeStmtList != null) {
                this.activeStmtList.clear();
            }
            this.closed = true;
        }
    }

    public void checkClosed() throws SQLException {
        if (this.closed) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwz(new Object[0]);
        }
    }

    public DmdbDatabaseMetaData do_getMetaData() throws SQLException {
        this.checkClosed();
        return new DmdbDatabaseMetaData(this);
    }

    public void do_setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.dbAccess.setTransactionIsolation(level);
                this.isoLevel = level;
                break;
            }
            case 4: {
                if (!this.compatibleMysql()) break;
                level = 2;
                this.dbAccess.setTransactionIsolation(level);
                this.isoLevel = level;
                break;
            }
            default: {
                DBError.ECJDBC_INVALID_TRAN_ISOLATION.throwz(new Object[0]);
            }
        }
    }

    public void addSQLWarning(SQLWarning sqlWarning) {
        this.sqlWarning = sqlWarning;
    }

    public void do_clearWarnings() {
        this.sqlWarning = null;
    }

    public DmdbSavepoint do_setSavepoint() throws SQLException {
        return this.do_setSavepoint(null);
    }

    public DmdbSavepoint do_setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            DBError.ECJDBC_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
        return new DmdbSavepoint(this, name);
    }

    public void do_rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwz(new Object[0]);
        }
        if (this.autoCommit && !this.alwaysAllowCommit) {
            DBError.ECJDBC_ROLLBACK_TO_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
        DmdbSavepoint dmSp = (DmdbSavepoint)savepoint;
        if (dmSp.released) {
            DBError.ECJDBC_SAVEPOINT_RELEASED.throwz(new Object[0]);
        }
        String sql = "/*DMJDBC*/ ROLLBACK TO SAVEPOINT \"" + StringUtil.processDoubleQuoteOfName(dmSp.name) + "\"";
        DriverUtil.execute(this, sql);
    }

    public void do_releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwz(new Object[0]);
        }
        if (this.autoCommit && !this.alwaysAllowCommit) {
            DBError.ECJDBC_RELEASE_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
        ((DmdbSavepoint)savepoint).release();
    }

    public DmdbClob do_createClob() throws SQLException {
        this.checkClosed();
        return DmdbClob.newInstance("", this);
    }

    public DmdbBlob do_createBlob() throws SQLException {
        this.checkClosed();
        return DmdbBlob.newInstanceOfLocal(new byte[0], this);
    }

    public boolean do_isValid(int timeout) throws SQLException {
        boolean pingResult;
        if (this.do_isClosed()) {
            return false;
        }
        int milluseconds = timeout <= 0 ? this.socketTimeout : timeout * 1000;
        try {
            DriverUtil.execute(this, "/*DMJDBC*/ select 1 from dual", milluseconds);
            pingResult = true;
        }
        catch (Throwable throwable) {
            pingResult = false;
        }
        return pingResult;
    }

    public void do_setClientInfo(String name, Object value) {
        this.props.setObject(name, value);
    }

    public void do_setClientInfo(Properties properties) {
        this.props.setProperties(properties);
    }

    public String do_getClientInfo(String name) {
        return this.props.getProperty(name);
    }

    public Properties do_getClientInfo() {
        return this.props.getProperties();
    }

    public DmdbArray do_createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        ComplexTypeDesc desc = new ComplexTypeDesc(typeName, this);
        return new DmdbArray(desc, this, elements);
    }

    public DmdbStruct do_createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        ComplexTypeDesc desc = new ComplexTypeDesc(typeName, this);
        return new DmdbStruct(desc, this, attributes);
    }

    public void do_setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean do_getAutoCommit() {
        return this.autoCommit;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_setReadOnly(boolean readOnly) throws SQLException {
        if (this.compatibleOracle()) {
            this.readOnly = readOnly;
            return;
        }
        if (this.readOnly != readOnly) {
            DriverUtil.execute(this, "/*DMJDBC*/ SP_SET_SESSION_READONLY (" + (readOnly ? 1 : 0) + ")");
            this.readOnly = readOnly;
        }
    }

    public boolean do_isReadOnly() {
        return this.readOnly;
    }

    public void do_setCatalog(String catalog) {
    }

    public String do_getCatalog() {
        return null;
    }

    public int do_getTransactionIsolation() {
        return this.isoLevel;
    }

    public SQLWarning do_getWarnings() {
        return this.sqlWarning;
    }

    public Map<String, Class<?>> do_getTypeMap() {
        return this.typeMap;
    }

    public void do_setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    public void do_setHoldability(int holdability) {
        this.resultSetHoldability = holdability;
    }

    public int do_getHoldability() {
        return this.resultSetHoldability;
    }

    public NClob do_createNClob() throws SQLException {
        this.checkClosed();
        return DmdbNClob.newInstance("", this);
    }

    public SQLXML do_createSQLXML() throws SQLException {
        return new DmdbSQLXML();
    }

    public void do_setSchema(String schema) throws SQLException {
        if (StringUtil.isNotEmpty(schema) && !StringUtil.equals(schema, this.schema)) {
            DriverUtil.execute(this, "/*DMJDBC*/ set schema \"" + StringUtil.processDoubleQuoteOfName(schema) + "\"");
        }
    }

    public String do_getSchema() {
        return this.schema;
    }

    public void do_abort(Executor executor) throws SQLException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(ABORT_PERMISSION);
        }
        if (executor == null) {
            this.free();
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                DmdbConnection.this.free();
            }
        });
    }

    public void do_setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (milliseconds == this.socketTimeout || this.dbAccess.o > 0) {
            return;
        }
        this.checkClosed();
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_NETWORK_TIMEOUT_PERMISSION);
        }
        this.dbAccess.a(milliseconds);
        this.socketTimeout = milliseconds;
        this.closeExecutor = executor;
    }

    public int do_getNetworkTimeout() {
        return this.socketTimeout;
    }

    public void do_setTrxFinish(int status) {
        switch (status & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                this.trxFinish = true;
                break;
            }
            default: {
                this.trxFinish = false;
            }
        }
    }

    public void do_setTrxFinish(boolean trxFinish) {
        this.trxFinish = trxFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Statement createStatement() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createStatement();
            }
            return this.filterHead.Connection_createStatement(this);
        }
    }

    @Deprecated
    public void setTrxFinish(int status) {
        this.do_setTrxFinish(status);
        this.LOG.debug((Object)this, "setTrxFinish", this.trxFinish);
    }

    @Deprecated
    public void setTrxFinish(boolean trxFinish) {
        this.LOG.debug((Object)this, "setTrxFinish", trxFinish);
        this.do_setTrxFinish(trxFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareStatement(sql);
            }
            return this.filterHead.Connection_prepareStatement(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FldrStatement fldrStatement(FldrConfig config) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_fldrStatement(config);
            }
            return this.filterHead.Connection_fldrStatement(this, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public CallableStatement prepareCall(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareCall(sql);
            }
            return this.filterHead.Connection_prepareCall(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String nativeSQL(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_nativeSQL(sql);
            }
            return this.filterHead.Connection_nativeSQL(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setAutoCommit(autoCommit);
            } else {
                this.filterHead.Connection_setAutoCommit(this, autoCommit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean getAutoCommit() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getAutoCommit();
            }
            return this.filterHead.Connection_getAutoCommit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void commit() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_commit();
            } else {
                this.filterHead.Connection_commit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void rollback() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_rollback();
            } else {
                this.filterHead.Connection_rollback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void close() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_close();
            } else {
                this.filterHead.Connection_close(this);
            }
        }
    }

    @Override
    @Deprecated
    public boolean isClosed() throws SQLException {
        if (this.filterHead == null) {
            return this.do_isClosed();
        }
        return this.filterHead.Connection_isClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DatabaseMetaData getMetaData() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getMetaData();
            }
            return this.filterHead.Connection_getMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setReadOnly(boolean readOnly) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setReadOnly(readOnly);
            } else {
                this.filterHead.Connection_setReadOnly(this, readOnly);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isReadOnly() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_isReadOnly();
            }
            return this.filterHead.Connection_isReadOnly(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setCatalog(String catalog) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setCatalog(catalog);
            } else {
                this.filterHead.Connection_setCatalog(this, catalog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getCatalog() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getCatalog();
            }
            return this.filterHead.Connection_getCatalog(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setTransactionIsolation(int level) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setTransactionIsolation(level);
            } else {
                this.filterHead.Connection_setTransactionIsolation(this, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getTransactionIsolation() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getTransactionIsolation();
            }
            return this.filterHead.Connection_getTransactionIsolation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SQLWarning getWarnings() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getWarnings();
            }
            return this.filterHead.Connection_getWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void clearWarnings() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_clearWarnings();
            } else {
                this.filterHead.Connection_clearWarnings(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createStatement(resultSetType, resultSetConcurrency);
            }
            return this.filterHead.Connection_createStatement(this, resultSetType, resultSetConcurrency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            return this.filterHead.Connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareCall(sql, resultSetType, resultSetConcurrency);
            }
            return this.filterHead.Connection_prepareCall(this, sql, resultSetType, resultSetConcurrency);
        }
    }

    @Override
    @Deprecated
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getTypeMap();
        }
        return this.filterHead.Connection_getTypeMap(this);
    }

    @Override
    @Deprecated
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.filterHead == null) {
            this.do_setTypeMap(map);
        } else {
            this.filterHead.Connection_setTypeMap(this, map);
        }
    }

    @Override
    @Deprecated
    public void setHoldability(int holdability) throws SQLException {
        if (this.filterHead == null) {
            this.do_setHoldability(holdability);
        } else {
            this.filterHead.Connection_setHoldability(this, holdability);
        }
    }

    @Override
    @Deprecated
    public int getHoldability() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getHoldability();
        }
        return this.filterHead.Connection_getHoldability(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Savepoint setSavepoint() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_setSavepoint();
            }
            return this.filterHead.Connection_setSavepoint(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Savepoint setSavepoint(String name) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_setSavepoint(name);
            }
            return this.filterHead.Connection_setSavepoint(this, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void rollback(Savepoint savepoint) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_rollback(savepoint);
            } else {
                this.filterHead.Connection_rollback(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_releaseSavepoint(savepoint);
            } else {
                this.filterHead.Connection_releaseSavepoint(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return this.filterHead.Connection_createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return this.filterHead.Connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return this.filterHead.Connection_prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareStatement(sql, autoGeneratedKeys);
            }
            return this.filterHead.Connection_prepareStatement(this, sql, autoGeneratedKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareStatement(sql, columnIndexes);
            }
            return this.filterHead.Connection_prepareStatement(this, sql, columnIndexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepareStatement(sql, columnNames);
            }
            return this.filterHead.Connection_prepareStatement(this, sql, columnNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Clob createClob() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createClob();
            }
            return this.filterHead.Connection_createClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Blob createBlob() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createBlob();
            }
            return this.filterHead.Connection_createBlob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public NClob createNClob() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createNClob();
            }
            return this.filterHead.Connection_createNClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SQLXML createSQLXML() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createSQLXML();
            }
            return this.filterHead.Connection_createSQLXML(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean isValid(int timeout) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_isValid(timeout);
            }
            return this.filterHead.Connection_isValid(this, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setClientInfo(name, value);
            } else {
                this.filterHead.Connection_setClientInfo(this, name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setClientInfo(properties);
            } else {
                this.filterHead.Connection_setClientInfo(this, properties);
            }
        }
    }

    @Override
    @Deprecated
    public String getClientInfo(String name) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getClientInfo(name);
        }
        return this.filterHead.Connection_getClientInfo(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Properties getClientInfo() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getClientInfo();
            }
            return this.filterHead.Connection_getClientInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createArrayOf(typeName, elements);
            }
            return this.filterHead.Connection_createArrayOf(this, typeName, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_createStruct(typeName, attributes);
            }
            return this.filterHead.Connection_createStruct(this, typeName, attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setSchema(String schema) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setSchema(schema);
            } else {
                this.filterHead.Connection_setSchema(this, schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getSchema() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getSchema();
            }
            return this.filterHead.Connection_getSchema(this);
        }
    }

    @Override
    @Deprecated
    public void abort(Executor executor) throws SQLException {
        if (this.filterHead == null) {
            this.do_abort(executor);
        } else {
            this.filterHead.Connection_abort(this, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setNetworkTimeout(executor, milliseconds);
            } else {
                this.filterHead.Connection_setNetworkTimeout(this, executor, milliseconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getNetworkTimeout() throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getNetworkTimeout();
            }
            return this.filterHead.Connection_getNetworkTimeout(this);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionTrace(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            return DriverUtil.executeAndGetExplain(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainInfo(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (StringUtil.isEmpty(sql)) {
                DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
            }
            if (!sql.equalsIgnoreCase("show_pln_stat")) {
                sql = "EXPLAIN " + sql;
            }
            return DriverUtil.executeAndGetExplain(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_reconnect() throws SQLException {
        this.free();
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.epGroup != null && this.switchToEpSeqno >= 0) {
                this.LOG.debug((Object)this, "reconnect switchToEpSeqno: " + this.switchToEpSeqno, new Object[0]);
                this.epGroup.connect(this, this.switchToEpSeqno);
                this.switchToEpSeqno = -1;
            } else if (this.epGroup != null && StringUtil.isNotEmpty(this.switchToHost) && this.switchToPort > 0) {
                this.LOG.debug((Object)this, "reconnect switchToEpSeqno: " + this.switchToHost + ":" + this.switchToPort, new Object[0]);
                this.epGroup.connect(this, this.switchToHost, this.switchToPort);
                this.switchToHost = "";
                this.switchToPort = 0;
            } else if (this.epGroup != null) {
                this.LOG.debug((Object)this, "reconnect epGroup", new Object[0]);
                this.epGroup.connect(this);
            } else {
                this.LOG.debug((Object)this, "reconnect self", new Object[0]);
                this.openConnection();
            }
            ArrayList<DmdbStatement> closeList = new ArrayList<DmdbStatement>(this.activeStmtList.size());
            for (DmdbStatement stmt : this.activeStmtList) {
                try {
                    stmt.reconnect(false);
                }
                catch (Throwable throwable) {
                    stmt.poolable = false;
                    closeList.add(stmt);
                }
            }
            for (DmdbStatement stmt : closeList) {
                try {
                    stmt.do_close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void reconnect(String user, String password) throws SQLException {
        this.user = user;
        this.password = password;
        this.reconnect();
    }

    public void reconnect() throws SQLException {
        this.createFilterChain(this, this.props);
        if (this.filterHead == null) {
            this.do_reconnect();
        } else {
            this.filterHead.Connection_reconnect(this);
        }
    }

    public short getDBTimeZone() {
        return this.dbTimezone;
    }

    public String getHostName() {
        return this.host;
    }

    public int getHostPort() {
        return this.port;
    }

    public boolean getTransFinish() {
        return this.trxFinish;
    }

    public String getLastLoginIP() {
        return (String)this.nonStandardInterface("lastLoginIP");
    }

    public String getLastLoginTime() {
        return (String)this.nonStandardInterface("lastLoginTime");
    }

    public int getLoginWarningID() {
        return (Integer)this.nonStandardInterface("loginWarningID");
    }

    public int getGraceTimeRemainder() {
        return (Integer)this.nonStandardInterface("GraceTimeRemainder");
    }

    public int getFailedAttempt() {
        return (Integer)this.nonStandardInterface("failedAttempts");
    }

    public boolean getNetworkEncypted() {
        return this.sslEncrypt == 1;
    }

    public int getNetworkPacketSize() {
        return this.dbAccess != null ? this.dbAccess.l : 0;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getLanguage() {
        return DmSvcConf.GLOBAL.getLanguage();
    }

    public boolean getBackslashEsc() {
        return (Boolean)this.nonStandardInterface("backslashEscape");
    }

    public int getGlobalServerSeries() {
        return (Integer)this.nonStandardInterface("globalServerSeries");
    }

    public int getEncryptMsg() {
        return this.sslEncrypt;
    }

    public boolean getEscape() {
        return this.escapeProcess;
    }

    public void setEscape(boolean escape) {
        this.escapeProcess = escape;
    }

    public void setEscape(Boolean escape) {
        this.escapeProcess = escape;
    }

    public void setDbmdChkPrivileges(boolean chk) {
        this.dbmdChkPrv = chk;
    }

    public boolean getDbmdChkPrivileges() {
        return this.dbmdChkPrv;
    }

    public void reset() throws SQLException {
        this.reconnect();
    }

    public void do_reset() throws SQLException {
        this.checkClosed();
        if (this.sessionID != -1L) {
            DriverUtil.executeWithNewConnection(this, "/*DMJDBC*/ SP_CANCEL_SESSION_OPERATION(" + this.sessionID + ")");
        }
    }

    @Override
    public Charset getServerEncoding() {
        if (this.sessEncode != null) {
            return this.sessEncode;
        }
        return this.serverEncoding;
    }

    @Override
    public void setServerEncoding(Charset serverEncoding) {
        this.serverEncoding = serverEncoding;
    }

    public Object nonStandardInterface(String name) {
        if (name == null) {
            return null;
        }
        return this.props.getObject(name.toLowerCase());
    }

    public boolean isMppFldrInsertEnable() {
        return (this.mppOpt & 1) != 0;
    }

    public boolean isMppFldrSelectEnable() {
        return (this.mppOpt & 2) != 0;
    }

    public void setMark(String socketMark) throws SQLException {
        if (StringUtil.isEmpty(socketMark)) {
            this.socketMark = null;
            return;
        }
        byte[] socketMarkBytes = socketMark.getBytes();
        if (this.dbAccess instanceof b && MarkDll.checkMark(((b)this.dbAccess).p, socketMarkBytes, socketMarkBytes.length) < 0) {
            DBError.ECJDBC_INVALID_SOCKET_MARK.throwz(socketMark);
        }
        this.socketMark = socketMark;
    }

    @Override
    public boolean getIgnoreCase() {
        return !this.caseSensitive || this.ignoreCase;
    }

    public int getGenKeyNameCase() {
        return this.genKeyNameCase;
    }

    @Override
    public boolean getNewLobFlag() {
        return this.newLobFlag;
    }

    @Override
    public void setNewLobFlag(boolean newLobFlag) {
        this.newLobFlag = newLobFlag;
    }

    @Override
    public short getLocalTimezone() {
        return this.localTimezone;
    }

    @Override
    public short getDBTimezone() {
        return this.dbTimezone;
    }

    @Override
    public boolean getClobAsString() {
        return this.clobAsString;
    }

    @Override
    public int getDateLanguage() {
        return this.oracleDateLanguage;
    }

    @Override
    public String getFormat(Column column) {
        int dtype = column.mask == 1 ? 14 : column.type;
        switch (dtype) {
            case 14: {
                return this.formatDate;
            }
            case 15: {
                return this.formatTime;
            }
            case 22: {
                return this.formatTimeTZ;
            }
            case 16: 
            case 26: {
                return this.formatDatetime;
            }
            case 23: 
            case 27: {
                return this.formatDatetimeTZ;
            }
        }
        return "";
    }

    @Override
    public int getRowidMaxEpno() {
        return this.rowidMaxEpno;
    }

    @Override
    public int getRowidNBitsEpno() {
        return this.rowidNBitsEpno;
    }

    @Override
    public long getRowidMaxHpno() {
        return this.rowidMaxHpno;
    }

    @Override
    public int getRowidNBitsReal() {
        return this.rowidNBitsReal;
    }

    @Override
    public boolean compatibleOracle() {
        return (this.compatibleMode & 1) != 0;
    }

    public boolean compatibleOracle19() {
        return this.compatibleMode == 4865;
    }

    public boolean compatibleOracle11() {
        return this.compatibleMode == 2817;
    }

    public boolean compatibleMysql() {
        return this.compatibleMode == 2;
    }

    public boolean isColumnNameUpperCase() {
        return this.columnNameCase == 1;
    }

    public boolean isColumnNameLowerCase() {
        return this.columnNameCase == 2;
    }

    @Override
    public boolean lobFetchAll() {
        return this.lobMode == 2;
    }

    @Override
    public int getLobOffRowLen() {
        return this.lobOffRowLen;
    }

    @Override
    public int getLobReadWriteLen() {
        return this.lobReadWriteLen;
    }

    public Fldr getFldrInstance() throws SQLException {
        if (this.dbAccess == null) {
            throw new SQLException("\u8bf7\u521d\u59cb\u5316Connection!");
        }
        return new Fldr(this.dbAccess);
    }
}

