/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.CipherTransInfo;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class DmCipherEncryptDLL {
    static {
        System.loadLibrary("cyt_java");
    }

    public static native int initCipherEncrypt(String var0);

    public static native byte[] cipherEncrypt(int var0, byte[] var1, byte[] var2);

    public static native byte[] cipherDecrypt(int var0, byte[] var1, byte[] var2);

    public static native byte[] cipherHash(int var0, byte[] var1);

    public static native int getHashSize(int var0);

    public static native int cipher_trans_gen_respective_key(CipherTransInfo var0, byte[] var1);

    public static native int cipher_trans_gen_common_key(CipherTransInfo var0, byte[] var1);

    public static native byte[] cipher_trans_encrypt(int var0, CipherTransInfo var1, byte[] var2);

    public static native byte[] cipher_trans_decrypt(int var0, CipherTransInfo var1, byte[] var2);

    public static native int cipher_trans_destroy_key(CipherTransInfo var0, byte[] var1);

    public static CipherTransInfo zbLoad(DmdbConnection connection) throws SQLException {
        int ret;
        CipherTransInfo transInfo = new CipherTransInfo();
        transInfo.crypto = ByteUtil.fromString(connection.zbCrypto, connection.getServerEncoding());
        if (StringUtil.isNotEmpty(connection.cipherPath) && DmCipherEncryptDLL.initCipherEncrypt(connection.cipherPath) <= 0) {
            DBError.ECJDBC_NEGOTIATE_FAIL.throwz(new Object[0]);
        }
        if ((ret = DmCipherEncryptDLL.cipher_trans_gen_respective_key(transInfo, transInfo.crypto)) != 0) {
            DBError.ECJDBC_COMMUNITION_ERROR.throwz("cipher transform error!");
        }
        return transInfo;
    }

    public static void zbAuth(CipherTransInfo zbTransInfo) throws SQLException {
        int ret = DmCipherEncryptDLL.cipher_trans_gen_common_key(zbTransInfo, zbTransInfo.crypto);
        if (ret != 0) {
            DBError.ECJDBC_COMMUNITION_ERROR.throwz("cipher transform error!");
        }
    }
}

