/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.utils.OneWireMonitorEvent;
import com.dalsemi.onewire.utils.OneWireMonitorEventListener;
import java.util.Vector;

public class OneWireMonitor
extends Thread {
    private boolean keepRunning = true;
    private Vector listeners = new Vector(3);
    private DSPortAdapter adapter;
    private static final int INITIAL_HASH_SIZE = 8;
    private static final int MAX_HASH_SIZE = 256;
    private int hashElementCount;
    private long[] addressHash;
    private int HASH_MASK;
    private int HASH_MAX_COLLISION_SKIP;
    private int enumIndex = 0;
    private int enumCount = 0;

    private OneWireMonitor() {
    }

    public OneWireMonitor(DSPortAdapter dSPortAdapter) {
        this.adapter = dSPortAdapter;
        this.hashElementCount = 0;
        this.addressHash = new long[8];
        this.HASH_MASK = this.addressHash.length - 1;
        this.HASH_MAX_COLLISION_SKIP = this.addressHash.length / 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void killMonitor() {
        OneWireMonitor oneWireMonitor = this;
        synchronized (oneWireMonitor) {
            this.keepRunning = false;
        }
        while (this.isAlive()) {
            this.msSleep(20L);
        }
    }

    public void addEventListener(OneWireMonitorEventListener oneWireMonitorEventListener) {
        if (oneWireMonitorEventListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addElement(oneWireMonitorEventListener);
    }

    public void removeEventListener(OneWireMonitorEventListener oneWireMonitorEventListener) {
        this.listeners.removeElement(oneWireMonitorEventListener);
    }

    private void notifyOfArrival(DSPortAdapter dSPortAdapter, long l) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((OneWireMonitorEventListener)this.listeners.elementAt(n)).oneWireArrival(new OneWireMonitorEvent(this, dSPortAdapter, l));
            ++n;
        }
    }

    private void notifyOfDeparture(DSPortAdapter dSPortAdapter, long l) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((OneWireMonitorEventListener)this.listeners.elementAt(n)).oneWireDeparture(new OneWireMonitorEvent(this, dSPortAdapter, l));
            ++n;
        }
    }

    public void run() {
        while (this.keepRunning) {
            if (this.listeners.size() == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.pollDevices();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long get(long l) {
        int n = (int)(l >>> 56 & (long)this.HASH_MASK);
        int n2 = 0;
        while (n2 < this.HASH_MAX_COLLISION_SKIP) {
            if (this.addressHash[n & this.HASH_MASK] == l) {
                return l;
            }
            ++n;
            ++n2;
        }
        return 0L;
    }

    private void put(long l) {
        int n = (int)(l >>> 56 & (long)this.HASH_MASK);
        int n2 = 0;
        while (n2 < this.HASH_MAX_COLLISION_SKIP) {
            if (this.addressHash[n & this.HASH_MASK] == 0L) {
                this.addressHash[n & this.HASH_MASK] = l;
                ++this.hashElementCount;
                return;
            }
            ++n;
            ++n2;
        }
        int n3 = this.addressHash.length << 1;
        if (n3 > 256) {
            throw new IllegalArgumentException();
        }
        long[] lArray = this.addressHash;
        this.addressHash = new long[n3];
        this.hashElementCount = 0;
        this.HASH_MASK = this.addressHash.length - 1;
        this.HASH_MAX_COLLISION_SKIP = this.addressHash.length / 2;
        this.put(l);
        int n4 = 0;
        while (n4 < lArray.length) {
            if (lArray[n4] != 0L) {
                this.put(lArray[n4]);
            }
            ++n4;
        }
    }

    private void remove(long l) {
        int n = (int)(l >>> 56 & (long)this.HASH_MASK);
        int n2 = 0;
        while (n2 < this.HASH_MAX_COLLISION_SKIP) {
            if (this.addressHash[n & this.HASH_MASK] == l) {
                this.addressHash[n & this.HASH_MASK] = 0L;
                --this.hashElementCount;
                return;
            }
            ++n;
            ++n2;
        }
    }

    private long first() {
        this.enumIndex = 0;
        this.enumCount = this.hashElementCount;
        return this.next();
    }

    /*
     * Unable to fully structure code
     */
    private long next() {
        if (this.enumCount != 0) ** GOTO lbl7
        return 0L;
lbl-1000:
        // 1 sources

        {
            if (this.addressHash[this.enumIndex] != 0L) {
                --this.enumCount;
                return this.addressHash[this.enumIndex++];
            }
            ++this.enumIndex;
lbl7:
            // 2 sources

            ** while (this.enumIndex < this.addressHash.length)
        }
lbl8:
        // 1 sources

        return 0L;
    }

    private void msSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void pollDevices() {
        try {
            block7: {
                try {
                    long l;
                    this.adapter.beginExclusive(true);
                    if (this.adapter.findFirstDevice()) {
                        do {
                            if (this.get(l = this.adapter.getAddressAsLong()) != 0L) continue;
                            this.put(l);
                            this.notifyOfArrival(this.adapter, l);
                        } while (this.adapter.findNextDevice());
                    }
                    if ((l = this.first()) == 0L) break block7;
                    do {
                        if (this.adapter.isPresent(l)) continue;
                        this.remove(l);
                        this.notifyOfDeparture(this.adapter, l);
                    } while ((l = this.next()) != 0L);
                }
                catch (OneWireException oneWireException) {
                    Object var4_4 = null;
                    this.adapter.endExclusive();
                }
            }
            Object var4_3 = null;
            this.adapter.endExclusive();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.adapter.endExclusive();
            throw throwable;
        }
    }
}

