/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.SwitchContainer;
import com.dalsemi.onewire.utils.OWPathElement;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class OWPath {
    private Vector elements;
    private DSPortAdapter adapter;

    public OWPath(DSPortAdapter dSPortAdapter) {
        this.adapter = dSPortAdapter;
        this.elements = new Vector(2, 1);
    }

    public OWPath(DSPortAdapter dSPortAdapter, OWPath oWPath) {
        this.adapter = dSPortAdapter;
        this.elements = new Vector(2, 1);
        this.copy(oWPath);
    }

    public void copy(OWPath oWPath) {
        this.elements.removeAllElements();
        if (oWPath != null) {
            Enumeration enumeration = oWPath.getAllOWPathElements();
            while (enumeration.hasMoreElements()) {
                this.elements.addElement((OWPathElement)enumeration.nextElement());
            }
        }
    }

    public void add(OneWireContainer oneWireContainer, int n) {
        this.elements.addElement(new OWPathElement(oneWireContainer, n));
    }

    public boolean equals(OWPath oWPath) {
        return this.toString().equals(oWPath.toString());
    }

    public Enumeration getAllOWPathElements() {
        return this.elements.elements();
    }

    public String toString() {
        String string = new String("");
        try {
            string = this.adapter.getAdapterName() + "_" + this.adapter.getPortName() + File.separator;
        }
        catch (OneWireException oneWireException) {
            string = this.adapter.getAdapterName() + File.separator;
        }
        int n = 0;
        while (n < this.elements.size()) {
            OWPathElement oWPathElement = (OWPathElement)this.elements.elementAt(n);
            OneWireContainer oneWireContainer = oWPathElement.getContainer();
            string = string + oneWireContainer.getAddressAsString() + "_" + oWPathElement.getChannel() + File.separator;
            ++n;
        }
        return string;
    }

    public void open() throws OneWireException, OneWireIOException {
        int n = 0;
        while (n < this.elements.size()) {
            OWPathElement oWPathElement = (OWPathElement)this.elements.elementAt(n);
            SwitchContainer switchContainer = (SwitchContainer)((Object)oWPathElement.getContainer());
            byte[] byArray = switchContainer.readDevice();
            switchContainer.setLatchState(oWPathElement.getChannel(), true, switchContainer.hasSmartOn(), byArray);
            switchContainer.writeDevice(byArray);
            ++n;
        }
        if (this.elements.size() == 0) {
            this.adapter.reset();
        }
    }

    public void close() throws OneWireException, OneWireIOException {
        int n = this.elements.size() - 1;
        while (n >= 0) {
            OWPathElement oWPathElement = (OWPathElement)this.elements.elementAt(n);
            SwitchContainer switchContainer = (SwitchContainer)((Object)oWPathElement.getContainer());
            byte[] byArray = switchContainer.readDevice();
            switchContainer.setLatchState(oWPathElement.getChannel(), false, false, byArray);
            switchContainer.writeDevice(byArray);
            --n;
        }
    }
}

