/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.OWFile;
import com.dalsemi.onewire.utils.OWFileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class OWFileOutputStream
extends OutputStream {
    private OWFileDescriptor fd;

    public OWFileOutputStream(OneWireContainer oneWireContainer, String string) throws FileNotFoundException {
        this.fd = new OWFileDescriptor(oneWireContainer, string);
        this.fd.create(false, false, false, -1, -1);
    }

    public OWFileOutputStream(OneWireContainer oneWireContainer, String string, boolean bl) throws FileNotFoundException {
        this.fd = new OWFileDescriptor(oneWireContainer, string);
        this.fd.create(bl, false, false, -1, -1);
    }

    public OWFileOutputStream(OWFile oWFile) throws FileNotFoundException {
        try {
            this.fd = oWFile.getFD();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.toString());
        }
        this.fd.open();
    }

    public OWFileOutputStream(OWFileDescriptor oWFileDescriptor) {
        if (oWFileDescriptor == null) {
            throw new NullPointerException("1-Wire FileDescriptor provided is null");
        }
        this.fd = oWFileDescriptor;
    }

    public void write(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("1-Wire FileDescriptor is null");
        }
        this.fd.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.fd == null) {
            throw new IOException("1-Wire FileDescriptor is null");
        }
        this.fd.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.fd == null) {
            throw new IOException("1-Wire FileDescriptor is null");
        }
        this.fd.write(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.fd == null) {
            throw new IOException("1-Wire FileDescriptor is null");
        }
        this.fd.close();
        this.fd = null;
    }

    public OWFileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public void finalize() throws IOException {
        if (this.fd != null) {
            this.fd.close();
        }
    }
}

