/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.OWFile;
import com.dalsemi.onewire.utils.OWFileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class OWFileInputStream
extends InputStream {
    private OWFileDescriptor fd;

    public OWFileInputStream(OneWireContainer oneWireContainer, String string) throws FileNotFoundException {
        this.fd = new OWFileDescriptor(oneWireContainer, string);
        this.fd.open();
        if (!this.fd.isFile()) {
            throw new FileNotFoundException("Not a file");
        }
    }

    public OWFileInputStream(OWFile oWFile) throws FileNotFoundException {
        try {
            this.fd = oWFile.getFD();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.toString());
        }
        this.fd.open();
        if (!this.fd.isFile()) {
            throw new FileNotFoundException("Not a file");
        }
    }

    public OWFileInputStream(OWFileDescriptor oWFileDescriptor) {
        if (oWFileDescriptor == null) {
            throw new NullPointerException("OWFile provided is null");
        }
        this.fd = oWFileDescriptor;
    }

    public int read() throws IOException {
        if (this.fd != null) {
            return this.fd.read();
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public int read(byte[] byArray) throws IOException {
        if (this.fd != null) {
            return this.fd.read(byArray, 0, byArray.length);
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.fd != null) {
            return this.fd.read(byArray, n, n2);
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public long skip(long l) throws IOException {
        if (this.fd != null) {
            return this.fd.skip(l);
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public int available() throws IOException {
        if (this.fd != null) {
            return this.fd.available();
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public void close() throws IOException {
        if (this.fd == null) {
            throw new IOException("1-Wire FileDescriptor is null");
        }
        this.fd.close();
        this.fd = null;
    }

    public final OWFileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException("1-Wire FileDescriptor is null");
    }

    public void finalize() throws IOException {
        if (this.fd != null) {
            this.fd.close();
        }
    }

    public void mark(int n) {
        if (this.fd != null) {
            this.fd.mark(n);
        }
    }

    public void reset() throws IOException {
        if (this.fd != null) {
            this.fd.reset();
        }
    }

    public boolean markSupported() {
        return true;
    }
}

