/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.Bit;
import com.dalsemi.onewire.utils.MemoryCache;
import com.dalsemi.onewire.utils.OWFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.Hashtable;
import java.util.Vector;

public class OWFileDescriptor {
    private static Hashtable memoryCacheHash = new Hashtable(4);
    private static final byte EXT_DIRECTORY = 127;
    private static final byte EXT_UNKNOWN = 126;
    private static final int BM_CACHE = 0;
    private static final int BM_LOCAL = 1;
    private static final int BM_FILE = 2;
    private static final int PAGE_USED = 1;
    private static final int PAGE_NOT_USED = 0;
    private static final int LEN_FILENAME = 5;
    private static final boolean doDebugMessages = false;
    private Long address;
    private MemoryCache cache;
    private OneWireContainer owd;
    private String rawPath;
    private Vector path;
    private Vector verbosePath;
    private int fePage;
    private int feOffset;
    private byte[] feData;
    private int feLen;
    private int feNumPages;
    private int feStartPage;
    private int feParentPage;
    private int feParentOffset;
    private int lastPage;
    private int lastOffset;
    private int lastLen;
    private byte[] lastPageData;
    private int filePosition;
    private int markPosition;
    private int markLimit;
    private int totalPages;
    private int maxDataLen;
    private int LEN_PAGE_PTR;
    private int LEN_FILE_ENTRY;
    private boolean openedToWrite;
    private int lastFreePage;
    private int bitmapType;
    private byte[] pbm;
    private int pbmByteOffset;
    private int pbmBitOffset;
    private int pbmStartPage;
    private int pbmNumPages;
    private byte[] tempPage;
    private byte[] initName = new byte[]{32, 32, 32, 32, 126};
    private byte[] singleBuf;

    public OWFileDescriptor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OWFileDescriptor(OneWireContainer oneWireContainer, String string) {
        Hashtable hashtable = memoryCacheHash;
        synchronized (hashtable) {
            this.owd = oneWireContainer;
            this.rawPath = string != null ? string.toUpperCase() : "";
            this.address = new Long(oneWireContainer.getAddressAsLong());
            this.cache = (MemoryCache)memoryCacheHash.get(this.address);
            if (this.cache == null) {
                this.cache = new MemoryCache(oneWireContainer);
                memoryCacheHash.put(this.address, this.cache);
            }
            this.cache.addOwner(this);
            this.totalPages = this.cache.getNumberPages();
            this.maxDataLen = this.cache.getMaxPacketDataLength();
            this.openedToWrite = false;
            this.lastPageData = new byte[this.maxDataLen];
            this.tempPage = new byte[this.lastPageData.length];
            this.feData = new byte[this.lastPageData.length];
            this.singleBuf = new byte[1];
            this.LEN_PAGE_PTR = this.totalPages > 256 ? 2 : 1;
            this.LEN_FILE_ENTRY = 5 + this.LEN_PAGE_PTR * 2;
            if (this.cache.handlePageBitmap()) {
                this.bitmapType = 0;
            } else if (this.totalPages <= 32) {
                this.bitmapType = 1;
                this.pbm = new byte[this.maxDataLen];
                this.pbmByteOffset = 3;
                this.pbmBitOffset = 0;
            } else {
                this.bitmapType = 2;
                this.pbm = new byte[this.totalPages / 8 + this.LEN_PAGE_PTR];
                this.pbmByteOffset = 0;
                this.pbmBitOffset = 0;
            }
            this.pbmStartPage = -1;
            this.verbosePath = new Vector(3);
            this.parsePath(this.rawPath, this.verbosePath);
            if (this.verbosePath == null) {
                return;
            }
            this.path = new Vector(this.verbosePath.size());
            int n = 0;
            while (n < this.verbosePath.size()) {
                block13: {
                    byte[] byArray = (byte[])this.verbosePath.elementAt(n);
                    if (byArray[0] == 46 && byArray[1] == 46) {
                        if (this.path.size() > 0) {
                            this.path.removeElementAt(this.path.size() - 1);
                            break block13;
                        } else {
                            this.path = null;
                            break;
                        }
                    }
                    if (byArray[0] != 46) {
                        this.path.addElement(byArray);
                    }
                }
                ++n;
            }
            return;
        }
    }

    public boolean valid() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            boolean bl = this.cache != null;
            return bl;
        }
    }

    public void sync() throws SyncFailedException {
        try {
            MemoryCache memoryCache = this.cache;
            synchronized (memoryCache) {
                this.cache.sync();
            }
        }
        catch (OneWireIOException oneWireIOException) {
            throw new SyncFailedException(oneWireIOException.toString());
        }
        catch (OneWireException oneWireException) {
            throw new SyncFailedException(oneWireException.toString());
        }
    }

    protected void open() throws FileNotFoundException {
        String string = null;
        int n = 0;
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            this.lastPage = -1;
            if (this.path == null) {
                throw new FileNotFoundException("Invalid path");
            }
            if (this.path.size() == 0) {
                throw new FileNotFoundException("Invalid path, no elements");
            }
            if (this.feStartPage <= 0) {
                do {
                    try {
                        if (this.verifyPath(this.path.size())) {
                            return;
                        }
                    }
                    catch (OneWireException oneWireException) {
                        string = oneWireException.toString();
                    }
                } while (n++ < 2);
                throw new FileNotFoundException(string);
            }
        }
    }

    protected void close() throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            try {
                this.sync();
            }
            catch (SyncFailedException syncFailedException) {
                throw new IOException(syncFailedException.toString());
            }
            if (this.openedToWrite) {
                this.cache.removeWriteOpen(this.owd.getAddressAsString() + this.getPath());
            }
            this.cache.removeOwner(this);
            if (this.cache.noOwners()) {
                memoryCacheHash.remove(this.address);
                this.cache = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void create(boolean bl, boolean bl2, boolean bl3, int n, int n2) throws FileNotFoundException {
        byte[] byArray = new byte[this.LEN_PAGE_PTR * 2];
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            byte[] byArray2;
            this.lastPage = -1;
            if (this.path == null) {
                throw new FileNotFoundException("Invalid path");
            }
            if (this.path.size() == 0) {
                throw new FileNotFoundException("Invalid path, no elements");
            }
            if ((bl2 || bl3) && ((byArray2 = (byte[])this.path.elementAt(this.path.size() - 1))[4] & 0x7F) != 126 && (byArray2[4] & 0x7F) != 127) {
                throw new FileNotFoundException("Invalid path, directory has an extension");
            }
            if (!bl2) {
                if (this.cache.isOpenedToWrite(this.owd.getAddressAsString() + this.getPath(), true)) {
                    throw new FileNotFoundException("File already opened to write");
                }
                this.openedToWrite = true;
            }
            this.feStartPage = 0;
            boolean bl4 = false;
            byte[] byArray3 = new byte[]{82, 79, 79, 84};
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.path.size()) {
                boolean bl5;
                byArray2 = (byte[])this.path.elementAt(n4);
                try {
                    bl5 = this.findElement(this.feStartPage, byArray2, 0);
                }
                catch (OneWireException oneWireException) {
                    throw new FileNotFoundException(oneWireException.toString());
                }
                if (!bl5) {
                    if (bl2) {
                        if (byArray2[4] == 126) {
                            byArray2[4] = 127;
                        }
                        if (n4 != this.path.size() - 1 && !bl3) {
                            throw new FileNotFoundException("Invalid path, parent not found");
                        }
                        this.createEntry(byArray2, n, n2, byArray3, n3);
                    } else {
                        if (byArray2[4] == 126) {
                            byArray2[4] = 0;
                        }
                        if (n4 != this.path.size() - 1) throw new FileNotFoundException("Path not found");
                        this.createEntry(byArray2, n, n2, byArray3, n3);
                    }
                } else if (n4 == this.path.size() - 1) {
                    if (bl2) {
                        if (n != -1) {
                            throw new FileNotFoundException("Destination File exists");
                        }
                    } else {
                        bl4 = true;
                    }
                }
                this.feStartPage = OWFileDescriptor.byteArrayToInt(this.feData, this.feOffset + 5, this.LEN_PAGE_PTR);
                this.feNumPages = OWFileDescriptor.byteArrayToInt(this.feData, this.feOffset + 5 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                byArray3 = byArray2;
                n3 = this.feStartPage;
                ++n4;
            }
            if (!bl4) return;
            if (!this.canWrite()) {
                throw new FileNotFoundException("File is read only (access is denied)");
            }
            try {
                this.lastLen = this.cache.readPagePacket(this.feStartPage, this.lastPageData, 0);
                this.singleBuf[0] = 0;
                this.cache.writePagePacket(this.feStartPage, this.singleBuf, 0, 1);
                int n5 = OWFileDescriptor.byteArrayToInt(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                while (n5 != 0) {
                    this.readBitMap();
                    this.freePage(n5);
                    this.writeBitMap();
                    this.lastLen = this.cache.readPagePacket(n5, this.lastPageData, 0);
                    n5 = OWFileDescriptor.byteArrayToInt(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                }
                this.feNumPages = 1;
                this.lastLen = this.cache.readPagePacket(this.fePage, this.lastPageData, 0);
                OWFileDescriptor.IntToByteArray(this.lastPageData, this.feOffset + 5 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, this.feNumPages);
                this.cache.writePagePacket(this.fePage, this.lastPageData, 0, this.lastLen);
                this.lastPage = this.feStartPage;
            }
            catch (OneWireException oneWireException) {
                throw new FileNotFoundException(oneWireException.toString());
            }
            return;
        }
    }

    protected void format() throws OneWireException, OneWireIOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.totalPages == 0) {
                throw new OneWireException("1-Wire device does not have memory");
            }
            int n = 0;
            while (n < this.feData.length) {
                this.feData[n] = 0;
                ++n;
            }
            this.feData[0] = this.LEN_PAGE_PTR == 1 ? -86 : -85;
            this.feData[1] = 0;
            if (this.cache.handlePageBitmap()) {
                this.bitmapType = 0;
                this.feData[2] = 0;
                OWFileDescriptor.IntToByteArray(this.feData, 7 - this.LEN_PAGE_PTR * 2, this.LEN_PAGE_PTR, this.cache.getBitMapPageNumber());
                OWFileDescriptor.IntToByteArray(this.feData, 7 - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, this.cache.getBitMapNumberOfPages());
            } else if (this.totalPages <= 32) {
                this.bitmapType = 1;
                this.pbm = new byte[this.maxDataLen];
                this.pbmByteOffset = 3;
                this.pbmBitOffset = 0;
                this.feData[2] = -128;
                this.feData[3] = 1;
            } else {
                this.bitmapType = 2;
                this.pbmByteOffset = 0;
                this.pbmBitOffset = 0;
                int n2 = this.totalPages / 8;
                int n3 = n2 / (this.maxDataLen - this.LEN_PAGE_PTR);
                if (n2 % (this.maxDataLen - this.LEN_PAGE_PTR) > 0) {
                    ++n3;
                }
                this.feData[2] = 0;
                OWFileDescriptor.IntToByteArray(this.feData, 7 - this.LEN_PAGE_PTR * 2, this.LEN_PAGE_PTR, 1);
                OWFileDescriptor.IntToByteArray(this.feData, 7 - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, n3);
                n = 0;
                while (n < this.pbm.length) {
                    this.pbm[n] = 0;
                    ++n;
                }
                n = 0;
                while (n <= n3) {
                    Bit.arrayWriteBit(1, this.pbmBitOffset + n, this.pbmByteOffset, this.pbm);
                    ++n;
                }
                int n4 = 0;
                n = 1;
                while (n <= n3) {
                    int n5 = n2 - n4 > this.maxDataLen - this.LEN_PAGE_PTR ? this.maxDataLen - this.LEN_PAGE_PTR : n2 - n4;
                    System.arraycopy(this.pbm, this.pbmByteOffset + n4, this.tempPage, 0, n5);
                    int n6 = n == n3 ? 0 : n + 1;
                    OWFileDescriptor.IntToByteArray(this.tempPage, n5, this.LEN_PAGE_PTR, n6);
                    this.cache.writePagePacket(n, this.tempPage, 0, n5 + this.LEN_PAGE_PTR);
                    n4 += n5;
                    ++n;
                }
            }
            this.cache.writePagePacket(0, this.feData, 0, 7 + this.LEN_PAGE_PTR);
            if (this.cache.handlePageBitmap()) {
                this.markPageUsed(0);
            }
            this.fePage = 0;
            this.feLen = 7 + this.LEN_PAGE_PTR;
        }
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            int n4;
            int n5;
            if (this.lastPage == -1) {
                this.lastPage = this.feStartPage;
                this.lastOffset = 0;
                this.filePosition = 0;
                this.fetchPage();
            }
            do {
                if (this.lastOffset + 1 >= this.lastLen) {
                    n4 = OWFileDescriptor.byteArrayToInt(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                    if (n4 == 0) break;
                    this.lastPage = n4;
                    this.fetchPage();
                }
                n5 = n2 >= this.lastLen - this.lastOffset - 1 ? this.lastLen - this.lastOffset - 1 : n2;
                if (byArray != null) {
                    System.arraycopy(this.lastPageData, this.lastOffset, byArray, n, n5);
                }
                n3 += n5;
                n += n5;
                this.lastOffset += n5;
                this.filePosition += n5;
                n4 = OWFileDescriptor.byteArrayToInt(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
            } while ((n2 -= n5) != 0 && n4 != 0);
            if (n3 == 0 && n2 != 0) {
                int n6 = -1;
                return n6;
            }
            int n7 = n3;
            return n7;
        }
    }

    protected int read() throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            int n = this.read(this.singleBuf, 0, 1);
            if (n == 1) {
                int n2 = this.singleBuf[0] & 0xFF;
                return n2;
            }
            int n3 = -1;
            return n3;
        }
    }

    protected long skip(long l) throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            long l2 = this.read(null, 0, (int)l);
            return l2;
        }
    }

    protected int available() throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.lastPage == -1) {
                int n = 0;
                return n;
            }
            int n = this.lastLen - this.lastOffset - 1;
            return n;
        }
    }

    protected void write(int n) throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            this.singleBuf[0] = (byte)n;
            this.write(this.singleBuf, 0, 1);
        }
    }

    protected void write(byte[] byArray, int n, int n2) throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (n2 == 0) {
                return;
            }
            try {
                int n3;
                this.lastLen = this.cache.readPagePacket(this.lastPage, this.lastPageData, 0);
                do {
                    if (this.lastLen >= this.maxDataLen) {
                        this.readBitMap();
                        int n4 = this.getFirstFreePage();
                        if (n4 < 0) {
                            try {
                                this.sync();
                            }
                            catch (SyncFailedException syncFailedException) {
                                // empty catch block
                            }
                            throw new IOException("Out of space on 1-Wire device");
                        }
                        this.markPageUsed(n4);
                        this.singleBuf[0] = 0;
                        this.cache.writePagePacket(n4, this.singleBuf, 0, 1);
                        OWFileDescriptor.IntToByteArray(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, n4);
                        this.cache.writePagePacket(this.lastPage, this.lastPageData, 0, this.lastLen);
                        this.writeBitMap();
                        this.lastLen = this.cache.readPagePacket(this.fePage, this.lastPageData, 0);
                        OWFileDescriptor.IntToByteArray(this.lastPageData, this.feOffset + 5 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, ++this.feNumPages);
                        this.cache.writePagePacket(this.fePage, this.lastPageData, 0, this.lastLen);
                        this.lastPageData[0] = 0;
                        this.lastPage = n4;
                        this.lastLen = 1;
                    }
                    n3 = n2 > this.maxDataLen - this.lastLen ? this.maxDataLen - this.lastLen : n2;
                    System.arraycopy(byArray, n, this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, n3);
                    n += n3;
                    this.lastLen += n3;
                    OWFileDescriptor.IntToByteArray(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, 0);
                    this.cache.writePagePacket(this.lastPage, this.lastPageData, 0, this.lastLen);
                } while ((n2 -= n3) > 0);
            }
            catch (OneWireException oneWireException) {
                throw new IOException(oneWireException.toString());
            }
        }
    }

    protected String getName() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            String string = this.pathToString(this.path, this.path.size() - 1, this.path.size(), true);
            return string;
        }
    }

    protected String getParent() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.path == null) {
                throw new NullPointerException("path is not valid");
            }
            if (this.path.size() >= 1) {
                String string = this.pathToString(this.path, 0, this.path.size() - 1, false);
                return string;
            }
            String string = null;
            return string;
        }
    }

    protected String getPath() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.path == null) {
                throw new NullPointerException("path is not valid");
            }
            String string = this.pathToString(this.verbosePath, 0, this.verbosePath.size(), false);
            return string;
        }
    }

    protected boolean exists() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.path.size() == 0) {
                if (this.pbmStartPage == -1) {
                    try {
                        this.readBitMap();
                    }
                    catch (OneWireException oneWireException) {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            try {
                this.open();
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException fileNotFoundException) {
                boolean bl = false;
                return bl;
            }
        }
    }

    protected boolean canRead() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            boolean bl = this.exists();
            return bl;
        }
    }

    protected boolean canWrite() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.exists()) {
                if (this.isFile()) {
                    boolean bl = (this.feData[this.feOffset + 5 - 1] & 0x80) == 0;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected boolean isDirectory() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.exists()) {
                boolean bl = !this.isFile();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected boolean isFile() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.path.size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.exists()) {
                boolean bl = (this.feData[this.feOffset + 5 - 1] & 0x7F) != 127;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected boolean isHidden() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.exists() && this.path.size() > 0 && this.isDirectory()) {
                byte[] byArray = (byte[])this.path.elementAt(this.path.size() - 1);
                boolean bl = (byArray[4] & 0x80) != 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected long length() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.exists()) {
                long l = this.feNumPages * (this.maxDataLen - this.LEN_PAGE_PTR);
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    protected boolean delete() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.isFile()) {
                try {
                    int n;
                    System.arraycopy(this.feData, this.feOffset + this.LEN_FILE_ENTRY, this.feData, this.feOffset, this.feLen - this.feOffset - this.LEN_FILE_ENTRY);
                    this.feLen -= this.LEN_FILE_ENTRY;
                    this.cache.writePagePacket(this.fePage, this.feData, 0, this.feLen);
                    if (this.bitmapType != 0) {
                        n = this.feStartPage;
                        while (n != 0) {
                            this.readBitMap();
                            this.freePage(n);
                            this.writeBitMap();
                            this.lastLen = this.cache.readPagePacket(n, this.lastPageData, 0);
                            n = OWFileDescriptor.byteArrayToInt(this.lastPageData, this.lastLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                        }
                        this.lastPage = -1;
                        this.feStartPage = -1;
                    }
                    n = 1;
                    return n != 0;
                }
                catch (OneWireException oneWireException) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.isDirectory()) {
                try {
                    int n = this.cache.readPagePacket(this.feStartPage, this.tempPage, 0);
                    if (n != this.LEN_FILE_ENTRY + this.LEN_PAGE_PTR) {
                        boolean bl = false;
                        return bl;
                    }
                    System.arraycopy(this.feData, this.feOffset + this.LEN_FILE_ENTRY, this.feData, this.feOffset, this.feLen - this.feOffset - this.LEN_FILE_ENTRY);
                    this.feLen -= this.LEN_FILE_ENTRY;
                    this.cache.writePagePacket(this.fePage, this.feData, 0, this.feLen);
                    this.readBitMap();
                    this.freePage(this.feStartPage);
                    this.writeBitMap();
                    boolean bl = true;
                    return bl;
                }
                catch (OneWireException oneWireException) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    protected String[] list() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.isDirectory()) {
                Vector<String> vector = new Vector<String>(1);
                try {
                    int n = this.feStartPage;
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = this.LEN_FILE_ENTRY;
                    do {
                        int n3 = n;
                        int n4 = this.cache.readPagePacket(n3, this.tempPage, 0);
                        while (n2 < n4 - this.LEN_PAGE_PTR) {
                            stringBuffer.setLength(0);
                            int n5 = 0;
                            while (n5 < 4) {
                                if (this.tempPage[n2 + n5] == 32) break;
                                stringBuffer.append((char)this.tempPage[n2 + n5]);
                                ++n5;
                            }
                            if (this.tempPage[n2 + 4] != 127) {
                                stringBuffer.append("." + Integer.toString(this.tempPage[n2 + 4] & 0x7F));
                            }
                            vector.addElement(stringBuffer.toString());
                            n2 += this.LEN_FILE_ENTRY;
                        }
                        n = OWFileDescriptor.byteArrayToInt(this.tempPage, n4 - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                        n2 = 0;
                        if (vector.size() <= this.totalPages) continue;
                        String[] stringArray = null;
                        return stringArray;
                    } while (n != 0);
                }
                catch (OneWireException oneWireException) {
                    // empty catch block
                }
                String[] stringArray = new String[vector.size()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = (String)vector.elementAt(n);
                    ++n;
                }
                String[] stringArray2 = stringArray;
                return stringArray2;
            }
            String[] stringArray = null;
            return stringArray;
        }
    }

    protected boolean renameTo(OWFile oWFile) {
        if (oWFile == null) {
            throw new NullPointerException("Desitination file is null");
        }
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (!this.exists()) {
                boolean bl = false;
                return bl;
            }
            try {
                OWFileDescriptor oWFileDescriptor = oWFile.getFD();
                oWFileDescriptor.create(false, this.isDirectory(), false, this.feStartPage, this.feNumPages);
                this.feLen = this.cache.readPagePacket(this.fePage, this.feData, 0);
                System.arraycopy(this.feData, this.feOffset + this.LEN_FILE_ENTRY, this.feData, this.feOffset, this.feLen - this.feOffset - this.LEN_FILE_ENTRY);
                this.feLen -= this.LEN_FILE_ENTRY;
                this.cache.writePagePacket(this.fePage, this.feData, 0, this.feLen);
                this.feStartPage = -1;
                try {
                    this.open();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            catch (OneWireException oneWireException) {
                boolean bl = false;
                return bl;
            }
        }
    }

    protected boolean setReadOnly() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.isFile()) {
                int n = this.feOffset + 5 - 1;
                this.feData[n] = (byte)(this.feData[n] | 0x80);
                try {
                    this.cache.writePagePacket(this.fePage, this.feData, 0, this.feLen);
                }
                catch (OneWireException oneWireException) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected void mark(int n) {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            this.markPosition = this.filePosition;
            this.markLimit = n;
        }
    }

    protected void reset() throws IOException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.filePosition - this.markPosition > this.markLimit) {
                throw new IOException("File read beyond mark readlimit");
            }
            this.lastPage = -1;
            this.skip(this.markPosition);
        }
    }

    protected void markPageUsed(int n) throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.bitmapType == 0) {
                this.cache.markPageUsed(n);
            } else {
                Bit.arrayWriteBit(1, this.pbmBitOffset + n, this.pbmByteOffset, this.pbm);
            }
        }
    }

    protected boolean freePage(int n) throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.bitmapType == 0) {
                boolean bl = this.cache.freePage(n);
                return bl;
            }
            Bit.arrayWriteBit(0, this.pbmBitOffset + n, this.pbmByteOffset, this.pbm);
            boolean bl = true;
            return bl;
        }
    }

    protected int getFirstFreePage() throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.bitmapType == 0) {
                int n = this.cache.getFirstFreePage();
                return n;
            }
            this.lastFreePage = 0;
            int n = this.getNextFreePage();
            return n;
        }
    }

    protected int getNextFreePage() throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.bitmapType == 0) {
                int n = this.cache.getNextFreePage();
                return n;
            }
            int n = this.lastFreePage;
            while (n < this.totalPages) {
                if (Bit.arrayReadBit(this.pbmBitOffset + n, this.pbmByteOffset, this.pbm) == 0) {
                    this.lastFreePage = n + 1;
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
            int n3 = -1;
            return n3;
        }
    }

    protected int getFreeMemory() throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.bitmapType == 0) {
                int n = this.cache.getNumberFreePages() * (this.maxDataLen - this.LEN_PAGE_PTR);
                return n;
            }
            this.readBitMap();
            int n = 0;
            int n2 = 0;
            while (n2 < this.totalPages) {
                if (Bit.arrayReadBit(this.pbmBitOffset + n2, this.pbmByteOffset, this.pbm) == 0) {
                    ++n;
                }
                ++n2;
            }
            int n3 = n * (this.maxDataLen - this.LEN_PAGE_PTR);
            return n3;
        }
    }

    protected void writeBitMap() throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            if (this.bitmapType == 1) {
                int n = this.cache.readPagePacket(0, this.tempPage, 0);
                int n2 = 3;
                while (n2 < 7) {
                    if ((this.tempPage[n2] & 0xFF) != (this.pbm[n2] & 0xFF)) {
                        System.arraycopy(this.pbm, 3, this.tempPage, 3, 4);
                        this.cache.writePagePacket(0, this.tempPage, 0, n);
                        break;
                    }
                    ++n2;
                }
            } else if (this.bitmapType == 2) {
                int n = 0;
                int n3 = this.pbmStartPage;
                int n4 = 0;
                while (n4 < this.pbmNumPages) {
                    int n5 = this.cache.readPagePacket(n3, this.tempPage, 0);
                    int n6 = 0;
                    while (n6 < n5 - this.LEN_PAGE_PTR) {
                        if ((this.tempPage[n6] & 0xFF) != (this.pbm[n6 + n] & 0xFF)) {
                            System.arraycopy(this.pbm, n, this.tempPage, 0, n5 - this.LEN_PAGE_PTR);
                            this.cache.writePagePacket(n3, this.tempPage, 0, n5);
                            break;
                        }
                        ++n6;
                    }
                    n3 = OWFileDescriptor.byteArrayToInt(this.tempPage, n5 - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                    n += n5 - this.LEN_PAGE_PTR;
                    ++n4;
                }
            }
        }
    }

    protected void readBitMap() throws OneWireException {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            int n;
            if (this.pbmStartPage == -1) {
                n = this.cache.readPagePacket(0, this.tempPage, 0);
                this.validateFileSystem(this.tempPage, n);
            }
            if (this.bitmapType == 1) {
                this.cache.readPagePacket(0, this.pbm, 0);
            } else if (this.bitmapType == 2) {
                int n2 = 0;
                int n3 = this.pbmStartPage;
                int n4 = 0;
                while (n4 < this.pbmNumPages) {
                    n = this.cache.readPagePacket(n3, this.pbm, n2);
                    n3 = OWFileDescriptor.byteArrayToInt(this.pbm, n - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                    n2 += n - this.LEN_PAGE_PTR;
                    ++n4;
                }
            }
        }
    }

    protected int[] getPageList() throws OneWireException {
        int[] nArray;
        int[] nArray2 = new int[this.feNumPages + 10];
        int n = 0;
        int n2 = this.feStartPage;
        do {
            if (n >= nArray2.length) {
                nArray = new int[nArray2.length + 10];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray2 = nArray;
            }
            nArray2[n++] = n2;
            int n3 = this.cache.readPagePacket(n2, this.tempPage, 0);
            n2 = OWFileDescriptor.byteArrayToInt(this.tempPage, n3 - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
            if (n <= this.totalPages) continue;
            throw new OneWireException("Error in file system, looping pointers");
        } while (n2 != 0);
        nArray = new int[n];
        System.arraycopy(nArray2, 0, nArray, 0, n);
        return nArray;
    }

    protected PagedMemoryBank getMemoryBankForPage(int n) {
        return this.cache.getMemoryBankForPage(n);
    }

    protected int getLocalPage(int n) {
        return this.cache.getLocalPage(n);
    }

    private String pathToString(Vector vector, int n, int n2, boolean bl) {
        if (n < 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(bl ? "" : "/");
        int n3 = n;
        while (n3 < n2) {
            byte[] byArray = (byte[])vector.elementAt(n3);
            if (!bl && n3 != n) {
                stringBuffer.append('/');
            }
            int n4 = 0;
            while (n4 < 4) {
                if (byArray[n4] == 32) break;
                stringBuffer.append((char)byArray[n4]);
                ++n4;
            }
            if (byArray[4] != 127 && byArray[4] != 126) {
                stringBuffer.append("." + Integer.toString(byArray[4]));
            }
            ++n3;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean verifyPath(int n) throws OneWireException {
        this.feStartPage = 0;
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = (byte[])this.path.elementAt(n2);
            this.feParentPage = this.feStartPage;
            this.feParentOffset = this.feOffset;
            if (!this.findElement(this.feStartPage, byArray, 0)) {
                return false;
            }
            this.feStartPage = OWFileDescriptor.byteArrayToInt(this.feData, this.feOffset + 5, this.LEN_PAGE_PTR);
            this.feNumPages = OWFileDescriptor.byteArrayToInt(this.feData, this.feOffset + 5 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
            ++n2;
        }
        return true;
    }

    private boolean findElement(int n, byte[] byArray, int n2) throws OneWireException {
        int n3 = n;
        this.feOffset = this.LEN_FILE_ENTRY;
        do {
            this.fePage = n3;
            this.feLen = this.cache.readPagePacket(this.fePage, this.feData, 0);
            if (this.fePage == 0) {
                this.validateFileSystem(this.feData, this.feLen);
            }
            while (this.feOffset < this.feLen - this.LEN_PAGE_PTR) {
                if (this.elementEquals(byArray, n2, this.feData, this.feOffset)) {
                    if ((this.feData[this.feOffset + 5 - 1] & 0x80) != 0) {
                        int n4 = n2 + 5 - 1;
                        byArray[n4] = (byte)(byArray[n4] | 0x80);
                    }
                    return true;
                }
                this.feOffset += this.LEN_FILE_ENTRY;
            }
            n3 = OWFileDescriptor.byteArrayToInt(this.feData, this.feLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
            if (n3 == 0) continue;
            this.feOffset = 0;
        } while (n3 != 0);
        return false;
    }

    private boolean elementEquals(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            if (byArray[n + n3] != byArray2[n2 + n3]) {
                return false;
            }
            ++n3;
        }
        if (byArray[n + 4] == 126) {
            if ((byArray2[n2 + 4] & 0x7F) == 0) {
                byArray[n + 4] = 0;
            } else if ((byArray2[n2 + 4] & 0x7F) == 127) {
                byArray[n + 4] = 127;
            }
        }
        return (byte)(byArray[n + 4] & 0x7F) == (byte)(byArray2[n2 + 4] & 0x7F);
    }

    private void fetchPage() throws IOException {
        try {
            this.lastLen = this.cache.readPagePacket(this.lastPage, this.lastPageData, 0);
            this.lastOffset = 0;
        }
        catch (OneWireException oneWireException) {
            throw new IOException(oneWireException.toString());
        }
    }

    private void createEntry(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws FileNotFoundException {
        block24: {
            try {
                int n4;
                if (this.feLen + this.LEN_FILE_ENTRY <= this.maxDataLen) {
                    int n5;
                    this.readBitMap();
                    if (n != -1) {
                        n5 = n;
                    } else {
                        n5 = this.getFirstFreePage();
                        if (n5 < 0) {
                            try {
                                this.sync();
                            }
                            catch (SyncFailedException syncFailedException) {
                                // empty catch block
                            }
                            throw new FileNotFoundException("Out of space on 1-Wire device");
                        }
                    }
                    int n6 = OWFileDescriptor.byteArrayToInt(this.feData, this.feLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
                    System.arraycopy(byArray, 0, this.feData, this.feLen - this.LEN_PAGE_PTR, 5);
                    OWFileDescriptor.IntToByteArray(this.feData, this.feLen - this.LEN_PAGE_PTR + 5, this.LEN_PAGE_PTR, n5);
                    OWFileDescriptor.IntToByteArray(this.feData, this.feLen - this.LEN_PAGE_PTR + 5 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, n2 == -1 ? 1 : n2);
                    this.feOffset = this.feLen - this.LEN_PAGE_PTR;
                    this.feLen += this.LEN_FILE_ENTRY;
                    OWFileDescriptor.IntToByteArray(this.feData, this.feLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, n6);
                    if (n == -1) {
                        this.markPageUsed(n5);
                        if ((byArray[4] & 0x7F) == 127) {
                            this.tempPage[0] = this.totalPages > 256 ? -85 : -86;
                            this.tempPage[1] = 0;
                            System.arraycopy(byArray2, 0, this.tempPage, 2, 4);
                            OWFileDescriptor.IntToByteArray(this.tempPage, 6, this.LEN_PAGE_PTR, n3);
                            OWFileDescriptor.IntToByteArray(this.tempPage, 6 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, 0);
                            this.cache.writePagePacket(n5, this.tempPage, 0, 6 + this.LEN_PAGE_PTR * 2);
                        } else {
                            this.singleBuf[0] = 0;
                            this.cache.writePagePacket(n5, this.singleBuf, 0, 1);
                        }
                    }
                    this.cache.writePagePacket(this.fePage, this.feData, 0, this.feLen);
                    this.writeBitMap();
                    if ((byArray[4] & 0x7F) != 127) {
                        this.filePosition = 0;
                        this.lastPage = n5;
                        this.lastOffset = 0;
                        this.lastLen = 1;
                    }
                    break block24;
                }
                this.readBitMap();
                int n7 = this.getFirstFreePage();
                if (n7 < 0) {
                    try {
                        this.sync();
                    }
                    catch (SyncFailedException syncFailedException) {
                        // empty catch block
                    }
                    throw new FileNotFoundException("Out of space on 1-Wire device");
                }
                this.markPageUsed(n7);
                if (n != -1) {
                    n4 = n;
                } else {
                    n4 = this.getNextFreePage();
                    if (n4 < 0) {
                        try {
                            this.sync();
                        }
                        catch (SyncFailedException syncFailedException) {
                            // empty catch block
                        }
                        throw new FileNotFoundException("Out of space on 1-Wire device");
                    }
                    this.markPageUsed(n4);
                }
                System.arraycopy(byArray, 0, this.lastPageData, 0, 5);
                OWFileDescriptor.IntToByteArray(this.lastPageData, 5, this.LEN_PAGE_PTR, n4);
                OWFileDescriptor.IntToByteArray(this.lastPageData, 5 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, n2 == -1 ? 1 : n2);
                this.feOffset = 0;
                OWFileDescriptor.IntToByteArray(this.lastPageData, this.LEN_FILE_ENTRY, this.LEN_PAGE_PTR, 0);
                this.cache.writePagePacket(n7, this.lastPageData, 0, this.LEN_FILE_ENTRY + this.LEN_PAGE_PTR);
                if (n == -1) {
                    if ((byArray[4] & 0x7F) == 127) {
                        this.tempPage[0] = this.totalPages > 256 ? -85 : -86;
                        this.tempPage[1] = 0;
                        System.arraycopy(byArray2, 0, this.tempPage, 2, 4);
                        OWFileDescriptor.IntToByteArray(this.tempPage, 6, this.LEN_PAGE_PTR, n3);
                        OWFileDescriptor.IntToByteArray(this.tempPage, 6 + this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, 0);
                        this.cache.writePagePacket(n4, this.tempPage, 0, 6 + this.LEN_PAGE_PTR * 2);
                    } else {
                        this.singleBuf[0] = 0;
                        this.cache.writePagePacket(n4, this.singleBuf, 0, 1);
                    }
                }
                OWFileDescriptor.IntToByteArray(this.feData, this.feLen - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR, n7);
                this.cache.writePagePacket(this.fePage, this.feData, 0, this.feLen);
                this.fePage = n7;
                this.feOffset = 0;
                this.feLen = this.LEN_FILE_ENTRY + this.LEN_PAGE_PTR;
                System.arraycopy(this.lastPageData, 0, this.feData, 0, this.feLen);
                this.writeBitMap();
                if ((byArray[4] & 0x7F) != 127) {
                    this.filePosition = 0;
                    this.lastPage = n4;
                    this.lastOffset = 0;
                    this.lastLen = 1;
                }
            }
            catch (OneWireException oneWireException) {
                throw new FileNotFoundException(oneWireException.toString());
            }
        }
    }

    private void validateFileSystem(byte[] byArray, int n) throws OneWireIOException {
        if (this.totalPages <= 256 && (byArray[0] & 0xFF) != 170 || byArray[1] != 0) {
            throw new OneWireIOException("Invalid file system marker found (not AA00)");
        }
        if (this.totalPages > 256 && (byArray[0] & 0xFF) != 171 || byArray[1] != 0) {
            throw new OneWireIOException("Invalid file system marker found (not AB00)");
        }
        if ((byArray[2] & 0x80) != 0) {
            this.bitmapType = 1;
            this.pbmByteOffset = 3;
            this.pbmBitOffset = 0;
        } else if (this.bitmapType != 0) {
            this.bitmapType = 2;
            this.pbmStartPage = OWFileDescriptor.byteArrayToInt(byArray, 7 - this.LEN_PAGE_PTR * 2, this.LEN_PAGE_PTR);
            this.pbmNumPages = OWFileDescriptor.byteArrayToInt(byArray, 7 - this.LEN_PAGE_PTR, this.LEN_PAGE_PTR);
            this.pbmByteOffset = 0;
            this.pbmBitOffset = 0;
        }
    }

    private void parsePath(String string, Vector vector) {
        int n;
        int n2 = 0;
        do {
            n = string.indexOf("/", n2);
            int n3 = 0;
            if (n == -1 && n2 < string.length()) {
                n = string.length();
            }
            if (n > 0) {
                String string2 = string.substring(n2, n);
                if (string2.length() == 0) {
                    vector = null;
                    return;
                }
                byte[] byArray = new byte[5];
                System.arraycopy(this.initName, 0, byArray, 0, 5);
                int n4 = string2.indexOf(".", 0);
                if (n4 == -1) {
                    if (string2.length() > 4) {
                        vector = null;
                        return;
                    }
                    System.arraycopy(string2.getBytes(), 0, byArray, 0, string2.length());
                    n3 = string2.length();
                    if (n != string.length()) {
                        byArray[4] = 127;
                    }
                } else if (n4 == 0) {
                    if (string2.length() > 2) {
                        vector = null;
                        return;
                    }
                    System.arraycopy(string2.getBytes(), 0, byArray, 0, string2.length());
                    byArray[4] = 127;
                    n3 = string2.length();
                } else {
                    n3 = n4;
                    System.arraycopy(string2.getBytes(), 0, byArray, 0, n4);
                    try {
                        byArray[4] = (byte)Integer.parseInt(string2.substring(n4 + 1, string2.length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector = null;
                        return;
                    }
                    if (n != string.length() || (byArray[4] & 0xFF) > 102) {
                        vector = null;
                        return;
                    }
                }
                int n5 = 0;
                while (n5 < n3) {
                    if ((byArray[n5] & 0xFF) < 33 || (byArray[n5] & 0xFF) > 126) {
                        vector = null;
                        return;
                    }
                    ++n5;
                }
                vector.addElement(byArray);
            }
            n2 = n + 1;
        } while (n > -1);
    }

    private static int byteArrayToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            n3 <<= 8;
            n3 |= byArray[n + n4] & 0xFF;
            --n4;
        }
        return n3;
    }

    private static void IntToByteArray(byte[] byArray, int n, int n2, int n3) throws IllegalArgumentException {
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)n3;
            n3 >>>= 8;
            ++n4;
        }
        if (n3 > 0) {
            throw new IllegalArgumentException("Argument is larger then " + n2 + " bytes");
        }
    }

    protected boolean createNewFile() throws IOException {
        if (this.exists()) {
            return false;
        }
        try {
            this.create(false, false, false, -1, -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException.toString());
        }
        return true;
    }

    protected int getHashCode() {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            int n = 0;
            String string = this.owd.getAddressAsString() + this.getPath();
            byte[] byArray = string.getBytes();
            int n2 = 0;
            while (n2 < byArray.length / 4) {
                n ^= OWFileDescriptor.byteArrayToInt(byArray, n2 * 4, 4);
                ++n2;
            }
            int n3 = 0;
            while (n3 < byArray.length % 4) {
                n ^= byArray[n2 * 4 + n3] & 0xFF;
                ++n3;
            }
            int n4 = n;
            return n4;
        }
    }

    private void debugDump(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            System.out.print(Integer.toHexString(byArray[n3] & 0xFF) + " ");
            ++n3;
        }
        System.out.println();
    }
}

