/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.OWFileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;

public class OWFile {
    public static final String separator = "/";
    public static final char separatorChar = '/';
    public static final String pathSeparator = ":";
    public static final char pathSeparatorChar = ':';
    private OneWireContainer owd;
    private OWFileDescriptor fd;

    public OWFile(OneWireContainer oneWireContainer, String string) {
        this.owd = oneWireContainer;
        this.fd = new OWFileDescriptor(oneWireContainer, string);
    }

    public OWFile(OneWireContainer oneWireContainer, String string, String string2) {
        this.owd = oneWireContainer;
        if (string2 == null) {
            throw new NullPointerException("child is null");
        }
        this.fd = new OWFileDescriptor(oneWireContainer, string + string2);
    }

    public OWFile(OWFile oWFile, String string) {
        if (string == null) {
            throw new NullPointerException("child is null");
        }
        this.owd = oWFile.getOneWireContainer();
        this.fd = new OWFileDescriptor(this.owd, oWFile.getAbsolutePath() + string);
    }

    public String getName() {
        return this.fd.getName();
    }

    public String getParent() {
        return this.fd.getParent();
    }

    public OWFile getParentFile() {
        return new OWFile(this.owd, this.fd.getParent());
    }

    public String getPath() {
        return this.fd.getPath();
    }

    public boolean isAbsolute() {
        return true;
    }

    public String getAbsolutePath() {
        return this.fd.getPath();
    }

    public OWFile getAbsoluteFile() {
        return new OWFile(this.owd, this.fd.getPath());
    }

    public String getCanonicalPath() throws IOException {
        return this.fd.getPath();
    }

    public OWFile getCanonicalFile() throws IOException {
        return new OWFile(this.owd, this.fd.getPath());
    }

    public boolean canRead() {
        return this.fd.canRead();
    }

    public boolean canWrite() {
        return this.fd.canWrite();
    }

    public boolean exists() {
        return this.fd.exists();
    }

    public boolean isDirectory() {
        return this.fd.isDirectory();
    }

    public boolean isFile() {
        return this.fd.isFile();
    }

    public boolean isHidden() {
        return this.fd.isHidden();
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return this.fd.length();
    }

    public boolean createNewFile() throws IOException {
        return this.fd.createNewFile();
    }

    public boolean delete() {
        return this.fd.delete();
    }

    public String[] list() {
        if (this.isFile() || !this.isDirectory()) {
            return null;
        }
        return this.fd.list();
    }

    public OWFile[] listFiles() {
        if (this.isFile() || !this.isDirectory()) {
            return null;
        }
        String[] stringArray = this.fd.list();
        OWFile[] oWFileArray = new OWFile[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = this.fd.getPath() == null || this.fd.getPath().endsWith(separator) ? separator + stringArray[n] : this.fd.getPath() + separator + stringArray[n];
            oWFileArray[n] = new OWFile(this.owd, string);
            ++n;
        }
        return oWFileArray;
    }

    public boolean mkdir() {
        try {
            this.fd.create(false, true, false, -1, -1);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public boolean mkdirs() {
        try {
            this.fd.create(false, true, true, -1, -1);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public boolean renameTo(OWFile oWFile) {
        return this.fd.renameTo(oWFile);
    }

    public boolean setLastModified(long l) {
        return false;
    }

    public boolean setReadOnly() {
        boolean bl = this.fd.setReadOnly();
        return bl;
    }

    public static OWFile[] listRoots(OneWireContainer oneWireContainer) {
        OWFile[] oWFileArray = new OWFile[]{new OWFile(oneWireContainer, separator)};
        return oWFileArray;
    }

    public int compareTo(OWFile oWFile) {
        String string = this.owd.getAddressAsString() + this.getPath();
        String string2 = oWFile.getOneWireContainer().getAddressAsString() + oWFile.getPath();
        return string.compareTo(string2);
    }

    public int compareTo(Object object) {
        return this.compareTo((OWFile)object);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof OWFile)) {
            return false;
        }
        return this.compareTo((OWFile)object) == 0;
    }

    public int hashCode() {
        return this.fd.getHashCode();
    }

    public String toString() {
        return this.fd.getPath();
    }

    public OWFileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public OneWireContainer getOneWireContainer() {
        return this.owd;
    }

    public void format() throws IOException {
        try {
            this.fd.format();
        }
        catch (OneWireException oneWireException) {
            throw new IOException(oneWireException.toString());
        }
    }

    public int getFreeMemory() throws IOException {
        try {
            return this.fd.getFreeMemory();
        }
        catch (OneWireException oneWireException) {
            throw new IOException(oneWireException.toString());
        }
    }

    public void close() throws IOException {
        this.fd.close();
        this.fd = null;
    }

    public int[] getPageList() throws IOException {
        try {
            return this.fd.getPageList();
        }
        catch (OneWireException oneWireException) {
            throw new IOException(oneWireException.toString());
        }
    }

    public PagedMemoryBank getMemoryBankForPage(int n) {
        return this.fd.getMemoryBankForPage(n);
    }

    public int getLocalPage(int n) {
        return this.fd.getLocalPage(n);
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.fd.close();
        }
    }
}

