/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.Address;
import com.dalsemi.onewire.utils.NetworkMonitor;
import com.dalsemi.onewire.utils.OWPath;
import java.util.EventObject;

public class NetworkMonitorEvent
extends EventObject {
    private DSPortAdapter adapter;
    private long address;
    private OWPath path;

    public NetworkMonitorEvent(NetworkMonitor networkMonitor, DSPortAdapter dSPortAdapter, long l, OWPath oWPath) {
        super(networkMonitor);
        this.adapter = dSPortAdapter;
        this.address = l;
        this.path = oWPath;
    }

    public OneWireContainer getDeviceContainer() {
        return this.adapter.getDeviceContainer(this.address);
    }

    public DSPortAdapter getAdapter() {
        return this.adapter;
    }

    public OWPath getOWPath() {
        return this.path;
    }

    public byte[] getAddress() {
        return Address.toByteArray(this.address);
    }

    public long getAddressAsLong() {
        return this.address;
    }

    public String getAddressAsString() {
        return Address.toString(this.address);
    }
}

