/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.Address;
import com.dalsemi.onewire.utils.NetworkDeviceState;
import com.dalsemi.onewire.utils.NetworkMonitorEvent;
import com.dalsemi.onewire.utils.NetworkMonitorEventListener;
import com.dalsemi.onewire.utils.OWPath;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NetworkMonitor
extends Thread {
    private boolean keepRunning = true;
    private boolean startRunning = true;
    private boolean isRunning = false;
    private DSPortAdapter adapter;
    private Vector paths;
    private Hashtable list;
    private Vector listeners;

    private NetworkMonitor() {
    }

    public NetworkMonitor(DSPortAdapter dSPortAdapter) {
        this.adapter = dSPortAdapter;
        this.paths = new Vector(1, 2);
        this.paths.addElement(new OWPath(dSPortAdapter));
        this.list = new Hashtable();
        this.listeners = new Vector(3);
    }

    public void addEventListener(NetworkMonitorEventListener networkMonitorEventListener) {
        if (networkMonitorEventListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addElement(networkMonitorEventListener);
    }

    public void removeEventListener(NetworkMonitorEventListener networkMonitorEventListener) {
        this.listeners.removeElement(networkMonitorEventListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pauseMonitor() {
        if (!this.keepRunning) {
            return;
        }
        NetworkMonitor networkMonitor = this;
        synchronized (networkMonitor) {
            this.startRunning = false;
        }
        while (this.isRunning) {
            this.msSleep(10L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resumeMonitor() {
        if (!this.keepRunning) {
            return;
        }
        NetworkMonitor networkMonitor = this;
        synchronized (networkMonitor) {
            this.startRunning = true;
        }
        while (!this.isRunning) {
            this.msSleep(10L);
        }
    }

    public boolean isMonitorRunning() {
        return this.keepRunning && this.startRunning && this.isRunning;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void killMonitor() {
        NetworkMonitor networkMonitor = this;
        synchronized (networkMonitor) {
            this.keepRunning = false;
            this.startRunning = false;
        }
        while (this.isAlive()) {
            this.msSleep(20L);
        }
    }

    public void run() {
        NetworkMonitor networkMonitor;
        while (this.keepRunning) {
            if (this.startRunning) {
                block20: {
                    Object var10_10;
                    networkMonitor = this;
                    synchronized (networkMonitor) {
                        this.isRunning = true;
                    }
                    try {
                        try {
                            this.adapter.beginExclusive(true);
                            int n = 0;
                            while (n < this.paths.size()) {
                                this.search((OWPath)this.paths.elementAt(n));
                                ++n;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            var10_10 = null;
                            this.adapter.endExclusive();
                            continue;
                        }
                        catch (OneWireIOException oneWireIOException) {
                            this.notifyOfException(oneWireIOException);
                            var10_10 = null;
                            this.adapter.endExclusive();
                            break block20;
                        }
                        catch (OneWireException oneWireException) {
                            this.notifyOfException(oneWireException);
                            var10_10 = null;
                            this.adapter.endExclusive();
                        }
                        var10_10 = null;
                        this.adapter.endExclusive();
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        this.adapter.endExclusive();
                        throw throwable;
                    }
                }
                Enumeration enumeration = this.list.keys();
                while (enumeration.hasMoreElements()) {
                    Long l = (Long)enumeration.nextElement();
                    NetworkDeviceState networkDeviceState = (NetworkDeviceState)this.list.get(l);
                    if (networkDeviceState.getCount() <= 1) {
                        this.list.remove(l);
                        this.notifyOfDeparture(this.adapter, l, networkDeviceState.getOWPath());
                        continue;
                    }
                    networkDeviceState.setCount(networkDeviceState.getCount() - 1);
                }
                this.msSleep(100L);
                continue;
            }
            networkMonitor = this;
            synchronized (networkMonitor) {
                this.isRunning = false;
            }
            this.msSleep(100L);
        }
        networkMonitor = this;
        synchronized (networkMonitor) {
            this.isRunning = false;
        }
    }

    private void closeAllPaths() throws OneWireException, OneWireIOException {
        this.adapter.reset();
        this.adapter.putByte(204);
        this.adapter.putByte(102);
        this.adapter.getByte();
    }

    private void msSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void notifyOfArrival(DSPortAdapter dSPortAdapter, long l, OWPath oWPath) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((NetworkMonitorEventListener)this.listeners.elementAt(n)).networkArrival(new NetworkMonitorEvent(this, dSPortAdapter, l, oWPath));
            ++n;
        }
    }

    private void notifyOfDeparture(DSPortAdapter dSPortAdapter, long l, OWPath oWPath) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((NetworkMonitorEventListener)this.listeners.elementAt(n)).networkDeparture(new NetworkMonitorEvent(this, dSPortAdapter, l, oWPath));
            ++n;
        }
    }

    private void notifyOfException(Exception exception) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((NetworkMonitorEventListener)this.listeners.elementAt(n)).networkException(exception);
            ++n;
        }
    }

    private void search(OWPath oWPath) throws InterruptedException, OneWireException, OneWireIOException {
        this.closeAllPaths();
        this.adapter.setNoResetSearch();
        oWPath.open();
        boolean bl = this.adapter.findFirstDevice();
        while (bl) {
            OWPath oWPath2;
            if (!this.startRunning) {
                throw new InterruptedException("search interrupted");
            }
            Long l = new Long(this.adapter.getAddressAsLong());
            NetworkDeviceState networkDeviceState = (NetworkDeviceState)this.list.get(l);
            if (networkDeviceState == null) {
                this.list.put(l, new NetworkDeviceState(this.adapter, oWPath));
                this.notifyOfArrival(this.adapter, l, oWPath);
                byte[] byArray = Address.toByteArray(l);
                if (byArray[0] == 31) {
                    OneWireContainer oneWireContainer = this.adapter.getDeviceContainer();
                    oWPath2 = new OWPath(this.adapter, oWPath);
                    oWPath2.add(oneWireContainer, 0);
                    this.paths.addElement(oWPath2);
                    oWPath2 = new OWPath(this.adapter, oWPath);
                    oWPath2.add(oneWireContainer, 1);
                    this.paths.addElement(oWPath2);
                }
            } else {
                oWPath2 = networkDeviceState.getOWPath();
                if (!oWPath.equals(oWPath2)) {
                    this.list.remove(l);
                    this.notifyOfDeparture(this.adapter, l, oWPath2);
                    this.list.put(l, new NetworkDeviceState(this.adapter, oWPath));
                    this.notifyOfArrival(this.adapter, l, oWPath);
                } else {
                    networkDeviceState.setCount(3);
                }
            }
            oWPath.open();
            bl = this.adapter.findNextDevice();
        }
        this.closeAllPaths();
    }
}

