/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBank;
import com.dalsemi.onewire.container.OTPMemoryBank;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.Bit;
import com.dalsemi.onewire.utils.CRC16;
import java.util.Enumeration;
import java.util.Vector;

class MemoryCache {
    private static final int NOT_READ = 0;
    private static final int READ_CRC = 1;
    private static final int READ_NO_CRC = 2;
    private static final int VERIFY = 3;
    private static final int REDIRECT = 4;
    private static final int WRITE = 5;
    private static final int EMPTY = -1;
    private static final int NONE = -100;
    private static final int USED = 0;
    private static final int NOT_USED = 1;
    private static final boolean doDebugMessages = false;
    private OneWireContainer owd;
    private byte[][] cache;
    private int[] len;
    private int[] pageState;
    private Vector banks;
    private int totalPages;
    private int lastPageRead;
    private int maxPacketDataLength;
    private int[] bankPages;
    private int[] writeLog;
    private byte[] tempExtra;
    private byte[] tempPage;
    private int[] redirect;
    private Vector owners;
    private Vector openedToWrite;
    private boolean canRedirect;
    private OTPMemoryBank pbmBank;
    private int pbmByteOffset;
    private int pbmBitOffset;
    private byte[] pbmCache;
    private byte[] pbmCacheModified;
    private boolean pbmRead;
    private int lastFreePage;

    public MemoryCache(OneWireContainer oneWireContainer) {
        this.owd = oneWireContainer;
        int n = 0;
        PagedMemoryBank pagedMemoryBank = null;
        this.banks = new Vector(1);
        this.owners = new Vector(1);
        this.openedToWrite = new Vector(1);
        Enumeration enumeration = this.owd.getMemoryBanks();
        while (enumeration.hasMoreElements()) {
            MemoryBank memoryBank = (MemoryBank)enumeration.nextElement();
            if (memoryBank.isWriteOnce() && !memoryBank.isGeneralPurposeMemory() && memoryBank.isNonVolatile() && memoryBank instanceof OTPMemoryBank && (n == 128 || memoryBank.getBankDescription().indexOf("Bitmap") != -1)) {
                this.pbmBank = (OTPMemoryBank)memoryBank;
                if (n == 128) {
                    this.pbmBitOffset = 4;
                }
                this.pbmByteOffset = 0;
                this.canRedirect = true;
            }
            if (!memoryBank.isGeneralPurposeMemory() || !memoryBank.isNonVolatile() || !(memoryBank instanceof PagedMemoryBank)) continue;
            this.banks.addElement(memoryBank);
            n += memoryBank.getSize();
        }
        this.bankPages = new int[this.banks.size()];
        this.totalPages = 0;
        int n2 = 0;
        while (n2 < this.banks.size()) {
            pagedMemoryBank = (PagedMemoryBank)this.banks.elementAt(n2);
            this.bankPages[n2] = pagedMemoryBank.getNumberPages();
            this.totalPages += this.bankPages[n2];
            ++n2;
        }
        this.len = new int[this.totalPages];
        this.pageState = new int[this.totalPages];
        this.writeLog = new int[this.totalPages];
        this.redirect = new int[this.totalPages];
        if (pagedMemoryBank != null) {
            this.maxPacketDataLength = pagedMemoryBank.getMaxPacketDataLength();
            this.cache = new byte[this.totalPages][pagedMemoryBank.getPageLength()];
            this.tempPage = new byte[pagedMemoryBank.getPageLength()];
        }
        int n3 = 0;
        while (n3 < this.totalPages) {
            this.pageState[n3] = 0;
            this.len[n3] = 0;
            this.writeLog[n3] = -1;
            ++n3;
        }
        if (this.canRedirect) {
            this.tempExtra = new byte[pagedMemoryBank.getExtraInfoLength()];
            this.pbmCache = new byte[this.pbmBank.getSize()];
            this.pbmCacheModified = new byte[this.pbmBank.getSize()];
            this.pbmRead = false;
        } else {
            this.pbmRead = true;
        }
    }

    public int getNumberPages() {
        return this.totalPages;
    }

    public int getMaxPacketDataLength() {
        return this.maxPacketDataLength;
    }

    public boolean isWriteOnce() {
        return this.canRedirect;
    }

    public int readPagePacket(int n, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        if (this.totalPages == 0) {
            throw new OneWireException("1-Wire device does not have memory");
        }
        if (n >= this.totalPages) {
            throw new OneWireException("Page requested is not in memory space");
        }
        if (!this.pbmRead) {
            this.readPageBitMap();
        }
        if (this.pageState[n] == 0 || this.pageState[n] == 2 || this.redirect[n] != 0) {
            int n3 = this.getLocalPage(n);
            PagedMemoryBank pagedMemoryBank = this.getMemoryBankForPage(n);
            if (this.canRedirect) {
                block18: {
                    int n4 = 0;
                    do {
                        if (this.redirect[n] == 0) {
                            if (this.pageState[n] == 1 || this.pageState[n] == 3 || this.pageState[n] == 5) break block18;
                            if (pagedMemoryBank.hasExtraInfo()) {
                                pagedMemoryBank.readPageCRC(n, this.lastPageRead == n - 1, this.cache[n], 0, this.tempExtra);
                                this.lastPageRead = n;
                                this.redirect[n] = ~this.tempExtra[0] & 0xFF;
                            } else {
                                pagedMemoryBank.readPageCRC(n, this.lastPageRead == n - 1, this.cache[n], 0);
                                this.redirect[n] = (byte)((OTPMemoryBank)pagedMemoryBank).getRedirectedPage(n);
                                this.lastPageRead = -100;
                            }
                            this.pageState[n] = 2;
                            if (this.redirect[n] != 0) continue;
                            if (this.cache[n][0] > this.maxPacketDataLength) {
                                throw new OneWireIOException("Invalid length in packet");
                            }
                            if (CRC16.compute(this.cache[n], 0, this.cache[n][0] + 3, n) == 45057) {
                                this.len[n] = this.cache[n][0];
                                this.pageState[n] = 1;
                                break block18;
                            }
                            throw new OneWireIOException("Invalid CRC16 in packet read " + n);
                        }
                        n = this.redirect[n];
                    } while (n4++ <= this.totalPages);
                    throw new OneWireIOException("Circular redirection of pages");
                }
                if (byArray != null) {
                    System.arraycopy(this.cache[n], 1, byArray, n2, this.len[n]);
                }
                return this.len[n];
            }
            while (true) {
                pagedMemoryBank.readPage(n3, this.lastPageRead == n - 1, this.tempPage, 0);
                this.lastPageRead = n;
                if ((this.tempPage[0] & 0xFF) <= this.maxPacketDataLength && CRC16.compute(this.tempPage, 0, this.tempPage[0] + 3, n) == 45057) break;
                boolean bl = true;
                int n5 = 0;
                while (n5 < this.tempPage.length) {
                    if ((this.tempPage[n5] & 0xFF) != (this.cache[n][n5] & 0xFF)) {
                        bl = false;
                        break;
                    }
                    ++n5;
                }
                if (bl) {
                    this.pageState[n] = 2;
                    throw new OneWireIOException("Invalid CRC16 in packet read");
                }
                System.arraycopy(this.tempPage, 0, this.cache[n], 0, this.tempPage.length);
            }
            System.arraycopy(this.tempPage, 0, this.cache[n], 0, this.tempPage.length);
            this.len[n] = this.tempPage[0];
            this.pageState[n] = 1;
            if (byArray != null) {
                System.arraycopy(this.cache[n], 1, byArray, n2, this.len[n]);
            }
            return this.len[n];
        }
        if (byArray != null) {
            System.arraycopy(this.cache[n], 1, byArray, n2, this.len[n]);
        }
        return this.len[n];
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (this.totalPages == 0) {
            throw new OneWireException("1-Wire device does not have memory");
        }
        if (!this.pbmRead) {
            this.readPageBitMap();
        }
        if (this.canRedirect) {
            int n4;
            OTPMemoryBank oTPMemoryBank = (OTPMemoryBank)this.getMemoryBankForPage(n);
            if (this.redirect[n] == 0 && this.pageState[n] == 0) {
                this.redirect[n] = oTPMemoryBank.getRedirectedPage(n);
            }
            if (this.redirect[n] != 0) {
                n4 = n;
                int n5 = 0;
                this.lastPageRead = -100;
                do {
                    n4 = this.redirect[n4];
                    this.redirect[n4] = oTPMemoryBank.getRedirectedPage(n4);
                    if (n5++ <= this.totalPages) continue;
                    throw new OneWireException("Error in file system, circular redirection of pages");
                } while (this.redirect[n4] != 0);
                System.arraycopy(byArray, n2, this.cache[n4], 1, n3);
                this.len[n4] = n3;
                this.cache[n4][0] = (byte)n3;
                int n6 = CRC16.compute(this.cache[n4], 0, n3 + 1, n4);
                this.cache[n4][n3 + 1] = (byte)(~n6 & 0xFF);
                this.cache[n4][n3 + 2] = (byte)((~n6 & 0xFFFF) >>> 8 & 0xFF);
                this.pageState[n4] = 3;
                n = n4;
            } else {
                System.arraycopy(byArray, n2, this.cache[n], 1, n3);
                this.len[n] = n3;
                this.cache[n][0] = (byte)n3;
                n4 = CRC16.compute(this.cache[n], 0, n3 + 1, n);
                this.cache[n][n3 + 1] = (byte)(~n4 & 0xFF);
                this.cache[n][n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
                this.pageState[n] = 3;
            }
        } else {
            System.arraycopy(byArray, n2, this.cache[n], 1, n3);
            this.len[n] = n3;
            this.cache[n][0] = (byte)n3;
            this.pageState[n] = 5;
        }
        int n7 = 0;
        while (n7 < this.totalPages) {
            if (this.writeLog[n7] == n || this.writeLog[n7] == -1) break;
            ++n7;
        }
        while (n7 > 0) {
            this.writeLog[n7] = this.writeLog[n7 - 1];
            --n7;
        }
        this.writeLog[0] = n;
    }

    public void sync() throws OneWireIOException, OneWireException {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (this.totalPages == 0) {
            return;
        }
        do {
            bl = false;
            int n4 = this.totalPages - 1;
            while (n4 >= 0) {
                if (this.writeLog[n4] != -1) {
                    bl = true;
                    int n5 = this.writeLog[n4];
                    PagedMemoryBank pagedMemoryBank = this.getMemoryBankForPage(n5);
                    n3 = this.getLocalPage(n5);
                    if (this.pageState[n5] == 3) {
                        pagedMemoryBank.readPageCRC(n5, this.lastPageRead == n5 - 1, this.tempPage, 0);
                        this.lastPageRead = n5;
                        boolean bl2 = false;
                        n2 = 1;
                        while (n2 < this.len[n5] + 2) {
                            if (((this.tempPage[n2] & 0xFF ^ this.cache[n5][n2] & 0xFF) & (~this.tempPage[n2] & 0xFF)) > 0) {
                                bl2 = true;
                                break;
                            }
                            ++n2;
                        }
                        if (bl2) {
                            n = this.getFirstFreePage();
                            while (n == n5) {
                                System.out.println("_can't use this page " + n5);
                                this.markPageUsed(n);
                                n = this.getNextFreePage();
                            }
                            if (n < 0) {
                                throw new OneWireException("Redireciton required but out of space on 1-Wire device");
                            }
                            this.markPageUsed(n);
                            System.arraycopy(this.cache[n5], 0, this.cache[n], 0, this.tempPage.length);
                            this.pageState[n] = 3;
                            this.len[n] = this.len[n5];
                            int n6 = 0;
                            while (n6 < this.totalPages) {
                                if (this.writeLog[n6] == -1) {
                                    this.writeLog[n6] = n;
                                    break;
                                }
                                ++n6;
                            }
                            this.pageState[n5] = 4;
                            this.cache[n5][0] = (byte)(n & 0xFF);
                        } else {
                            this.pageState[n5] = 5;
                        }
                    }
                    if (this.pageState[n5] == 4) {
                        ((OTPMemoryBank)pagedMemoryBank).redirectPage(n5, this.cache[n5][0] & 0xFF);
                        this.pageState[n5] = 0;
                        this.lastPageRead = -100;
                        this.writeLog[n4] = -1;
                    }
                    if (this.pageState[n5] == 5) {
                        pagedMemoryBank.writePagePacket(n3, this.cache[n5], 1, this.len[n5]);
                        this.pageState[n5] = 1;
                        this.lastPageRead = -100;
                        this.writeLog[n4] = -1;
                    }
                }
                --n4;
            }
        } while (bl);
        if (this.canRedirect) {
            int n7 = this.totalPages / 8;
            if (n7 == 0) {
                n7 = 1;
            }
            n3 = 0;
            byte[] byArray = new byte[n7];
            n2 = 0;
            while (n2 < n7) {
                byArray[n2] = (byte)(~(this.pbmCache[n2] ^ this.pbmCacheModified[n2]) & 0xFF);
                if (byArray[n2] != -1) {
                    n3 = 1;
                }
                ++n2;
            }
            if (n3 != 0) {
                this.pbmBank.setWriteVerification(false);
                this.pbmBank.write(0, byArray, 0, n7);
                this.pbmBank.read(0, false, byArray, 0, n7);
                n = 0;
                while (n < n7) {
                    if ((byArray[n] & 0xFF) != (this.pbmCacheModified[n] & 0xFF)) {
                        throw new OneWireException("Readback verfication of page bitmap was not correct");
                    }
                    ++n;
                }
                System.arraycopy(byArray, 0, this.pbmCache, 0, n7);
                System.arraycopy(byArray, 0, this.pbmCacheModified, 0, n7);
            }
        }
    }

    public void addOwner(Object object) {
        if (this.owners.indexOf(object) == -1) {
            this.owners.addElement(object);
        }
    }

    public void removeOwner(Object object) {
        this.owners.removeElement(object);
    }

    public boolean noOwners() {
        return this.owners.isEmpty();
    }

    public void removeWriteOpen(String string) {
        int n = this.openedToWrite.indexOf(string);
        if (n != -1) {
            this.openedToWrite.removeElementAt(n);
        }
    }

    public boolean isOpenedToWrite(String string, boolean bl) {
        int n = this.openedToWrite.indexOf(string);
        if (n != -1) {
            return true;
        }
        if (bl) {
            this.openedToWrite.addElement(string);
        }
        return false;
    }

    public boolean handlePageBitmap() {
        return this.pbmBank != null;
    }

    public void markPageUsed(int n) {
        Bit.arrayWriteBit(0, this.pbmBitOffset + n, this.pbmByteOffset, this.pbmCacheModified);
    }

    public boolean freePage(int n) {
        if (Bit.arrayReadBit(this.pbmBitOffset + n, this.pbmByteOffset, this.pbmCache) == 1) {
            Bit.arrayWriteBit(1, this.pbmBitOffset + n, this.pbmByteOffset, this.pbmCacheModified);
            return true;
        }
        return false;
    }

    public int getFirstFreePage() {
        this.lastFreePage = 0;
        return this.getNextFreePage();
    }

    public int getNextFreePage() {
        int n = this.lastFreePage;
        while (n < this.totalPages) {
            if (Bit.arrayReadBit(this.pbmBitOffset + n, this.pbmByteOffset, this.pbmCacheModified) == 1) {
                this.lastFreePage = n + 1;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getNumberFreePages() throws OneWireException {
        if (!this.pbmRead) {
            this.pbmBank.read(0, false, this.pbmCache, 0, this.pbmCache.length);
            System.arraycopy(this.pbmCache, 0, this.pbmCacheModified, 0, this.pbmCache.length);
            this.pbmRead = true;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.totalPages) {
            if (Bit.arrayReadBit(this.pbmBitOffset + n2, this.pbmByteOffset, this.pbmCacheModified) == 1) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getBitMapPageNumber() {
        return this.pbmBank.getStartPhysicalAddress() / this.pbmBank.getPageLength();
    }

    public int getBitMapNumberOfPages() {
        return this.totalPages / 8 / this.pbmBank.getPageLength();
    }

    public PagedMemoryBank getMemoryBankForPage(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.banks.size()) {
            if (n2 + this.bankPages[n3] > n) {
                return (PagedMemoryBank)this.banks.elementAt(n3);
            }
            n2 += this.bankPages[n3];
            ++n3;
        }
        return null;
    }

    public int getLocalPage(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.banks.size()) {
            if (n2 + this.bankPages[n3] > n) {
                return n - n2;
            }
            n2 += this.bankPages[n3];
            ++n3;
        }
        return 0;
    }

    private void readPageBitMap() throws OneWireException {
        this.pbmBank.read(0, false, this.pbmCache, 0, this.pbmCache.length);
        System.arraycopy(this.pbmCache, 0, this.pbmCacheModified, 0, this.pbmCache.length);
        this.pbmRead = true;
    }

    private void debugDump(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            System.out.print(Integer.toHexString(byArray[n3] & 0xFF) + " ");
            ++n3;
        }
        System.out.println();
    }
}

