/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

public class CRC8 {
    private static byte[] dscrc_table = new byte[256];

    private CRC8() {
    }

    public static int compute(int n, int n2) {
        return dscrc_table[(n2 ^ n) & 0xFF] & 0xFF;
    }

    public static int compute(int n) {
        return dscrc_table[n & 0xFF] & 0xFF;
    }

    public static int compute(byte[] byArray) {
        return CRC8.compute(byArray, 0, byArray.length);
    }

    public static int compute(byte[] byArray, int n, int n2) {
        return CRC8.compute(byArray, n, n2, 0);
    }

    public static int compute(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3;
        int n5 = 0;
        while (n5 < n2) {
            n4 = dscrc_table[(n4 ^ byArray[n5 + n]) & 0xFF];
            ++n5;
        }
        return n4 & 0xFF;
    }

    public static int compute(byte[] byArray, int n) {
        return CRC8.compute(byArray, 0, byArray.length, n);
    }

    static {
        int n = 0;
        while (n < 256) {
            int n2 = n;
            int n3 = 0;
            int n4 = 0;
            while (n4 < 8) {
                n3 = ((n2 ^ n3) & 1) == 1 ? (n3 ^ 0x18) >> 1 | 0x80 : (n3 >>= 1);
                n2 >>= 1;
                ++n4;
            }
            CRC8.dscrc_table[n] = (byte)n3;
            ++n;
        }
    }
}

