/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

public class CRC16 {
    private static final int[] ODD_PARITY = new int[]{0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0};

    private CRC16() {
    }

    public static int compute(int n) {
        return CRC16.compute(n, 0);
    }

    public static int compute(int n, int n2) {
        int n3 = (n ^ n2 & 0xFF) & 0xFF;
        n2 >>>= 8;
        int n4 = n3 & 0xF;
        int n5 = n3 >>> 4;
        if ((ODD_PARITY[n4] ^ ODD_PARITY[n5]) == 1) {
            n2 ^= 0xC001;
        }
        n2 ^= (n3 <<= 6);
        return n2 ^= (n3 <<= 1);
    }

    public static int compute(byte[] byArray) {
        return CRC16.compute(byArray, 0, byArray.length, 0);
    }

    public static int compute(byte[] byArray, int n, int n2) {
        return CRC16.compute(byArray, n, n2, 0);
    }

    public static int compute(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            n3 = CRC16.compute(byArray[n4 + n], n3);
            ++n4;
        }
        return n3;
    }

    public static int compute(byte[] byArray, int n) {
        return CRC16.compute(byArray, 0, byArray.length, n);
    }
}

