/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.utils;

import com.dalsemi.onewire.utils.CRC8;

public class Address {
    private Address() {
    }

    public static boolean isValid(byte[] byArray) {
        return byArray[0] != 0 && CRC8.compute(byArray) == 0;
    }

    public static boolean isValid(String string) {
        return Address.isValid(Address.toByteArray(string));
    }

    public static boolean isValid(long l) {
        return Address.isValid(Address.toByteArray(l));
    }

    public static String toString(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        int n2 = 7;
        while (n2 >= 0) {
            int n3;
            byArray2[n++] = (byte)(n3 += (n3 = byArray[n2] >> 4 & 0xF) > 9 ? 55 : 48);
            n3 = byArray[n2] & 0xF;
            byArray2[n++] = (byte)(n3 += n3 > 9 ? 55 : 48);
            --n2;
        }
        return new String(byArray2);
    }

    public static String toString(long l) {
        return Address.toString(Address.toByteArray(l));
    }

    public static byte[] toByteArray(String string) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[7 - n] = (byte)(Character.digit(string.charAt(n * 2), 16) << 4 | Character.digit(string.charAt(n * 2 + 1), 16));
            ++n;
        }
        return byArray;
    }

    public static byte[] toByteArray(long l) {
        byte[] byArray = new byte[]{(byte)l, (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8)};
        return byArray;
    }

    public static long toLong(byte[] byArray) {
        long l = byArray[7] & 0xFF;
        l <<= 8;
        l |= (long)(byArray[6] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[5] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[4] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[0] & 0xFF);
    }

    public static long toLong(String string) {
        return Address.toLong(Address.toByteArray(string));
    }
}

