/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer18;
import com.dalsemi.onewire.utils.CRC16;

public class SHAiButton {
    private OneWireContainer18 ibc = null;
    private byte[] address;
    private boolean isCoprocessor;
    private boolean isUser;
    private byte[] bind_data = new byte[32];
    private byte[] bind_code = new byte[7];
    private byte[] filename = null;
    private int signing_page_number = -1;
    private int authentication_page_number = -1;
    private int workspace_page_number = -1;
    private byte[] signing_challenge = new byte[3];
    private byte[] initial_signature = new byte[20];
    private int user_account_file_page;
    private byte[] generic_money_page = new byte[32];
    private byte[] scratchpad_buffer = new byte[32];
    private int last_error = 0;
    public static final int NO_ERROR = 0;
    public static final int ERASE_SCRATCHPAD_ERROR = 1;
    public static final int WRITE_SCRATCHPAD_ERROR = 2;
    public static final int READ_SCRATCHPAD_ERROR = 3;
    public static final int READ_MEMORY_PAGE_ERROR = 4;
    public static final int READ_AUTHENTICATED_ERROR = 5;
    public static final int BIND_SECRET_ERROR = 6;
    public static final int WRITE_MEMORY_PAGE_ERROR = 7;
    public static final int SHA_FUNCTION_ERROR = 8;
    public static final int CRC_ERROR = 9;
    public static final int NO_COPROCESSOR_ERROR = 10;
    public static final int NO_USER_ERROR = 11;
    public static final int AUTHENTICATION_FAILED_ERROR = 12;
    public static final int VERIFICATION_FAILED_ERROR = 13;
    private byte[] answer_readpg = new byte[42];
    private byte[] answer_pad_challenge = new byte[32];
    private byte[] authentication_mac1 = new byte[20];
    private byte[] authentication_full_bind_code1 = new byte[15];
    private byte[] authentication_pad_challenge1 = new byte[32];
    private byte[] auth_challenge = new byte[3];
    private byte[] sign_scratchpad1 = new byte[32];
    private byte[] verify_macpage = new byte[20];
    private byte[] verify_scratchpad1 = new byte[32];
    private byte[] pg0 = new byte[32];

    public SHAiButton() {
    }

    public SHAiButton(OneWireContainer18 oneWireContainer18) {
        this.ibc = oneWireContainer18;
        this.isCoprocessor = false;
        this.isUser = false;
        this.address = oneWireContainer18.getAddress();
        System.arraycopy(oneWireContainer18.FF, 0, this.bind_data, 0, 32);
        System.arraycopy(oneWireContainer18.FF, 0, this.bind_code, 0, 7);
    }

    public void setiButton(OneWireContainer18 oneWireContainer18) {
        this.ibc = oneWireContainer18;
        this.isCoprocessor = false;
        this.isUser = false;
        this.address = oneWireContainer18.getAddress();
        System.arraycopy(oneWireContainer18.FF, 0, this.bind_data, 0, 32);
        System.arraycopy(oneWireContainer18.FF, 0, this.bind_code, 0, 7);
    }

    public synchronized void setBindData(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.bind_data, 0, 32);
    }

    public synchronized void setBindCode(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.bind_code, 0, 7);
    }

    public synchronized byte[] getBindData() {
        byte[] byArray = new byte[this.bind_data.length];
        System.arraycopy(this.bind_data, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public synchronized byte[] getBindCode() {
        byte[] byArray = new byte[this.bind_code.length];
        System.arraycopy(this.bind_code, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public synchronized int answerChallenge(byte[] byArray, byte[] byArray2, byte[] byArray3) throws OneWireIOException, OneWireException {
        this.last_error = 0;
        System.arraycopy(byArray, 0, this.answer_pad_challenge, 20, 3);
        if (this.ibc.eraseScratchPad(this.user_account_file_page)) {
            this.ibc.useResume(true);
            if (this.ibc.writeScratchPad(this.user_account_file_page, 0, this.answer_pad_challenge, 0, 32)) {
                boolean bl = this.ibc.readAuthenticatedPage(this.user_account_file_page, this.answer_readpg, 0);
                int n = this.answer_readpg[35] & 0xFF;
                n = n << 8 | this.answer_readpg[34] & 0xFF;
                n = n << 8 | this.answer_readpg[33] & 0xFF;
                n = n << 8 | this.answer_readpg[32] & 0xFF;
                int n2 = this.ibc.readScratchPad(this.scratchpad_buffer, 0);
                if (!bl || n2 < 0) {
                    this.last_error = !bl ? 5 : 3;
                    return -1;
                }
                System.arraycopy(this.answer_readpg, 0, byArray3, 0, 32);
                System.arraycopy(this.scratchpad_buffer, 8, byArray2, 0, 20);
                this.ibc.useResume(false);
                return n;
            }
            this.last_error = 2;
            this.ibc.useResume(false);
            return -1;
        }
        this.last_error = 1;
        this.ibc.useResume(false);
        return -1;
    }

    public synchronized boolean generateChallenge(int n, int n2, byte[] byArray) throws OneWireIOException, OneWireException {
        this.last_error = 0;
        int n3 = n << 5;
        if (this.ibc.eraseScratchPad(n)) {
            this.ibc.useResume(true);
            if (this.ibc.SHAFunction((byte)-52, n3)) {
                int n4 = this.ibc.readScratchPad(this.scratchpad_buffer, 0);
                System.arraycopy(this.scratchpad_buffer, 8 + n2 % 17, byArray, 0, 3);
                this.ibc.useResume(false);
                return true;
            }
            this.last_error = 8;
            this.ibc.useResume(false);
            return false;
        }
        this.last_error = 1;
        this.ibc.useResume(false);
        return false;
    }

    public synchronized int verifyAuthentication(SHAiButton sHAiButton, byte[] byArray) throws OneWireException, OneWireIOException {
        this.last_error = 0;
        int n = sHAiButton.user_account_file_page;
        int n2 = this.workspace_page_number;
        byte[] byArray2 = this.authentication_pad_challenge1;
        byte[] byArray3 = this.authentication_full_bind_code1;
        byte[] byArray4 = this.authentication_mac1;
        if (!this.isCoprocessor) {
            this.last_error = 10;
            return -1;
        }
        if (!sHAiButton.isUser) {
            this.last_error = 11;
            return -1;
        }
        this.generateChallenge(this.authentication_page_number, 0, this.auth_challenge);
        int n3 = sHAiButton.answerChallenge(this.auth_challenge, byArray4, byArray);
        OneWireContainer18 oneWireContainer18 = this.ibc;
        System.arraycopy(this.bind_code, 0, byArray3, 0, 4);
        byArray3[4] = (byte)n;
        System.arraycopy(sHAiButton.address, 0, byArray3, 5, 7);
        System.arraycopy(this.bind_code, 4, byArray3, 12, 3);
        byArray2[8] = (byte)(n3 & 0xFF);
        byArray2[9] = (byte)(n3 >> 8 & 0xFF);
        byArray2[10] = (byte)(n3 >> 16 & 0xFF);
        byArray2[11] = (byte)(n3 >> 24 & 0xFF);
        System.arraycopy(this.auth_challenge, 0, byArray2, 20, 3);
        System.arraycopy(byArray3, 4, byArray2, 12, 8);
        if (oneWireContainer18.bindSecretToiButton(this.authentication_page_number, this.bind_data, byArray3, n2)) {
            oneWireContainer18.useResume(true);
            if (oneWireContainer18.writeDataPage(n2, byArray)) {
                if (oneWireContainer18.writeScratchPad(n2, 0, byArray2, 0, 32)) {
                    int n4 = n2 << 5;
                    if (oneWireContainer18.SHAFunction((byte)60, n4)) {
                        if (oneWireContainer18.matchScratchPad(byArray4)) {
                            oneWireContainer18.useResume(false);
                            return n3;
                        }
                        this.last_error = 12;
                    } else {
                        this.last_error = 8;
                    }
                } else {
                    this.last_error = 2;
                }
            } else {
                this.last_error = 7;
            }
        } else {
            this.last_error = 6;
        }
        this.ibc.useResume(false);
        return -1;
    }

    public boolean isCoprocessor() {
        return this.isCoprocessor;
    }

    public String toString() {
        return this.ibc.getAddressAsString();
    }

    public synchronized boolean setUser(int n) {
        if (n < 8) {
            n += 8;
        }
        this.user_account_file_page = n;
        this.generic_money_page[0] = 29;
        this.isUser = true;
        return true;
    }

    public synchronized void setInitialSignature(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.initial_signature, 0, byArray.length > 20 + n ? 20 : byArray.length - n);
    }

    public synchronized void setSigningChallenge(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.signing_challenge, 0, byArray.length > 3 + n ? 3 : byArray.length - n);
    }

    public synchronized void setFilename(byte[] byArray, int n) {
        this.filename = new byte[5];
        System.arraycopy(byArray, n, this.filename, 0, 5);
        this.checkCoprocessor();
    }

    public synchronized void setSigningPageNumber(int n) {
        if (n == 0) {
            n = 8;
        }
        this.signing_page_number = n;
        this.checkCoprocessor();
    }

    public synchronized void setAuthenticationPageNumber(int n) {
        if (n < 8) {
            n += 8;
        }
        this.authentication_page_number = n;
        this.checkCoprocessor();
    }

    public synchronized void setWorkspacePageNumber(int n) {
        this.workspace_page_number = n;
        this.checkCoprocessor();
    }

    private boolean checkCoprocessor() {
        if (this.signing_page_number != -1 && this.authentication_page_number != -1 && this.workspace_page_number != -1 && this.filename != null) {
            this.isCoprocessor = true;
        }
        return this.isCoprocessor;
    }

    public String getUserFileName() {
        return new String(this.filename, 0, 4);
    }

    public int getUserFileExtension() {
        return this.filename[4] & 0xFF;
    }

    public synchronized boolean signDataFile(SHAiButton sHAiButton, int n, int n2, byte[] byArray) throws OneWireIOException, OneWireException {
        int n3;
        Object object;
        this.last_error = 0;
        if (!this.isCoprocessor) {
            this.last_error = 10;
            return false;
        }
        if (!sHAiButton.isUser) {
            this.last_error = 11;
            return false;
        }
        byte[] byArray2 = sHAiButton.generic_money_page;
        int n4 = sHAiButton.user_account_file_page;
        byte[] byArray3 = this.sign_scratchpad1;
        System.arraycopy(byArray, 1, byArray2, 1, 4);
        byArray2[28] = byArray[28];
        System.arraycopy(this.initial_signature, 0, byArray2, 8, this.initial_signature.length > 20 ? 20 : this.initial_signature.length);
        byArray2[5] = (byte)n;
        byArray2[6] = (byte)(n >> 8);
        byArray2[7] = (byte)(n >> 16);
        byArray2[30] = 0;
        byArray2[31] = 0;
        int n5 = 0;
        if (n2 == -1) {
            object = new byte[32];
            sHAiButton.ibc.readMemoryPage(19, (byte[])object, 0);
            n3 = (n4 & 7) << 2;
            n5 = object[n3++] & 0xFF;
            n5 |= (object[n3++] & 0xFF) << 8;
            n5 |= (object[n3++] & 0xFF) << 16;
            n5 |= (object[n3] & 0xFF) << 24;
        } else {
            n5 = n2;
        }
        byArray3[8] = (byte)(++n5 & 0xFF);
        byArray3[9] = (byte)(n5 >> 8 & 0xFF);
        byArray3[10] = (byte)(n5 >> 16 & 0xFF);
        byArray3[11] = (byte)(n5 >> 24 & 0xFF);
        byArray3[12] = (byte)n4;
        System.arraycopy(sHAiButton.address, 0, byArray3, 13, 7);
        System.arraycopy(this.signing_challenge, 0, byArray3, 20, 3);
        object = this.ibc;
        if (!((OneWireContainer18)object).writeDataPage(this.signing_page_number, byArray2)) {
            this.last_error = 7;
            return false;
        }
        ((OneWireContainer18)object).useResume(true);
        if (!((OneWireContainer18)object).writeScratchPad(0, 0, byArray3, 0, 32)) {
            this.last_error = 2;
            ((OneWireContainer18)object).useResume(false);
            return false;
        }
        n3 = this.signing_page_number << 5;
        if (!((OneWireContainer18)object).SHAFunction((byte)-61, n3)) {
            this.last_error = 8;
            ((OneWireContainer18)object).useResume(false);
            return false;
        }
        ((OneWireContainer18)object).readScratchPad(byArray3, 0);
        System.arraycopy(byArray3, 8, sHAiButton.generic_money_page, 8, 20);
        int n6 = ~CRC16.compute(byArray2, 0, byArray2[0] + 1, n4);
        byArray2[30] = (byte)n6;
        byArray2[31] = (byte)(n6 >> 8);
        ((OneWireContainer18)object).useResume(false);
        if (!sHAiButton.ibc.writeDataPage(n4, byArray2)) {
            this.last_error = 7;
            return false;
        }
        return true;
    }

    public synchronized boolean verifyUserMoney(byte[] byArray, SHAiButton sHAiButton, int n) throws OneWireIOException, OneWireException {
        this.last_error = 0;
        int n2 = sHAiButton.user_account_file_page;
        byte[] byArray2 = this.verify_scratchpad1;
        if (!this.isCoprocessor) {
            this.last_error = 10;
            return false;
        }
        if (!sHAiButton.isUser) {
            this.last_error = 11;
            return false;
        }
        System.arraycopy(byArray, 8, this.verify_macpage, 0, 20);
        System.arraycopy(this.initial_signature, 0, byArray, 8, 20);
        byArray[30] = 0;
        byArray[31] = 0;
        byArray2[8] = (byte)n;
        byArray2[9] = (byte)(n >> 8);
        byArray2[10] = (byte)(n >> 16);
        byArray2[11] = (byte)(n >> 24);
        byArray2[12] = (byte)n2;
        System.arraycopy(sHAiButton.address, 0, byArray2, 13, 7);
        System.arraycopy(this.signing_challenge, 0, byArray2, 20, 3);
        if (!this.ibc.writeDataPage(this.signing_page_number, byArray)) {
            this.last_error = 7;
            this.ibc.useResume(false);
            return false;
        }
        this.ibc.useResume(true);
        if (!this.ibc.writeScratchPad(0, 0, byArray2, 0, 32)) {
            this.last_error = 2;
            this.ibc.useResume(false);
            return false;
        }
        int n3 = this.signing_page_number << 5;
        if (!this.ibc.SHAFunction((byte)60, n3)) {
            this.last_error = 8;
            this.ibc.useResume(false);
            return false;
        }
        if (this.ibc.matchScratchPad(this.verify_macpage)) {
            this.ibc.useResume(false);
            return true;
        }
        this.last_error = 13;
        this.ibc.useResume(false);
        return false;
    }

    public synchronized int readFile(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        this.last_error = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n3 != 0 && n2 < byArray.length) {
            this.ibc.readMemoryPage(n, this.pg0, 0);
            byte by = this.pg0[0];
            if ((0xFF & by) > 32) {
                return 0;
            }
            n4 = n2 + by - 1 > byArray.length ? byArray.length - n2 : by - 1;
            System.arraycopy(this.pg0, 1, byArray, n2, n4);
            n2 += n4;
            n3 = this.pg0[by];
            if (CRC16.compute(this.pg0, 0, by + 3, n) != 45057) {
                this.last_error = 9;
                return 0;
            }
            n = n3;
        }
        return n2;
    }

    public int getLastError() {
        return this.last_error;
    }
}

