/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

public class ResponseAPDU {
    protected byte[] apduBuffer = null;
    protected int apduLength;

    public ResponseAPDU(byte[] byArray) {
        if (byArray.length < 2) {
            throw new RuntimeException("invalid ResponseAPDU, length must be at least 2 bytes");
        }
        this.apduLength = byArray.length;
        this.apduBuffer = new byte[this.apduLength];
        System.arraycopy(byArray, 0, this.apduBuffer, 0, this.apduLength);
    }

    public byte[] getData() {
        if (this.apduLength > 2) {
            byte[] byArray = new byte[this.apduLength - 2];
            System.arraycopy(this.apduBuffer, 0, byArray, 0, this.apduLength - 2);
            return byArray;
        }
        return null;
    }

    public final int getSW() {
        return this.getSW1() << 8 & 0xFF00 | this.getSW2() & 0xFF;
    }

    public final byte getSW1() {
        return this.apduBuffer[this.apduLength - 2];
    }

    public final byte getSW2() {
        return this.apduBuffer[this.apduLength - 1];
    }

    public final byte getByte(int n) {
        if (n >= this.apduLength) {
            return -1;
        }
        return this.apduBuffer[n];
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[this.apduLength];
        System.arraycopy(this.apduBuffer, 0, byArray, 0, this.apduLength);
        return byArray;
    }

    public final int getLength() {
        return this.apduLength;
    }

    public String toString() {
        String string = "";
        if (this.apduLength > 2) {
            byte[] byArray = new byte[this.apduLength - 2];
            byArray = this.getData();
            string = string + "DATA = ";
            int n = 0;
            while (n < byArray.length) {
                if ((byArray[n] & 0xFF) < 16) {
                    string = string + '0';
                }
                string = string + Integer.toHexString(byArray[n] & 0xFF) + " ";
                ++n;
            }
            string = string + " | ";
        }
        string = string + "SW1 = ";
        if ((this.getSW1() & 0xFF) < 16) {
            string = string + '0';
        }
        string = string + Integer.toHexString(this.getSW1() & 0xFF);
        string = string + ", SW2 = ";
        if ((this.getSW2() & 0xFF) < 16) {
            string = string + '0';
        }
        string = string + Integer.toHexString(this.getSW2() & 0xFF);
        return string.toUpperCase();
    }
}

