/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankSHAEE;
import com.dalsemi.onewire.container.OneWireContainer;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer33
extends OneWireContainer {
    private byte[] secret = new byte[8];
    private byte[] challenge = new byte[8];
    private MemoryBankSHAEE page1;
    private MemoryBankSHAEE page2;
    private MemoryBankSHAEE page3and4;
    private MemoryBankSHAEE memstatus;
    protected boolean secretNOTset;
    protected boolean secretProtected;
    protected boolean setAdapter;
    protected boolean container_check;
    protected static byte[] ffBlock = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public OneWireContainer33() {
        System.arraycopy(ffBlock, 0, this.secret, 0, 8);
        System.arraycopy(ffBlock, 0, this.challenge, 0, 8);
        this.setAdapter = false;
        this.container_check = false;
    }

    public OneWireContainer33(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
        System.arraycopy(ffBlock, 0, this.secret, 0, 8);
        System.arraycopy(ffBlock, 0, this.challenge, 0, 8);
        this.setAdapter = true;
        this.container_check = false;
        this.initmem();
    }

    public OneWireContainer33(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
        System.arraycopy(ffBlock, 0, this.secret, 0, 8);
        System.arraycopy(ffBlock, 0, this.challenge, 0, 8);
        this.setAdapter = true;
        this.container_check = false;
        this.initmem();
    }

    public OneWireContainer33(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
        System.arraycopy(ffBlock, 0, this.secret, 0, 8);
        System.arraycopy(ffBlock, 0, this.challenge, 0, 8);
        this.setAdapter = true;
        this.container_check = false;
        this.initmem();
    }

    protected boolean adapterSet() {
        return this.setAdapter;
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super.setupContainer(dSPortAdapter, byArray);
        if (!this.setAdapter) {
            this.initmem();
        }
        this.setAdapter = true;
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, long l) {
        super.setupContainer(dSPortAdapter, l);
        if (!this.setAdapter) {
            this.initmem();
        }
        this.setAdapter = true;
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, String string) {
        super.setupContainer(dSPortAdapter, string);
        if (!this.setAdapter) {
            this.initmem();
        }
        this.setAdapter = true;
    }

    public String getName() {
        return "DS1961S";
    }

    public String getAlternateNames() {
        return "DS2432";
    }

    public String getDescription() {
        return "1K-Bit protected 1-Wire EEPROM with SHA-1 Engine.";
    }

    public int getMaxSpeed() {
        return 2;
    }

    public Enumeration getMemoryBanks() {
        Vector<MemoryBankSHAEE> vector = new Vector<MemoryBankSHAEE>(4);
        vector.addElement(this.page1);
        vector.addElement(this.page2);
        vector.addElement(this.page3and4);
        vector.addElement(this.memstatus);
        return vector.elements();
    }

    public void setContainerSecret(byte[] byArray) {
        System.arraycopy(byArray, 0, this.secret, 0, 8);
        this.secretNOTset = false;
    }

    public void setChallenge(byte[] byArray) {
        System.arraycopy(byArray, 0, this.challenge, 0, 8);
    }

    public void getSecret(byte[] byArray) {
        System.arraycopy(this.secret, 0, byArray, 0, 8);
    }

    public void getChallenge(byte[] byArray) {
        System.arraycopy(this.challenge, 0, byArray, 0, 8);
    }

    public boolean isContainerSecretSet() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        return !this.secretNOTset;
    }

    public boolean isSecretWriteProtected() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        return this.secretProtected;
    }

    public boolean isPageOneEPROMmode() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        return this.page2.writeOnce;
    }

    public boolean isWriteProtectAllSet() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        return this.page3and4.readOnly;
    }

    public boolean isWriteProtectPageZeroSet() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        return this.page1.readOnly;
    }

    public void writeProtectSecret() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        byte[] byArray = new byte[]{-86};
        this.memstatus.write(8, byArray, 0, 1);
        this.secretProtected = true;
    }

    public void writeProtectAll() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        byte[] byArray = new byte[]{-86};
        this.memstatus.write(9, byArray, 0, 1);
        this.page1.writeprotect();
        this.page2.writeprotect();
        this.page3and4.writeprotect();
    }

    public void setEPROMModePageOne() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        byte[] byArray = new byte[]{-86};
        this.memstatus.write(12, byArray, 0, 1);
        this.page2.setEPROM();
    }

    public void writeProtectPageZero() throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        byte[] byArray = new byte[]{-86};
        this.memstatus.write(13, byArray, 0, 1);
        this.page1.writeprotect();
    }

    public void computeNextSecret(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        if (n >= 0 && n < 32) {
            this.page1.nextSecret(n, byArray3, byArray2);
        } else if (n >= 32 && n < 64) {
            this.page2.nextSecret(n - 32, byArray3, byArray2);
        } else if (n >= 64 && n < 128) {
            this.page3and4.nextSecret(n - 64, byArray3, byArray2);
        } else {
            this.page1.nextSecret(n, byArray3, byArray2);
        }
        System.arraycopy(this.secret, 0, byArray, 0, 8);
    }

    public boolean loadFirstSecret(byte[] byArray) throws OneWireIOException, OneWireException {
        if (!this.container_check) {
            this.container_check = this.checkStatus();
        }
        return this.memstatus.LoadFirSecret(0, byArray);
    }

    protected boolean checkStatus() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[8];
        if (!this.container_check) {
            this.memstatus.read(8, false, byArray, 0, 8);
            this.secretProtected = byArray[0] == -86 || byArray[0] == 85;
            if (byArray[1] == -86 || byArray[1] == 85 || byArray[5] == -86 || byArray[5] == 85) {
                this.page1.readWrite = false;
                this.page1.readOnly = true;
            } else {
                this.page1.readWrite = true;
                this.page1.readOnly = false;
            }
            this.page2.writeOnce = byArray[4] == -86 || byArray[4] == 85;
            if (byArray[5] == -86 || byArray[5] == 85) {
                this.page2.readWrite = false;
                this.page2.readOnly = true;
            } else {
                this.page2.readWrite = true;
                this.page2.readOnly = false;
            }
            if (byArray[5] == -86 || byArray[5] == 85) {
                this.page3and4.readWrite = false;
                this.page3and4.readOnly = true;
            } else {
                this.page3and4.readWrite = true;
                this.page3and4.readOnly = false;
            }
            this.memstatus.checked = true;
            this.page1.checked = true;
            this.page2.checked = true;
            this.page3and4.checked = true;
            this.container_check = true;
        }
        return this.container_check;
    }

    private void initmem() {
        this.secretNOTset = true;
        this.memstatus = new MemoryBankSHAEE(this);
        this.memstatus.bankDescription = "Status Page that contains the secret and the status.";
        this.memstatus.generalPurposeMemory = true;
        this.memstatus.startPhysicalAddress = 128;
        this.memstatus.size = 32;
        this.memstatus.numberPages = 1;
        this.memstatus.pageLength = 32;
        this.memstatus.maxPacketDataLength = 29;
        this.memstatus.extraInfo = false;
        this.memstatus.extraInfoLength = 20;
        this.memstatus.readWrite = false;
        this.memstatus.writeOnce = false;
        this.memstatus.pageCRC = false;
        this.memstatus.readOnly = false;
        this.memstatus.checked = false;
        this.page1 = new MemoryBankSHAEE(this);
        this.page1.bankDescription = "Page Zero with write protection.";
        this.page1.generalPurposeMemory = true;
        this.page1.startPhysicalAddress = 0;
        this.page1.size = 32;
        this.page1.numberPages = 1;
        this.page1.pageLength = 32;
        this.page1.maxPacketDataLength = 29;
        this.page1.extraInfo = true;
        this.page1.extraInfoLength = 20;
        this.page1.writeOnce = false;
        this.page1.pageCRC = true;
        this.page1.checked = false;
        this.page2 = new MemoryBankSHAEE(this);
        this.page2.bankDescription = "Page One with EPROM mode and write protection.";
        this.page2.generalPurposeMemory = true;
        this.page2.startPhysicalAddress = 32;
        this.page2.size = 32;
        this.page2.numberPages = 1;
        this.page2.pageLength = 32;
        this.page2.maxPacketDataLength = 29;
        this.page2.extraInfo = true;
        this.page2.extraInfoLength = 20;
        this.page2.pageCRC = true;
        this.page2.checked = false;
        this.page3and4 = new MemoryBankSHAEE(this);
        this.page3and4.bankDescription = "Page Two and Three with write protection.";
        this.page3and4.generalPurposeMemory = true;
        this.page3and4.startPhysicalAddress = 64;
        this.page3and4.size = 64;
        this.page3and4.numberPages = 2;
        this.page3and4.pageLength = 32;
        this.page3and4.maxPacketDataLength = 29;
        this.page3and4.extraInfo = true;
        this.page3and4.extraInfoLength = 20;
        this.page3and4.writeOnce = false;
        this.page3and4.pageCRC = true;
        this.page3and4.checked = false;
    }

    public static boolean isMACValid(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) throws OneWireException, OneWireIOException {
        byte[] byArray6 = new byte[64];
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        System.arraycopy(byArray5, 0, byArray6, 0, 4);
        System.arraycopy(byArray2, 0, byArray6, 4, 32);
        System.arraycopy(ffBlock, 0, byArray6, 36, 4);
        byArray6[40] = (byte)(0x40 | n << 3 & 8 | n >>> 5 & 7);
        System.arraycopy(byArray, 0, byArray6, 41, 7);
        System.arraycopy(byArray5, 4, byArray6, 48, 4);
        System.arraycopy(byArray4, 4, byArray6, 52, 3);
        byArray6[55] = -128;
        int n7 = 56;
        while (n7 < 62) {
            byArray6[n7] = 0;
            ++n7;
        }
        byArray6[62] = 1;
        byArray6[63] = -72;
        int[] nArray = new int[5];
        OneWireContainer33.ComputeSHA(byArray6, nArray);
        n2 = nArray[0];
        n3 = nArray[1];
        n4 = nArray[2];
        n5 = nArray[3];
        n6 = nArray[4];
        int n8 = 0;
        int n9 = n6;
        n7 = 0;
        while (n7 < 4) {
            if (byArray3[n8++] != (byte)(n9 & 0xFF)) {
                return false;
            }
            n9 >>>= 8;
            ++n7;
        }
        n9 = n5;
        n7 = 0;
        while (n7 < 4) {
            if (byArray3[n8++] != (byte)(n9 & 0xFF)) {
                return false;
            }
            n9 >>>= 8;
            ++n7;
        }
        n9 = n4;
        n7 = 0;
        while (n7 < 4) {
            if (byArray3[n8++] != (byte)(n9 & 0xFF)) {
                return false;
            }
            n9 >>>= 8;
            ++n7;
        }
        n9 = n3;
        n7 = 0;
        while (n7 < 4) {
            if (byArray3[n8++] != (byte)(n9 & 0xFF)) {
                return false;
            }
            n9 >>>= 8;
            ++n7;
        }
        n9 = n2;
        n7 = 0;
        while (n7 < 4) {
            if (byArray3[n8++] != (byte)(n9 & 0xFF)) {
                return false;
            }
            n9 >>>= 8;
            ++n7;
        }
        return true;
    }

    protected static void ComputeSHA(byte[] byArray, int[] nArray) {
        int n;
        int[] nArray2 = new int[80];
        int n2 = 0;
        while (n2 < 16) {
            nArray2[n2] = (byArray[n2 * 4] & 0xFF) << 24 | (byArray[n2 * 4 + 1] & 0xFF) << 16 | (byArray[n2 * 4 + 2] & 0xFF) << 8 | byArray[n2 * 4 + 3] & 0xFF;
            ++n2;
        }
        n2 = 16;
        while (n2 < 80) {
            n = nArray2[n2 - 3] ^ nArray2[n2 - 8] ^ nArray2[n2 - 14] ^ nArray2[n2 - 16];
            nArray2[n2] = n << 1 & 0xFFFFFFFE | n >>> 31 & 1;
            ++n2;
        }
        nArray[0] = 1732584193;
        nArray[1] = -271733879;
        nArray[2] = -1732584194;
        nArray[3] = 271733878;
        nArray[4] = -1009589776;
        n2 = 0;
        while (n2 < 80) {
            n = nArray[0] << 5 & 0xFFFFFFE0 | nArray[0] >>> 27 & 0x1F;
            int n3 = OneWireContainer33.NLF(nArray[1], nArray[2], nArray[3], n2) + nArray[4] + OneWireContainer33.KTN(n2) + nArray2[n2] + n;
            nArray[4] = nArray[3];
            nArray[3] = nArray[2];
            nArray[2] = nArray[1] << 30 & 0xC0000000 | nArray[1] >>> 2 & 0x3FFFFFFF;
            nArray[1] = nArray[0];
            nArray[0] = n3;
            ++n2;
        }
    }

    protected static int KTN(int n) {
        if (n < 20) {
            return 1518500249;
        }
        if (n < 40) {
            return 1859775393;
        }
        if (n < 60) {
            return -1894007588;
        }
        return -899497514;
    }

    protected static int NLF(int n, int n2, int n3, int n4) {
        if (n4 < 20) {
            return n & n2 | ~n & n3;
        }
        if (n4 < 40) {
            return n ^ n2 ^ n3;
        }
        if (n4 < 60) {
            return n & n2 | n & n3 | n2 & n3;
        }
        return n ^ n2 ^ n3;
    }
}

