/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.ADContainer;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.TemperatureContainer;

public class OneWireContainer30
extends OneWireContainer
implements ADContainer,
TemperatureContainer {
    private static final byte WRITE_DATA_COMMAND = 108;
    private static final byte READ_DATA_COMMAND = 105;
    private static final byte COPY_DATA_COMMAND = 72;
    private static final byte RECALL_DATA_COMMAND = -72;
    private static final byte LOCK_COMMAND = 106;
    public static final byte PROTECTION_REGISTER = 0;
    public static final byte STATUS_REGISTER = 1;
    public static final byte EEPROM_REGISTER = 7;
    public static final byte SPECIAL_FEATURE_REGISTER = 8;
    public static final byte OVERVOLTAGE_FLAG = -128;
    public static final byte UNDERVOLTAGE_FLAG = 64;
    public static final byte CHARGE_OVERCURRENT_FLAG = 32;
    public static final byte DISCHARGE_OVERCURRENT_FLAG = 16;
    public static final byte CC_PIN_STATE_FLAG = 8;
    public static final byte DC_PIN_STATE_FLAG = 4;
    public static final byte CHARGE_ENABLE_FLAG = 2;
    public static final byte DISCHARGE_ENABLE_FLAG = 1;
    public static final byte SLEEP_MODE_ENABLE_FLAG = 32;
    public static final byte READ_NET_ADDRESS_OPCODE_FLAG = 16;
    public static final byte EEPROM_COPY_FLAG = -128;
    public static final byte EEPROM_LOCK_ENABLE_FLAG = 64;
    public static final byte EEPROM_BLOCK_1_LOCK_FLAG = 2;
    public static final byte EEPROM_BLOCK_0_LOCK_FLAG = 1;
    public static final byte PS_PIN_STATE_FLAG = -128;
    public static final byte PIO_PIN_SENSE_AND_CONTROL_FLAG = 64;
    private double Rsens = 0.05;
    private boolean internalResistor = true;

    public OneWireContainer30() {
    }

    public OneWireContainer30(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer30(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer30(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2760";
    }

    public String getAlternateNames() {
        return "1-Cell Li-Ion Battery Monitor";
    }

    public String getDescription() {
        return "The DS2760 is a data acquisition, information storage, and safety protection device tailored for cost-sensitive battery pack applications. This low-power device integrates precise temperature, voltage, and current measurement , nonvolatile data storage, and Li-Ion protection into the small footprint of either a TSSOP packet or flip-chip.";
    }

    public synchronized void setResistorInternal() {
        this.internalResistor = true;
    }

    public synchronized void setResistorExternal(double d) {
        this.internalResistor = false;
        this.Rsens = d;
    }

    public byte readByte(int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[3];
        this.doSpeed();
        this.adapter.reset();
        if (this.adapter.select(this.address)) {
            byArray[0] = 105;
            byArray[1] = (byte)n;
            byArray[2] = -1;
            this.adapter.dataBlock(byArray, 0, 3);
            return byArray[2];
        }
        throw new OneWireException("OneWireContainer30-Device not found.");
    }

    public void readBytes(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        this.doSpeed();
        this.adapter.reset();
        if (this.adapter.select(this.address)) {
            int n4 = n2;
            while (n4 < n2 + n3) {
                byArray[n4] = -1;
                ++n4;
            }
        } else {
            throw new OneWireException("OneWireContainer30-Device not found.");
        }
        this.adapter.putByte(105);
        this.adapter.putByte(n & 0xFF);
        this.adapter.dataBlock(byArray, n2, n3);
    }

    public void writeByte(int n, byte by) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[3];
        this.doSpeed();
        this.adapter.reset();
        if (!this.adapter.select(this.address)) {
            throw new OneWireException("OneWireContainer30-Device not found.");
        }
        byArray[0] = 108;
        byArray[1] = (byte)n;
        byArray[2] = by;
        this.adapter.dataBlock(byArray, 0, 3);
    }

    public byte[] readEEPROMBlock(int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[18];
        byte[] byArray2 = new byte[16];
        byte by = (byte)(32 + n * 16);
        if (n != 0 & n != 1) {
            throw new IllegalArgumentException("OneWireContainer30-Block number " + n + " is not a valid EEPROM block.");
        }
        this.doSpeed();
        this.adapter.reset();
        if (this.adapter.select(this.address)) {
            byArray[0] = -72;
            byArray[1] = by;
            this.adapter.dataBlock(byArray, 0, 2);
            this.adapter.reset();
            this.adapter.select(this.address);
            byArray[0] = 105;
            int n2 = 0;
            while (n2 < 16) {
                byArray[n2 + 2] = -1;
                ++n2;
            }
            this.adapter.dataBlock(byArray, 0, 18);
            System.arraycopy(byArray, 2, byArray2, 0, 16);
            return byArray2;
        }
        throw new OneWireException("OneWireContainer30-Device not found.");
    }

    public void writeEEPROMBlock(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[18];
        byte by = (byte)(32 + n * 16);
        if (byArray.length < 16) {
            throw new IllegalArgumentException("OneWireContainer30-Data block must consist of 16 bytes.");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("OneWireContainer30-Block number " + n + " is not a valid EEPROM block.");
        }
        if (n == 0 && this.getFlag(7, (byte)1) || n == 1 && this.getFlag(7, (byte)2)) {
            throw new OneWireIOException("OneWireContainer30-Cant write data to locked EEPROM block.");
        }
        this.doSpeed();
        this.adapter.reset();
        if (this.adapter.select(this.address)) {
            byArray2[0] = 108;
            byArray2[1] = by;
            int n2 = 0;
            while (n2 < 16) {
                byArray2[n2 + 2] = byArray[n2];
                ++n2;
            }
            this.adapter.dataBlock(byArray2, 0, 18);
            this.adapter.reset();
            this.adapter.select(this.address);
            byArray2[0] = 105;
            int n3 = 0;
            while (n3 < 16) {
                byArray2[n3 + 2] = -1;
                ++n3;
            }
            this.adapter.dataBlock(byArray2, 0, 18);
            int n4 = 0;
            while (n4 < 16) {
                if (byArray2[n4 + 2] != byArray[n4]) {
                    throw new OneWireIOException("OneWireContainer30-Error writing EEPROM block" + n + ".");
                }
                ++n4;
            }
        } else {
            throw new OneWireException("OneWireContainer30-Device not found.");
        }
        this.adapter.reset();
        this.adapter.select(this.address);
        byArray2[0] = 72;
        this.adapter.dataBlock(byArray2, 0, 2);
    }

    public void lockBlock(int n) throws OneWireIOException, OneWireException {
        byte by = (byte)(32 + n * 16);
        if (n != 0 & n != 1) {
            throw new IllegalArgumentException("OneWireContainer30-Block " + n + " is not a valid EEPROM block.");
        }
        this.doSpeed();
        this.adapter.reset();
        if (!this.adapter.select(this.address)) {
            throw new OneWireException("OneWireContainer30-Device not found.");
        }
        this.adapter.putByte(106);
        this.adapter.putByte(by);
    }

    public boolean getFlag(int n, byte by) throws OneWireIOException, OneWireException {
        byte by2 = this.readByte(n);
        return (by2 & by) != 0;
    }

    public void setFlag(int n, byte by, boolean bl) throws OneWireIOException, OneWireException {
        if (n == 1) {
            n = 49;
        }
        byte by2 = this.readByte(n);
        by2 = bl ? (byte)(by2 | by) : (byte)(by2 & ~by);
        this.writeByte(n, by2);
    }

    public double getCurrent(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = byArray[14] << 8 | byArray[15] & 0xFF;
        double d = this.internalResistor ? (double)n * 0.625 / 1000.0 : (double)(n >>= 3) * 1.5625E-5 / this.Rsens;
        return d;
    }

    public void setRemainingCapacity(double d) throws OneWireIOException, OneWireException {
        int n = this.internalResistor ? (int)(d * 4.0) : (int)(d * this.Rsens / 0.00626);
        this.writeByte(16, (byte)(n >> 8));
        this.writeByte(17, (byte)(n & 0xFF));
    }

    public double getRemainingCapacity(byte[] byArray) throws OneWireIOException, OneWireException {
        double d = 0.0;
        int n = (byArray[16] & 0xFF) << 8 | byArray[17] & 0xFF;
        d = this.internalResistor ? (double)n / 4.0 : (double)n * 0.00626 / this.Rsens;
        return d;
    }

    public void setLatchState(boolean bl) throws OneWireIOException, OneWireException {
        this.writeByte(8, bl ? (byte)64 : 0);
    }

    public boolean getLatchState() throws OneWireIOException, OneWireException {
        return (this.readByte(8) & 0x40) == 64;
    }

    public void clearConditions() throws OneWireIOException, OneWireException {
        byte by = this.readByte(0);
        this.writeByte(0, (byte)(by & 0xF));
    }

    public int getNumberADChannels() {
        return 1;
    }

    public boolean hasADAlarms() {
        return false;
    }

    public double[] getADRanges(int n) {
        double[] dArray = new double[]{5.0};
        return dArray;
    }

    public double[] getADResolutions(int n, double d) {
        double[] dArray = new double[]{0.00488};
        return dArray;
    }

    public boolean canADMultiChannelRead() {
        return false;
    }

    public void doADConvert(int n, byte[] byArray) throws OneWireIOException, OneWireException {
    }

    public void doADConvert(boolean[] blArray, byte[] byArray) throws OneWireIOException, OneWireException {
        throw new OneWireException("This device does not support multi-channel reading");
    }

    public double[] getADVoltage(byte[] byArray) throws OneWireIOException, OneWireException {
        throw new OneWireException("This device does not support multi-channel reading");
    }

    public double getADVoltage(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        double d = 0.0;
        int n2 = byArray[12] << 8 | byArray[13] & 0xFF;
        d = (double)(n2 >>= 5) * 4.88 / 1000.0;
        return d;
    }

    public double getADAlarm(int n, int n2, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have AD alarms");
    }

    public boolean getADAlarmEnable(int n, int n2, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have AD alarms");
    }

    public boolean hasADAlarmed(int n, int n2, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have AD alarms");
    }

    public double getADResolution(int n, byte[] byArray) {
        return 0.00488;
    }

    public double getADRange(int n, byte[] byArray) {
        return 5.0;
    }

    public void setADAlarm(int n, int n2, double d, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have AD alarms");
    }

    public void setADAlarmEnable(int n, int n2, boolean bl, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have AD alarms");
    }

    public void setADResolution(int n, double d, byte[] byArray) {
    }

    public void setADRange(int n, double d, byte[] byArray) {
    }

    public boolean hasTemperatureAlarms() {
        return false;
    }

    public boolean hasSelectableTemperatureResolution() {
        return false;
    }

    public double[] getTemperatureResolutions() {
        double[] dArray = new double[]{0.125};
        return dArray;
    }

    public double getTemperatureAlarmResolution() throws OneWireException {
        throw new OneWireException("This device does not have temperature alarms");
    }

    public double getMaxTemperature() {
        return 85.0;
    }

    public double getMinTemperature() {
        return -40.0;
    }

    public void doTemperatureConvert(byte[] byArray) throws OneWireIOException, OneWireException {
    }

    public double getTemperature(byte[] byArray) {
        int n = byArray[24] << 8 | byArray[25] & 0xFF;
        double d = (double)(n >>= 5) / 8.0;
        return d;
    }

    public double getTemperatureAlarm(int n, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have temperature alarms");
    }

    public double getTemperatureResolution(byte[] byArray) {
        return 0.125;
    }

    public void setTemperatureAlarm(int n, double d, byte[] byArray) throws OneWireException, OneWireIOException {
        throw new OneWireException("This device does not have temperature alarms");
    }

    public void setTemperatureResolution(double d, byte[] byArray) throws OneWireException, OneWireIOException {
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        this.doSpeed();
        this.adapter.reset();
        if (!this.adapter.select(this.address)) {
            throw new OneWireException("OneWireContainer30-Device not found.");
        }
        this.adapter.putByte(105);
        this.adapter.putByte(0);
        this.adapter.getBlock(byArray2, 0, 32);
        return byArray2;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
    }
}

