/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PotentiometerContainer;

public class OneWireContainer2C
extends OneWireContainer
implements PotentiometerContainer {
    private byte[] buffer = new byte[4];
    private static final byte WRITE_CONTROL = 85;
    private static final byte READ_CONTROL = -86;
    private static final byte WRITE_POSITION = 15;
    private static final byte READ_POSITION = -16;
    private static final byte INCREMENT = -61;
    private static final byte DECREMENT = -103;

    public OneWireContainer2C() {
    }

    public OneWireContainer2C(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer2C(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer2C(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2890";
    }

    public String getAlternateNames() {
        return "Digital Potentiometer";
    }

    public String getDescription() {
        return "1-Wire linear taper digitally controlled potentiometer with 256 wiper positions.  0-11 Volt working range.";
    }

    public int getMaxSpeed() {
        return 2;
    }

    public boolean isLinear(byte[] byArray) {
        return (byArray[0] & 1) == 1;
    }

    public boolean wiperSettingsAreVolatile(byte[] byArray) {
        return (byArray[0] & 2) == 2;
    }

    public int numberOfPotentiometers(byte[] byArray) {
        return (byArray[0] >> 2 & 3) + 1;
    }

    public int numberOfWiperSettings(byte[] byArray) {
        switch (byArray[0] & 0x30) {
            case 0: {
                return 32;
            }
            case 16: {
                return 64;
            }
            case 32: {
                return 128;
            }
        }
        return 256;
    }

    public int potentiometerResistance(byte[] byArray) {
        switch (byArray[0] & 0xC0) {
            case 0: {
                return 5;
            }
            case 64: {
                return 10;
            }
            case 128: {
                return 50;
            }
        }
        return 100;
    }

    public int getCurrentWiperNumber(byte[] byArray) {
        int n = byArray[1] & 3;
        int n2 = byArray[1] >> 2 & 3;
        if (n + n2 == 3) {
            return n;
        }
        return -1;
    }

    public void setCurrentWiperNumber(int n, byte[] byArray) {
        if (n != (n & 3)) {
            return;
        }
        int n2 = ~n;
        byArray[1] = (byte)(byArray[1] & 0xF0 | (n |= (n2 & 3) << 2) & 0xF);
    }

    public boolean isChargePumpOn(byte[] byArray) {
        return (byArray[1] & 0x40) == 64;
    }

    public void setChargePump(boolean bl, byte[] byArray) {
        byArray[1] = (byte)(byArray[1] & 0xBF);
        if (bl) {
            byArray[1] = (byte)(byArray[1] | 0x40);
        }
    }

    public int getWiperPosition() throws OneWireIOException, OneWireException {
        return this.readRegisters((byte)-16) & 0xFF;
    }

    public boolean setWiperPosition(int n) throws OneWireIOException, OneWireException {
        return this.writeTransaction((byte)15, (byte)n);
    }

    public int increment(boolean bl) throws OneWireIOException, OneWireException {
        return this.unitChange((byte)-61, bl);
    }

    public int decrement(boolean bl) throws OneWireIOException, OneWireException {
        return this.unitChange((byte)-103, bl);
    }

    public int increment() throws OneWireIOException, OneWireException {
        return this.unitChange((byte)-61, true);
    }

    public int decrement() throws OneWireIOException, OneWireException {
        return this.unitChange((byte)-103, true);
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[2];
        this.doSpeed();
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("Could not select the part!");
        }
        byte[] byArray2 = new byte[3];
        byArray2[0] = -86;
        byArray2[2] = -1;
        byArray2[1] = -1;
        this.adapter.dataBlock(byArray2, 0, 3);
        byArray[0] = byArray2[1];
        byArray[1] = byArray2[2];
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        if (!this.writeTransaction((byte)85, byArray[1])) {
            throw new OneWireIOException("Device may not have been present!");
        }
    }

    private synchronized int readRegisters(byte by) throws OneWireIOException, OneWireException {
        this.doSpeed();
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("Could not select the part!");
        }
        this.buffer[0] = by;
        this.buffer[2] = -1;
        this.buffer[1] = -1;
        this.adapter.dataBlock(this.buffer, 0, 3);
        return 0xFF & this.buffer[2];
    }

    private synchronized boolean writeTransaction(byte by, byte by2) throws OneWireIOException, OneWireException {
        this.doSpeed();
        if (this.adapter.select(this.address)) {
            this.buffer[0] = by;
            this.buffer[1] = by2;
            this.buffer[2] = -1;
            this.adapter.dataBlock(this.buffer, 0, 3);
            if (this.buffer[2] == by2) {
                this.buffer[0] = -106;
                this.buffer[1] = -1;
                this.adapter.dataBlock(this.buffer, 0, 2);
                if (this.buffer[1] == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private synchronized int unitChange(byte by, boolean bl) throws OneWireIOException, OneWireException {
        if (bl) {
            this.doSpeed();
            this.adapter.select(this.address);
        }
        this.buffer[0] = by;
        this.buffer[1] = -1;
        this.adapter.dataBlock(this.buffer, 0, 2);
        return 0xFF & this.buffer[1];
    }
}

