/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.TemperatureContainer;
import com.dalsemi.onewire.utils.CRC8;

public class OneWireContainer28
extends OneWireContainer
implements TemperatureContainer {
    public static final byte WRITE_SCRATCHPAD_COMMAND = 78;
    public static final byte READ_SCRATCHPAD_COMMAND = -66;
    public static final byte COPY_SCRATCHPAD_COMMAND = 72;
    public static final byte CONVERT_TEMPERATURE_COMMAND = 68;
    public static final byte RECALL_E2MEMORY_COMMAND = -72;
    public static final byte READ_POWER_SUPPLY_COMMAND = -76;
    public static final byte RESOLUTION_12_BIT = 127;
    public static final byte RESOLUTION_11_BIT = 95;
    public static final byte RESOLUTION_10_BIT = 63;
    public static final byte RESOLUTION_9_BIT = 31;

    public OneWireContainer28() {
    }

    public OneWireContainer28(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer28(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer28(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS18B20";
    }

    public String getAlternateNames() {
        return "DS1820B, DS18B20X";
    }

    public String getDescription() {
        return "Digital thermometer measures temperatures from -55C to 125C in 0.75 seconds (max).  +/- 0.5C accuracy between -10C and 85C. Thermometer resolution is programmable at 9, 10, 11, and 12 bits. ";
    }

    public boolean hasTemperatureAlarms() {
        return true;
    }

    public boolean hasSelectableTemperatureResolution() {
        return true;
    }

    public double[] getTemperatureResolutions() {
        double[] dArray = new double[]{0.5, 0.25, 0.125, 0.0625};
        return dArray;
    }

    public double getTemperatureAlarmResolution() {
        return 1.0;
    }

    public double getMaxTemperature() {
        return 125.0;
    }

    public double getMinTemperature() {
        return -55.0;
    }

    public void doTemperatureConvert(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = 750;
        if (this.adapter.select(this.address)) {
            this.adapter.setPowerDuration(5);
            this.adapter.startPowerDelivery(2);
            this.adapter.putByte(68);
            switch (byArray[4]) {
                case 31: {
                    n = 94;
                    break;
                }
                case 63: {
                    n = 188;
                    break;
                }
                case 95: {
                    n = 375;
                    break;
                }
                case 127: {
                    n = 750;
                    break;
                }
                default: {
                    n = 750;
                }
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.adapter.setPowerNormal();
            if (this.adapter.getByte() != 255) {
                throw new OneWireIOException("OneWireContainer28-temperature conversion not complete");
            }
        } else {
            throw new OneWireIOException("OneWireContainer28-device not present");
        }
    }

    public double getTemperature(byte[] byArray) throws OneWireIOException {
        double d = 0.0;
        int n = byArray[1];
        n = n << 8 | byArray[0] & 0xFF;
        d = (double)n / 16.0;
        return d;
    }

    public double getTemperatureAlarm(int n, byte[] byArray) {
        return byArray[n == 0 ? 3 : 2];
    }

    public double getTemperatureResolution(byte[] byArray) {
        double d = 0.0;
        switch (byArray[4]) {
            case 31: {
                d = 0.5;
                break;
            }
            case 63: {
                d = 0.25;
                break;
            }
            case 95: {
                d = 0.125;
                break;
            }
            case 127: {
                d = 0.0625;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public void setTemperatureAlarm(int n, double d, byte[] byArray) throws OneWireException, OneWireIOException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid alarm type.");
        }
        if (d > 125.0 || d < -55.0) {
            throw new IllegalArgumentException("Value for alarm not in accepted range.  Must be -55 C <-> +125 C.");
        }
        byArray[n == 0 ? 3 : 2] = (byte)d;
    }

    public void setTemperatureResolution(double d, byte[] byArray) throws OneWireException {
        int n = 127;
        OneWireContainer28 oneWireContainer28 = this;
        synchronized (oneWireContainer28) {
            if (d == 0.5) {
                n = 31;
            }
            if (d == 0.25) {
                n = 63;
            }
            if (d == 0.125) {
                n = 95;
            }
            if (d == 0.0625) {
                n = 127;
            }
            byArray[4] = n;
        }
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = this.recallE2();
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[]{byArray[2], byArray[3], byArray[4]};
        this.writeScratchpad(byArray2);
        this.copyScratchpad();
    }

    public byte[] readScratchpad() throws OneWireIOException, OneWireException {
        if (this.adapter.select(this.address)) {
            byte[] byArray = new byte[10];
            byArray[0] = -66;
            int n = 1;
            while (n < 10) {
                byArray[n] = -1;
                ++n;
            }
            this.adapter.dataBlock(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[9];
            int n2 = 0;
            while (n2 < 9) {
                byArray2[n2] = byArray[n2 + 1];
                ++n2;
            }
            if (CRC8.compute(byArray, 1, 9) == 0) {
                return byArray2;
            }
            throw new OneWireIOException("OneWireContainer28-Error reading CRC8 from device.");
        }
        throw new OneWireIOException("OneWireContainer28-Device not found on 1-Wire Network");
    }

    public void writeScratchpad(byte[] byArray) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[]{78, byArray[0], byArray[1], byArray[2]};
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("OneWireContainer28-Device not found on 1-Wire Network");
        }
        this.adapter.dataBlock(byArray2, 0, byArray2.length);
        byte[] byArray3 = this.readScratchpad();
        if (byArray3[2] != byArray[0] || byArray3[3] != byArray[1] || byArray3[4] != byArray[2]) {
            throw new OneWireIOException("OneWireContainer28-Error writing to scratchpad");
        }
    }

    public void copyScratchpad() throws OneWireIOException, OneWireException {
        byte[] byArray = this.readScratchpad();
        if (this.adapter.select(this.address)) {
            this.adapter.setPowerDuration(5);
            this.adapter.startPowerDelivery(2);
            this.adapter.putByte(72);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new OneWireIOException("OneWireContainer28-Device not found on 1-Wire Network");
        }
        this.adapter.setPowerNormal();
        byte[] byArray2 = this.recallE2();
        if (byArray[2] != byArray2[2] || byArray[3] != byArray2[3] || byArray[4] != byArray2[4]) {
            throw new OneWireIOException("OneWireContainer28-Error copying scratchpad to E2 memory.");
        }
    }

    public byte[] recallE2() throws OneWireIOException, OneWireException {
        if (this.adapter.select(this.address)) {
            this.adapter.putByte(-72);
            byte[] byArray = this.readScratchpad();
            return byArray;
        }
        throw new OneWireIOException("OneWireContainer28-Device not found on 1-Wire Network");
    }

    public boolean isExternalPowerSupplied() throws OneWireIOException, OneWireException {
        int n = 0;
        boolean bl = false;
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("OneWireContainer28-Device not found on 1-Wire Network");
        }
        this.adapter.putByte(-76);
        n = this.adapter.getByte();
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    public float convertToFahrenheit(float f) {
        float f2 = 0.0f;
        f2 = (float)((double)f * 9.0 / 5.0 + 32.0);
        return f2;
    }
}

