/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.ADContainer;
import com.dalsemi.onewire.container.ClockContainer;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.TemperatureContainer;
import com.dalsemi.onewire.utils.CRC8;

public class OneWireContainer26
extends OneWireContainer
implements ADContainer,
TemperatureContainer,
ClockContainer {
    private static final byte READ_SCRATCHPAD_COMMAND = -66;
    private static final byte RECALL_MEMORY_COMMAND = -72;
    private static final byte COPY_SCRATCHPAD_COMMAND = 72;
    private static final byte WRITE_SCRATCHPAD_COMMAND = 78;
    private static final byte CONVERT_TEMP_COMMAND = 68;
    private static final byte CONVERT_VOLTAGE_COMMAND = -76;
    public static final int CHANNEL_VDD = 0;
    public static final int CHANNEL_VAD = 1;
    public static final byte IAD_FLAG = 1;
    public static final byte CA_FLAG = 2;
    public static final byte EE_FLAG = 4;
    public static final byte AD_FLAG = 8;
    public static final byte TB_FLAG = 16;
    public static final byte NVB_FLAG = 32;
    public static final byte ADB_FLAG = 64;
    private double Rsens = 0.05;
    private boolean doSpeedEnable = true;

    public OneWireContainer26() {
    }

    public OneWireContainer26(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer26(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer26(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2438";
    }

    public String getAlternateNames() {
        return "Smart Battery Monitor";
    }

    public String getDescription() {
        return "1-Wire device that integrates the total current charging or discharging through a battery and stores it in a register. It also returns the temperature (accurate to 2 degrees celcius), as well as the instantaneous current and voltage and also provides 40 bytes of EEPROM storage.";
    }

    public synchronized void setSenseResistor(double d) {
        this.Rsens = d;
    }

    public double getSenseResistor() {
        return this.Rsens;
    }

    public synchronized void setSpeedCheck(boolean bl) {
        this.doSpeedEnable = bl;
    }

    public byte[] readPage(int n) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = new byte[11];
        byte[] byArray2 = new byte[8];
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("OneWireContainer26-Page " + n + " is an invalid page.");
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            byArray[0] = -72;
            byArray[1] = (byte)n;
            this.adapter.dataBlock(byArray, 0, 2);
            this.adapter.reset();
            this.adapter.select(this.address);
            byArray[0] = -66;
            byArray[1] = (byte)n;
            int n2 = 2;
            while (n2 < 11) {
                byArray[n2] = -1;
                ++n2;
            }
            this.adapter.dataBlock(byArray, 0, 11);
            int n3 = CRC8.compute(byArray, 2, 9);
            if (n3 != 0) {
                throw new OneWireIOException("OneWireContainer26-Bad CRC during read." + n3);
            }
        } else {
            throw new OneWireException("OneWireContainer26-device not found.");
        }
        System.arraycopy(byArray, 2, byArray2, 0, 8);
        return byArray2;
    }

    public void writePage(int n, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[10];
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("OneWireContainer26-Page " + n + " is an invalid page.");
        }
        if (byArray.length < 8) {
            throw new IllegalArgumentException("OneWireContainer26-Invalid data page passed to writePage.");
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (!this.adapter.select(this.address)) {
            throw new OneWireException("OneWireContainer26-Device not found.");
        }
        byArray2[0] = 78;
        byArray2[1] = (byte)n;
        System.arraycopy(byArray, n2, byArray2, 2, 8);
        this.adapter.dataBlock(byArray2, 0, 10);
        this.adapter.reset();
        this.adapter.select(this.address);
        byArray2[0] = 72;
        byArray2[1] = (byte)n;
        this.adapter.dataBlock(byArray2, 0, 2);
    }

    public boolean getFlag(byte by) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(0);
        return (byArray[0] & by) != 0;
    }

    public void setFlag(byte by, boolean bl) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(0);
        byArray[0] = bl ? (byte)(byArray[0] | by) : (byte)(byArray[0] & ~by);
        this.writePage(0, byArray, 0);
    }

    public double getCurrent(byte[] byArray) {
        short s = (short)(byArray[6] << 8 | byArray[5] & 0xFF);
        return (double)s / (4096.0 * this.Rsens);
    }

    public double getRemainingCapacity() throws OneWireIOException, OneWireException, IllegalArgumentException {
        int n = this.getICA();
        return (double)(1000 * n) / (2048.0 * this.Rsens);
    }

    public boolean isCharging(byte[] byArray) throws OneWireIOException, OneWireException, IllegalArgumentException {
        return this.getCurrent(byArray) > 0.0;
    }

    public void calibrateCurrentADC() throws OneWireIOException, OneWireException, IllegalArgumentException {
        boolean bl = this.getFlag((byte)1);
        this.setFlag((byte)1, false);
        byte[] byArray = this.readPage(1);
        byArray[6] = 0;
        byArray[5] = 0;
        this.writePage(1, byArray, 0);
        this.setFlag((byte)1, true);
        byArray = this.readPage(0);
        byte by = byArray[5];
        byte by2 = byArray[6];
        this.setFlag((byte)1, false);
        byArray = this.readPage(1);
        byArray[5] = (byte)(~by + 1);
        byArray[6] = ~by2;
        this.writePage(1, byArray, 0);
        this.setFlag((byte)1, bl);
    }

    public void setThreshold(byte by) throws OneWireIOException, OneWireException {
        int n;
        switch (by) {
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = 64;
                break;
            }
            case 4: {
                n = -128;
                break;
            }
            case 8: {
                n = -64;
                break;
            }
            default: {
                throw new IllegalArgumentException("OneWireContainer26-Threshold value must be 0,2,4, or 8.");
            }
        }
        boolean bl = this.getFlag((byte)1);
        this.setFlag((byte)1, false);
        byte[] byArray = this.readPage(0);
        byArray[7] = n;
        this.writePage(0, byArray, 0);
        this.setFlag((byte)1, bl);
    }

    public int getICA() throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(1);
        return byArray[4] & 0xFF;
    }

    public int getCCA() throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(7);
        return byArray[5] << 8 & 0xFF00 | byArray[4] & 0xFF;
    }

    public int getDCA() throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(7);
        return byArray[7] << 8 & 0xFF00 | byArray[6] & 0xFF;
    }

    public void setICA(int n) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(1);
        byArray[4] = (byte)(n & 0xFF);
        this.writePage(1, byArray, 0);
    }

    public void setCCA(int n) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(7);
        byArray[4] = (byte)(n & 0xFF);
        byArray[5] = (byte)((n & 0xFF00) >>> 8);
        this.writePage(7, byArray, 0);
    }

    public void setDCA(int n) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray = this.readPage(7);
        byArray[6] = (byte)(n & 0xFF);
        byArray[7] = (byte)((n & 0xFF00) >>> 8);
        this.writePage(7, byArray, 0);
    }

    public long getDisconnectTime(byte[] byArray) {
        return this.getTime(byArray, 16) * 1000L;
    }

    public long getEndOfChargeTime(byte[] byArray) {
        return this.getTime(byArray, 20) * 1000L;
    }

    private long getTime(byte[] byArray, int n) {
        long l = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    public int getNumberADChannels() {
        return 2;
    }

    public boolean hasADAlarms() {
        return false;
    }

    public double[] getADRanges(int n) {
        double[] dArray = new double[]{10.23};
        return dArray;
    }

    public double[] getADResolutions(int n, double d) {
        double[] dArray = new double[]{0.01};
        return dArray;
    }

    public boolean canADMultiChannelRead() {
        return false;
    }

    public void doADConvert(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        this.setFlag((byte)8, n == 0);
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            this.adapter.putByte(-76);
            try {
                Thread.sleep(4L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new OneWireException("OneWireContainer26-Device not found.");
        }
        byte[] byArray2 = this.readPage(0);
        System.arraycopy(byArray2, 0, byArray, 0, 8);
        byArray[24 + n * 2] = byArray2[4];
        byArray[24 + n * 2 + 1] = byArray2[3];
    }

    public void doADConvert(boolean[] blArray, byte[] byArray) throws OneWireIOException, OneWireException {
        throw new OneWireException("This device cannot do multi-channel reads");
    }

    public double[] getADVoltage(byte[] byArray) throws OneWireIOException, OneWireException {
        throw new OneWireException("This device cannot do multi-channel reads");
    }

    public double getADVoltage(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        double d = (double)(byArray[24 + n * 2] << 8 & 0xFF00 | byArray[24 + n * 2 + 1] & 0xFF) / 100.0;
        return d;
    }

    public double getADAlarm(int n, int n2, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have A/D alarms");
    }

    public boolean getADAlarmEnable(int n, int n2, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have A/D alarms");
    }

    public boolean hasADAlarmed(int n, int n2, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have A/D alarms");
    }

    public double getADResolution(int n, byte[] byArray) {
        return 0.01;
    }

    public double getADRange(int n, byte[] byArray) {
        return 10.23;
    }

    public void setADAlarm(int n, int n2, double d, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have A/D alarms");
    }

    public void setADAlarmEnable(int n, int n2, boolean bl, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have AD alarms");
    }

    public void setADResolution(int n, double d, byte[] byArray) {
    }

    public void setADRange(int n, double d, byte[] byArray) {
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[28];
        int n = 0;
        while (n < 3) {
            byte[] byArray2 = this.readPage(n);
            System.arraycopy(byArray2, 0, byArray, n * 8, 8);
            ++n;
        }
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        this.writePage(0, byArray, 0);
        this.writePage(1, byArray, 8);
    }

    public boolean hasTemperatureAlarms() {
        return false;
    }

    public boolean hasSelectableTemperatureResolution() {
        return false;
    }

    public double[] getTemperatureResolutions() {
        double[] dArray = new double[]{0.03125};
        return dArray;
    }

    public double getTemperatureAlarmResolution() throws OneWireException {
        throw new OneWireException("This device does not have temperature alarms");
    }

    public double getMaxTemperature() {
        return 125.0;
    }

    public double getMinTemperature() {
        return -55.0;
    }

    public void doTemperatureConvert(byte[] byArray) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            this.adapter.putByte(68);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new OneWireException("OneWireContainer26-Device not found.");
        }
        byte[] byArray2 = this.readPage(0);
        byArray[2] = byArray2[2];
        byArray[1] = byArray2[1];
    }

    public double getTemperature(byte[] byArray) {
        double d = (double)((short)(byArray[2] << 8 | byArray[1] & 0xFF) >> 3) * 0.03125;
        return d;
    }

    public double getTemperatureAlarm(int n, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have temperature alarms");
    }

    public double getTemperatureResolution(byte[] byArray) {
        return 0.03125;
    }

    public void setTemperatureAlarm(int n, double d, byte[] byArray) throws OneWireException, OneWireIOException {
        throw new OneWireException("This device does not have temperature alarms");
    }

    public void setTemperatureResolution(double d, byte[] byArray) throws OneWireException, OneWireIOException {
    }

    public boolean hasClockAlarm() {
        return false;
    }

    public boolean canDisableClock() {
        return false;
    }

    public long getClockResolution() {
        return 1000L;
    }

    public long getClock(byte[] byArray) {
        return this.getTime(byArray, 8) * 1000L;
    }

    public long getClockAlarm(byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have a clock alarm!");
    }

    public boolean isClockAlarming(byte[] byArray) {
        return false;
    }

    public boolean isClockAlarmEnabled(byte[] byArray) {
        return false;
    }

    public boolean isClockRunning(byte[] byArray) {
        return true;
    }

    public void setClock(long l, byte[] byArray) {
        byArray[8] = (byte)(l /= 1000L);
        byArray[9] = (byte)(l >> 8);
        byArray[10] = (byte)(l >> 16);
        byArray[11] = (byte)(l >> 24);
    }

    public void setClockAlarm(long l, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have a clock alarm!");
    }

    public void setClockRunEnable(boolean bl, byte[] byArray) throws OneWireException {
        if (!bl) {
            throw new OneWireException("This device's clock cannot be disabled!");
        }
    }

    public void setClockAlarmEnable(boolean bl, byte[] byArray) throws OneWireException {
        throw new OneWireException("This device does not have a clock alarm!");
    }
}

