/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.ClockContainer;
import com.dalsemi.onewire.container.MemoryBankNVCRC;
import com.dalsemi.onewire.container.MemoryBankScratchCRC;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.container.TemperatureContainer;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class OneWireContainer21
extends OneWireContainer
implements TemperatureContainer,
ClockContainer {
    private final byte FAMILY_CODE = (byte)33;
    private boolean doSpeedEnable = true;
    private final byte WRITE_SCRATCHPAD_COMMAND = (byte)15;
    private final byte READ_SCRATCHPAD_COMMAND = (byte)-86;
    private final byte COPY_SCRATCHPAD_COMMAND = (byte)85;
    private final byte READ_MEMORY_CRC_COMMAND = (byte)-91;
    private final byte CLEAR_MEMORY_COMMAND = (byte)60;
    private final byte CONVERT_TEMPERATURE_COMMAND = (byte)68;
    private MemoryBankScratchCRC scratch;
    private MemoryBankNVCRC register;
    private MemoryBankNVCRC alarm;
    private MemoryBankNVCRC histogram;
    private MemoryBankNVCRC log;
    private byte[] read_log_buffer = new byte[2048];
    private boolean updatertc = false;
    public static final int STATUS_REGISTER = 532;
    public static final int CONTROL_REGISTER = 526;
    public static final byte ONCE_PER_SECOND = 31;
    public static final byte ONCE_PER_MINUTE = 23;
    public static final byte ONCE_PER_HOUR = 19;
    public static final byte ONCE_PER_DAY = 17;
    public static final byte ONCE_PER_WEEK = 16;
    public static final byte TEMPERATURE_LOW_ALARM = 4;
    public static final byte TEMPERATURE_HIGH_ALARM = 2;
    public static final byte TIMER_ALARM = 1;
    public static final byte TIMER_ALARM_SEARCH_FLAG = 1;
    public static final byte TEMP_HIGH_SEARCH_FLAG = 2;
    public static final byte TEMP_LOW_SEARCH_FLAG = 4;
    public static final byte ROLLOVER_ENABLE_FLAG = 8;
    public static final byte MISSION_ENABLE_FLAG = 16;
    public static final byte MEMORY_CLEAR_ENABLE_FLAG = 64;
    public static final byte OSCILLATOR_ENABLE_FLAG = -128;
    public static final byte TIMER_ALARM_FLAG = 1;
    public static final byte TEMPERATURE_HIGH_FLAG = 2;
    public static final byte TEMPERATURE_LOW_FLAG = 4;
    public static final byte SAMPLE_IN_PROGRESS_FLAG = 16;
    public static final byte MISSION_IN_PROGRESS_FLAG = 32;
    public static final byte MEMORY_CLEARED_FLAG = 64;
    public static final byte TEMP_CORE_BUSY_FLAG = -128;

    public OneWireContainer21() {
        this.initMem();
    }

    public OneWireContainer21(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
        this.initMem();
    }

    public OneWireContainer21(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
        this.initMem();
    }

    public OneWireContainer21(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
        this.initMem();
    }

    public Enumeration getMemoryBanks() {
        Vector<PagedMemoryBank> vector = new Vector<PagedMemoryBank>(6);
        vector.addElement(this.scratch);
        vector.addElement(new MemoryBankNVCRC(this, this.scratch));
        vector.addElement(this.register);
        vector.addElement(this.alarm);
        vector.addElement(this.histogram);
        vector.addElement(this.log);
        return vector.elements();
    }

    private void initMem() {
        this.scratch = new MemoryBankScratchCRC(this);
        this.register = new MemoryBankNVCRC(this, this.scratch);
        this.register.numberPages = 1;
        this.register.size = 32;
        this.register.bankDescription = "Register control";
        this.register.startPhysicalAddress = 512;
        this.register.generalPurposeMemory = false;
        this.alarm = new MemoryBankNVCRC(this, this.scratch);
        this.alarm.numberPages = 3;
        this.alarm.size = 96;
        this.alarm.bankDescription = "Alarm time stamps";
        this.alarm.startPhysicalAddress = 544;
        this.alarm.generalPurposeMemory = false;
        this.alarm.readOnly = true;
        this.alarm.readWrite = false;
        this.histogram = new MemoryBankNVCRC(this, this.scratch);
        this.histogram.numberPages = 4;
        this.histogram.size = 128;
        this.histogram.bankDescription = "Temperature Histogram";
        this.histogram.startPhysicalAddress = 2048;
        this.histogram.generalPurposeMemory = false;
        this.histogram.readOnly = true;
        this.histogram.readWrite = false;
        this.log = new MemoryBankNVCRC(this, this.scratch);
        this.log.numberPages = 64;
        this.log.size = 2048;
        this.log.bankDescription = "Temperature log";
        this.log.startPhysicalAddress = 4096;
        this.log.generalPurposeMemory = false;
        this.log.readOnly = true;
        this.log.readWrite = false;
    }

    private int[] getDate(int n, byte[] byArray) {
        int[] nArray = new int[3];
        n &= 0x1F;
        byte by = byArray[n++];
        byte by2 = (byte)(by >>> 4 & 0xF);
        by = (byte)(by & 0xF);
        nArray[2] = 10 * by2 + by;
        by = byArray[n++];
        by2 = (byte)(by >>> 4 & 0xF);
        by = (byte)(by & 0xF);
        byte by3 = (byte)(by2 >>> 3 & 1);
        by2 = (byte)(by2 & 1);
        nArray[1] = by + by2 * 10;
        nArray[0] = 1900 + by3 * 100;
        by = byArray[n++];
        by2 = (byte)(by >>> 4 & 0xF);
        by = (byte)(by & 0xF);
        nArray[0] = nArray[0] + (by2 * 10 + by);
        return nArray;
    }

    private int[] getTime(int n, byte[] byArray) {
        int n2;
        int[] nArray = new int[3];
        n &= 0x1F;
        byte by = byArray[n++];
        byte by2 = (byte)(by >>> 4 & 7);
        by = (byte)(by & 0xF);
        nArray[0] = by + by2 * 10;
        by = byArray[n++];
        by2 = (byte)(by >>> 4 & 7);
        by = (byte)(by & 0xF);
        nArray[1] = by + by2 * 10;
        by = byArray[n++];
        by2 = (byte)(by >>> 4 & 7);
        by = (byte)(by & 0xF);
        if (by2 >>> 2 != 0) {
            byte by3 = (byte)(by2 << 6 >>> 7 & 1);
            by2 = (byte)(by2 & 1);
            n2 = by2 * 10 + by3 * 10;
        } else {
            n2 = by2 * 10;
        }
        nArray[2] = n2 += by;
        return nArray;
    }

    private void setTime(int n, int n2, int n3, int n4, boolean bl, byte[] byArray) {
        int n5 = n4 / 10;
        n5 = (byte)(n5 << 4 & 0xF0);
        int n6 = n4 % 10;
        n6 = (byte)(n6 & 0xF);
        byArray[n & 0x1F] = (byte)(n5 | n6);
        n5 = (byte)(n3 / 10);
        n5 = (byte)(n5 << 4 & 0xF0);
        n6 = (byte)(n3 % 10);
        n6 = (byte)(n6 & 0xF);
        byArray[++n & 0x1F] = (byte)(n5 | n6);
        ++n;
        if (bl) {
            n5 = 4;
            if (n2 > 11) {
                n5 = (byte)(n5 | 2);
            }
            if (n2 % 12 == 0 || n2 % 12 > 9) {
                n5 = (byte)(n5 | 1);
            }
            if (n2 > 12) {
                n2 -= 12;
            }
            n6 = n2 == 0 ? 2 : (int)((byte)(n2 % 10 & 0xF));
        } else {
            n5 = (byte)(n2 / 10);
            n6 = (byte)(n2 % 10);
        }
        n5 = (byte)(n5 << 4 & 0xF0);
        n6 = (byte)(n6 & 0xF);
        byArray[n & 0x1F] = (byte)(n5 | n6);
        ++n;
    }

    private void setDate(int n, int n2, int n3, byte[] byArray) {
        byte by = (byte)(n3 / 10);
        by = (byte)(by << 4 & 0xF0);
        byte by2 = (byte)(n3 % 10);
        by2 = (byte)(by2 & 0xF);
        byArray[4] = (byte)(by | by2);
        by = (byte)(n2 / 10);
        by = (byte)(by << 4 & 0xF0);
        by2 = (byte)(n2 % 10);
        by2 = (byte)(by2 & 0xF);
        if (n > 1999) {
            by = (byte)(by | 0x80);
            n -= 2000;
        } else {
            n -= 1900;
        }
        byArray[5] = (byte)(by | by2);
        by = (byte)(n / 10);
        by = (byte)(by << 4 & 0xF0);
        by2 = (byte)(n % 10);
        by2 = (byte)(by2 & 0xF);
        byArray[6] = (byte)(by | by2);
    }

    public int getMaxSpeed() {
        return 2;
    }

    public String getName() {
        return "DS1921";
    }

    public String getAlternateNames() {
        return "Thermochron";
    }

    public String getDescription() {
        return "Rugged, self-sufficient 1-Wire device that, once setup for a mission, will measure the temperature and record the result in a protected memory section. It can store up to 2048 temperature measurements and will take these measurements at a rate specified by the user.  The thermochron also keeps track of the number of times the temperature falls on a given 1.5 degree range, and stores the data in histogram format.";
    }

    public synchronized void setSpeedCheck(boolean bl) {
        this.doSpeedEnable = bl;
    }

    public double decodeTemperature(byte by) {
        return (double)(by & 0xFF) / 2.0 - 40.0;
    }

    public byte encodeTemperature(double d) {
        return (byte)((int)(2.0 * d) + 80 & 0xFF);
    }

    public void writeByte(int n, byte by) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[5];
        byte by2 = (byte)(n >>> 8 & 0xFF);
        byte by3 = (byte)(n & 0xFF);
        if (by2 > 31 || by2 < 0) {
            throw new IllegalArgumentException("OneWireContainer21-Address for write out of range.");
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            byArray[0] = 15;
            byArray[1] = by3;
            byArray[2] = by2;
            byArray[3] = by;
            this.adapter.dataBlock(byArray, 0, 4);
            this.adapter.select(this.address);
            byArray[0] = -86;
            int n2 = 1;
            while (n2 < 5) {
                byArray[n2] = -1;
                ++n2;
            }
            this.adapter.dataBlock(byArray, 0, 5);
            if (byArray[4] != by) {
                throw new OneWireIOException("OneWireContainer21-Error writing data byte.");
            }
            this.adapter.select(this.address);
            byArray[0] = 85;
            byArray[4] = -1;
            this.adapter.dataBlock(byArray, 0, 5);
            if (byArray[4] != -86 && byArray[4] != -69) {
                throw new OneWireIOException("OneWireContainer21-Error writing data byte.");
            }
        } else {
            throw new OneWireException("OneWireContainer21-Device not present.");
        }
    }

    public byte readByte(int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[4];
        byte by = (byte)(n >> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        if (by > 31 || by < 0) {
            throw new IllegalArgumentException("OneWireContainer21-Address for read out of range.");
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            byArray[0] = -91;
            byArray[1] = by2;
            byArray[2] = by;
            byArray[3] = -1;
            this.adapter.dataBlock(byArray, 0, 4);
            return byArray[3];
        }
        throw new OneWireException("OneWireContainer21-Device not present.");
    }

    public boolean getFlag(int n, byte by) throws OneWireIOException, OneWireException {
        return (this.readByte(n) & by) != 0;
    }

    public boolean getFlag(int n, byte by, byte[] byArray) {
        return (byArray[n & 0x1F] & by) != 0;
    }

    public void setFlag(int n, byte by, boolean bl) throws OneWireIOException, OneWireException {
        if (this.getFlag(532, (byte)32)) {
            throw new OneWireIOException("OneWireContainer21-Cannot write to register while mission is in progress.");
        }
        byte by2 = this.readByte(n);
        by2 = bl ? (byte)(by2 | by) : (byte)(by2 & ~by);
        this.writeByte(n, by2);
    }

    public void setFlag(int n, byte by, boolean bl, byte[] byArray) {
        byte by2 = byArray[n &= 0x1F];
        by2 = bl ? (byte)(by2 | by) : (byte)(by2 & ~by);
        byArray[n] = by2;
    }

    public void enableMission(int n) throws OneWireIOException, OneWireException {
        if (n > 255 || n < 0) {
            throw new IllegalArgumentException("OneWireContainer21-Sample rate must be 255 minutes or less");
        }
        if (this.getFlag(532, (byte)32)) {
            throw new OneWireIOException("OneWireContainer30-Unable to start mission (Mission already in Progress)");
        }
        byte by = this.readByte(526);
        by = (byte)(by & 0xEF);
        this.writeByte(526, by);
        this.writeByte(525, (byte)(n & 0xFF));
    }

    public void disableMission() throws OneWireIOException, OneWireException {
        byte by = this.readByte(532);
        by = (byte)(by & 0xDF);
        this.writeByte(532, by);
    }

    public void setMissionStartDelay(int n, byte[] byArray) {
        byArray[18] = (byte)n;
        byArray[19] = (byte)(n >> 8);
    }

    public void clearMemory() throws OneWireIOException, OneWireException {
        this.setFlag(526, (byte)64, true);
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        this.adapter.reset();
        if (this.adapter.select(this.address)) {
            this.adapter.putByte(60);
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        } else {
            throw new OneWireException("OneWireContainer21-Device not found.");
        }
    }

    public Calendar getAlarmTime(byte[] byArray) {
        int[] nArray = this.getTime(519, byArray);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(0, 0, 0, nArray[2], nArray[1], nArray[0]);
        byte by = (byte)(byArray[10] & 7);
        gregorianCalendar.set(5, by);
        return gregorianCalendar;
    }

    public void setClockAlarm(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.setTime(519, n, n2, n3, false, byArray);
        byArray[10] = (byte)n4;
        int n6 = 0;
        switch (n5) {
            case 31: {
                n6 = 0;
                break;
            }
            case 23: {
                n6 = 1;
                break;
            }
            case 19: {
                n6 = 2;
                break;
            }
            case 17: {
                n6 = 3;
                break;
            }
            case 16: {
                n6 = 4;
            }
        }
        int n7 = 7;
        while (n7 < 11) {
            if (n6 > 0) {
                --n6;
                byArray[n7] = (byte)(byArray[n7] & 0x7F);
            } else {
                byArray[n7] = (byte)(byArray[n7] | 0x80);
            }
            ++n7;
        }
    }

    public int getSampleRate(byte[] byArray) {
        return byArray[13];
    }

    public int getMissionSamplesCounter(byte[] byArray) {
        byte by = byArray[26];
        byte by2 = byArray[27];
        byte by3 = byArray[28];
        return by3 << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by & 0xFF;
    }

    public int getDeviceSamplesCounter(byte[] byArray) {
        byte by = byArray[29];
        byte by2 = byArray[30];
        byte by3 = byArray[31];
        return by3 << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by & 0xFF;
    }

    public Calendar getMissionTimeStamp(byte[] byArray) {
        int[] nArray = this.getTime(532, byArray);
        int[] nArray2 = this.getDate(535, byArray);
        int n = nArray2[0] % 100;
        int n2 = this.getMissionSamplesCounter(byArray);
        int n3 = this.getSampleRate(byArray);
        int n4 = n2 * n3 / 525600;
        int[] nArray3 = this.getDate(516, byArray);
        int n5 = nArray3[0];
        n = n5 - n4 > 1999 ? (n += 2000) : (n += 1900);
        if (n > n5) {
            n -= 100;
        }
        return new GregorianCalendar(n, nArray2[1] - 1, nArray2[2], nArray[2], nArray[1]);
    }

    public long getFirstLogOffset(byte[] byArray) {
        long l = this.getMissionSamplesCounter(byArray);
        if (l < 2049L || !this.getFlag(526, (byte)8, byArray)) {
            return 0L;
        }
        l -= 2048L;
        int n = this.getSampleRate(byArray);
        l = l * (long)n * 1000L * 60L;
        return l;
    }

    public synchronized byte[] getTemperatureLog(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = this.getMissionSamplesCounter(byArray);
        int n2 = 0;
        if (this.getFlag(526, (byte)8, byArray) && n > 2048) {
            n2 = n % 2048;
        }
        if (n > 2048) {
            n = 2048;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            this.log.readPageCRC(n3 >> 5, false, this.read_log_buffer, n3);
            n3 += 32;
        }
        System.arraycopy(this.read_log_buffer, n2, byArray2, 0, n - n2);
        System.arraycopy(this.read_log_buffer, 0, byArray2, n - n2, n2);
        return byArray2;
    }

    public int[] getTemperatureHistogram() throws OneWireIOException, OneWireException {
        int[] nArray = new int[63];
        byte[] byArray = new byte[128];
        int n = 0;
        while (n < 128) {
            this.histogram.readPageCRC(n >> 5, false, byArray, n);
            n += 32;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < 63) {
            nArray[n2] = byArray[n3] & 0xFF | byArray[n3 + 1] << 8 & 0xFF00;
            ++n2;
            n3 += 2;
        }
        return nArray;
    }

    public boolean getAlarmStatus(byte by, byte[] byArray) {
        return (byArray[20] & by) != 0;
    }

    public byte[] getAlarmHistory(byte by) throws OneWireIOException, OneWireException {
        int n = 0;
        byte[] byArray = new byte[96];
        int n2 = 0;
        while (n2 < 96) {
            this.alarm.readPageCRC(n2 >> 5, false, byArray, n2);
            n2 += 32;
        }
        n2 = by == 4 ? 0 : 48;
        while (n * 4 + 3 + n2 < byArray.length && byArray[n * 4 + 3 + n2] != 0) {
            ++n;
        }
        byte[] byArray2 = new byte[n << 2];
        System.arraycopy(byArray, n2, byArray2, 0, n << 2);
        return byArray2;
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[32];
        this.register.readPageCRC(0, false, byArray, 0);
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        if (this.getFlag(532, (byte)32)) {
            throw new OneWireIOException("OneWireContainer21-Cannot write to registers while mission is in progress.");
        }
        int n = this.updatertc ? 0 : 7;
        this.register.write(n, byArray, n, 20 - n);
        OneWireContainer21 oneWireContainer21 = this;
        synchronized (oneWireContainer21) {
            this.updatertc = false;
        }
    }

    public boolean hasTemperatureAlarms() {
        return true;
    }

    public boolean hasSelectableTemperatureResolution() {
        return false;
    }

    public double[] getTemperatureResolutions() {
        double[] dArray = new double[]{1.5};
        return dArray;
    }

    public double getTemperatureAlarmResolution() {
        return 1.5;
    }

    public double getMaxTemperature() {
        return 85.0;
    }

    public double getMinTemperature() {
        return -10.0;
    }

    public void doTemperatureConvert(byte[] byArray) throws OneWireIOException, OneWireException {
        if (this.getFlag(532, (byte)32)) {
            throw new OneWireIOException("OneWireContainer21-Cant force temperature read during a mission.");
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        this.adapter.reset();
        if (this.adapter.select(this.address)) {
            this.adapter.putByte(68);
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new OneWireException("OneWireContainer21-Device not found!");
        }
        byArray[17] = this.readByte(529);
    }

    public double getTemperature(byte[] byArray) {
        return this.decodeTemperature(byArray[17]);
    }

    public double getTemperatureAlarm(int n, byte[] byArray) {
        if (n == 2 || n == 1) {
            return this.decodeTemperature(byArray[12]);
        }
        return this.decodeTemperature(byArray[11]);
    }

    public double getTemperatureResolution(byte[] byArray) {
        return 1.5;
    }

    public void setTemperatureAlarm(int n, double d, byte[] byArray) {
        int n2 = this.encodeTemperature(d);
        if (d < -40.0) {
            n2 = 0;
        }
        if (d > 85.0) {
            n2 = -6;
        }
        if (n == 2 || n == 1) {
            byArray[12] = n2;
        } else {
            byArray[11] = n2;
        }
    }

    public void setTemperatureResolution(double d, byte[] byArray) throws OneWireException {
        throw new OneWireException("Selectable Temperature Resolution Not Supported");
    }

    public boolean hasClockAlarm() {
        return true;
    }

    public boolean canDisableClock() {
        return true;
    }

    public long getClockResolution() {
        return 1000L;
    }

    public long getClock(byte[] byArray) {
        int[] nArray = this.getTime(512, byArray);
        int[] nArray2 = this.getDate(516, byArray);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(nArray2[0], nArray2[1] - 1, nArray2[2], nArray[2], nArray[1], nArray[0]);
        return gregorianCalendar.getTime().getTime();
    }

    public long getClockAlarm(byte[] byArray) {
        int[] nArray = this.getTime(512, byArray);
        int[] nArray2 = this.getDate(516, byArray);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(nArray2[0], nArray2[1] - 1, nArray2[2], nArray[2], nArray[1], nArray[0]);
        int n = nArray[0] + 60 * nArray[1] + 3600 * nArray[2];
        int[] nArray3 = this.getTime(519, byArray);
        int n2 = nArray3[0] + 60 * nArray3[1] + 3600 * nArray3[2];
        byte by = (byte)(byArray[10] & 7);
        if (by == 0) {
            by = (byte)(by + 1);
        }
        byte by2 = (byte)(byArray[7] >>> 7 & 1);
        byte by3 = (byte)(byArray[8] >>> 7 & 1);
        byte by4 = (byte)(byArray[9] >>> 7 & 1);
        byte by5 = (byte)(byArray[10] >>> 7 & 1);
        long l = 0L;
        int n3 = 86400000;
        switch (by2 + by3 + by4 + by5) {
            case 4: {
                ((Calendar)gregorianCalendar).add(13, 1);
                break;
            }
            case 3: {
                if (n2 >= n) {
                    ((Calendar)gregorianCalendar).add(12, 1);
                }
                gregorianCalendar.set(13, nArray3[0]);
                break;
            }
            case 2: {
                if (n2 >= n) {
                    ((Calendar)gregorianCalendar).add(10, 1);
                }
                gregorianCalendar.set(13, nArray3[0]);
                gregorianCalendar.set(12, nArray3[1]);
                break;
            }
            case 1: {
                gregorianCalendar.set(13, nArray3[0]);
                gregorianCalendar.set(12, nArray3[1]);
                gregorianCalendar.set(10, nArray3[2]);
                if (n2 >= n) break;
                ((Calendar)gregorianCalendar).add(5, 1);
                break;
            }
            case 0: {
                gregorianCalendar.set(13, nArray3[0]);
                gregorianCalendar.set(12, nArray3[1]);
                gregorianCalendar.set(10, nArray3[2]);
                l = gregorianCalendar.getTime().getTime();
                if (by == gregorianCalendar.get(7)) {
                    if (n2 < n) {
                        l += (long)(7 * n3);
                    }
                } else {
                    int n4 = gregorianCalendar.get(7);
                    while (by % 7 != n4++ % 7) {
                        l += (long)n3;
                    }
                }
                return l;
            }
        }
        return gregorianCalendar.getTime().getTime();
    }

    public boolean isClockAlarming(byte[] byArray) {
        return (byArray[20] & 1) != 0;
    }

    public boolean isClockAlarmEnabled(byte[] byArray) {
        return (byArray[14] & 1) != 0;
    }

    public boolean isClockRunning(byte[] byArray) {
        return (byArray[14] & 0xFFFFFF80) == 0;
    }

    public void setClock(long l, byte[] byArray) {
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setTime(512, gregorianCalendar.get(10) + (gregorianCalendar.get(9) == 1 ? 12 : 0), gregorianCalendar.get(12), gregorianCalendar.get(13), false, byArray);
        this.setDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), byArray);
        OneWireContainer21 oneWireContainer21 = this;
        synchronized (oneWireContainer21) {
            this.updatertc = true;
        }
    }

    public void setClockAlarm(long l, byte[] byArray) throws OneWireException {
        throw new OneWireException("Cannot set the DS1921 Clock Alarm through the Clock interface.");
    }

    public void setClockRunEnable(boolean bl, byte[] byArray) {
        this.setFlag(526, (byte)-128, !bl, byArray);
    }

    public void setClockAlarmEnable(boolean bl, byte[] byArray) {
        this.setFlag(526, (byte)1, bl, byArray);
    }
}

