/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.ADContainer;
import com.dalsemi.onewire.container.MemoryBankAD;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.Bit;
import com.dalsemi.onewire.utils.CRC16;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer20
extends OneWireContainer
implements ADContainer {
    public static final int BITMAP_OFFSET = 24;
    public static final int ALARM_OFFSET = 8;
    public static final int EXPOWER_OFFSET = 20;
    public static final int CHANNELA = 0;
    public static final int CHANNELB = 1;
    public static final int CHANNELC = 2;
    public static final int CHANNELD = 3;
    public static final int NO_PRESET = 0;
    public static final int PRESET_TO_ZEROS = 1;
    public static final int PRESET_TO_ONES = 2;
    public static final int NUM_CHANNELS = 4;
    private static final byte CONVERT_COMMAND = 60;
    private MemoryBankAD readout;
    private Vector regs;

    public OneWireContainer20() {
        this.initMem();
    }

    public OneWireContainer20(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
        this.initMem();
    }

    public OneWireContainer20(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
        this.initMem();
    }

    public OneWireContainer20(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
        this.initMem();
    }

    public String getName() {
        return "DS2450";
    }

    public String getAlternateNames() {
        return "1-Wire Quad A/D Converter";
    }

    public String getDescription() {
        return "Four high-impedance inputs for measurement of analog voltages.  User programable input range.  Very low power.  Built-in multidrop controller.  Channels not used as input can be configured as outputs through the use of open drain digital outputs. Capable of use of Overdrive for fast data transfer. Uses on-chip 16-bit CRC-generator to garantee good data.";
    }

    public int getMaxSpeed() {
        return 2;
    }

    public Enumeration getMemoryBanks() {
        Vector<MemoryBankAD> vector = new Vector<MemoryBankAD>(4);
        vector.addElement(this.readout);
        int n = 0;
        while (n < 3) {
            vector.addElement((MemoryBankAD)this.regs.elementAt(n));
            ++n;
        }
        return vector.elements();
    }

    public int getNumberADChannels() {
        return 4;
    }

    public boolean hasADAlarms() {
        return true;
    }

    public double[] getADRanges(int n) {
        double[] dArray = new double[]{5.12, 2.56};
        return dArray;
    }

    public double[] getADResolutions(int n, double d) {
        double[] dArray = new double[16];
        int n2 = 0;
        while (n2 < 16) {
            dArray[n2] = d / (double)(1 << n2 + 1);
            ++n2;
        }
        return dArray;
    }

    public boolean canADMultiChannelRead() {
        return true;
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[27];
        int n = 0;
        while (n < 3) {
            MemoryBankAD memoryBankAD = (MemoryBankAD)this.regs.elementAt(n);
            memoryBankAD.readPageCRC(0, n != 0, byArray, n * 8);
            ++n;
        }
        byArray[24] = 0;
        byArray[25] = 0;
        byArray[26] = 0;
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = 0;
        while (n < 4) {
            int n2 = n * 2 + 1;
            if ((byArray[n2] & 0xFFFFFFB0) != 0) {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] & 0xF);
                Bit.arrayWriteBit(1, n2, 24, byArray);
            }
            ++n;
        }
        byArray[26] = (byArray[26] & 0x10) == 16 ? 16 : 0;
        int n4 = 0;
        while (n4 < 3) {
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            MemoryBankAD memoryBankAD = (MemoryBankAD)this.regs.elementAt(n4);
            n = 0;
            while (n < 8) {
                if (Bit.arrayReadBit(n4 * 8 + n, 24, byArray) == 1) {
                    if (bl) {
                        ++n6;
                    } else {
                        bl = true;
                        n5 = n;
                        n6 = 1;
                    }
                    if (n == 7) {
                        memoryBankAD.write(n5, byArray, n4 * 8 + n5, n6);
                    }
                } else if (bl) {
                    memoryBankAD.write(n5, byArray, n4 * 8 + n5, n6);
                    bl = false;
                }
                ++n;
            }
            ++n4;
        }
        byArray[24] = 0;
        byArray[25] = 0;
        byArray[26] = 0;
    }

    public double[] getADVoltage(byte[] byArray) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[8];
        double[] dArray = new double[4];
        this.readout.readPageCRC(0, false, byArray2, 0);
        int n = 0;
        while (n < 4) {
            dArray[n] = OneWireContainer20.interpretVoltage(OneWireContainer20.byteArrayToLong(byArray2, n * 2, 2), this.getADRange(n, byArray));
            ++n;
        }
        return dArray;
    }

    public double getADVoltage(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        byte[] byArray2 = new byte[8];
        this.readout.readPageCRC(0, false, byArray2, 0);
        return OneWireContainer20.interpretVoltage(OneWireContainer20.byteArrayToLong(byArray2, n * 2, 2), this.getADRange(n, byArray));
    }

    public void doADConvert(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        this.doADConvert(n, 1, byArray);
    }

    public void doADConvert(boolean[] blArray, byte[] byArray) throws OneWireIOException, OneWireException {
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = 1;
            ++n;
        }
        this.doADConvert(blArray, nArray, byArray);
    }

    public void doADConvert(int n, int n2, byte[] byArray) throws OneWireIOException, OneWireException, IllegalArgumentException {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        this.doADConvert((byte)(1 << n), (byte)(n2 << n), 1440, byArray);
    }

    public void doADConvert(boolean[] blArray, int[] nArray, byte[] byArray) throws OneWireIOException, OneWireException {
        byte by = 0;
        byte by2 = 0;
        int n = 160;
        int n2 = 3;
        while (n2 >= 0) {
            by = (byte)(by << 1);
            if (blArray[n2]) {
                by = (byte)(by | 1);
            }
            by2 = (byte)(by2 << 2);
            if (nArray[n2] == 1) {
                by2 = (byte)(by2 | 1);
            } else if (nArray[n2] == 2) {
                by2 = (byte)(by2 | 2);
            }
            n = (int)((double)n + 80.0 * this.getADResolution(n2, byArray));
            --n2;
        }
        this.doADConvert(by, by2, n, byArray);
    }

    public double getADAlarm(int n, int n2, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        long l = (long)(byArray[8 + n * 2 + n2] & 0xFF) << 8;
        return OneWireContainer20.interpretVoltage(l, this.getADRange(n, byArray));
    }

    public boolean getADAlarmEnable(int n, int n2, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        return Bit.arrayReadBit(2 + n2, n * 2 + 1, byArray) == 1;
    }

    public boolean hasADAlarmed(int n, int n2, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        return Bit.arrayReadBit(4 + n2, n * 2 + 1, byArray) == 1;
    }

    public double getADResolution(int n, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        int n2 = byArray[n * 2] & 0xF;
        if (n2 == 0) {
            n2 = 16;
        }
        return this.getADRange(n, byArray) / (double)(1 << n2);
    }

    public double getADRange(int n, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        return Bit.arrayReadBit(0, n * 2 + 1, byArray) == 1 ? 5.12 : 2.56;
    }

    public boolean isOutputEnabled(int n, byte[] byArray) throws IllegalArgumentException {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        return Bit.arrayReadBit(7, n * 2, byArray) == 1;
    }

    public boolean getOutputState(int n, byte[] byArray) throws IllegalArgumentException {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        return Bit.arrayReadBit(6, n * 2, byArray) == 1;
    }

    public boolean getDevicePOR(byte[] byArray) {
        return Bit.arrayReadBit(7, 1, byArray) == 1;
    }

    public boolean isPowerExternal(byte[] byArray) {
        return byArray[20] != 0;
    }

    public void setADAlarm(int n, int n2, double d, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        int n3 = 8 + n * 2 + n2;
        byArray[n3] = (byte)(OneWireContainer20.voltageToInt(d, this.getADRange(n, byArray)) >>> 8 & 0xFF);
        Bit.arrayWriteBit(1, n3, 24, byArray);
    }

    public void setADAlarmEnable(int n, int n2, boolean bl, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        Bit.arrayWriteBit(bl ? 1 : 0, 2 + n2, n * 2 + 1, byArray);
        Bit.arrayWriteBit(1, n * 2 + 1, 24, byArray);
    }

    public void setADResolution(int n, double d, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        int n2 = (int)(this.getADRange(n, byArray) / d);
        int n3 = 0;
        do {
            ++n3;
        } while ((n2 >>>= 1) != 0);
        if (--n3 == 16) {
            n3 = 0;
        }
        if (n3 < 0 || n3 > 15) {
            throw new IllegalArgumentException("Invalid resolution");
        }
        int n4 = n * 2;
        byArray[n4] = (byte)(byArray[n4] & 0xFFFFFFF0);
        int n5 = n * 2;
        byArray[n5] = (byte)(byArray[n5] | (n3 == 16 ? (byte)0 : (byte)n3));
        Bit.arrayWriteBit(1, n * 2, 24, byArray);
    }

    public void setADRange(int n, double d, byte[] byArray) {
        int n2;
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        if (d > 5.0 & d < 5.3) {
            n2 = 1;
        } else if (d > 2.4 & d < 2.7) {
            n2 = 0;
        } else {
            throw new IllegalArgumentException("Invalid range");
        }
        Bit.arrayWriteBit(n2, 0, n * 2 + 1, byArray);
        Bit.arrayWriteBit(1, n * 2 + 1, 24, byArray);
    }

    public void setOutput(int n, boolean bl, boolean bl2, byte[] byArray) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        Bit.arrayWriteBit(bl ? 1 : 0, 7, n * 2, byArray);
        if (bl) {
            Bit.arrayWriteBit(bl2 ? 1 : 0, 6, n * 2, byArray);
        }
        Bit.arrayWriteBit(1, n * 2, 24, byArray);
    }

    public void setPower(boolean bl, byte[] byArray) {
        byArray[20] = bl ? -128 : 0;
        Bit.arrayWriteBit(1, 20, 24, byArray);
    }

    public static double interpretVoltage(long l, double d) {
        return (double)l / 65535.0 * d;
    }

    public static int voltageToInt(double d, double d2) {
        return (int)(d * 65535.0 / d2);
    }

    private void initMem() {
        this.readout = new MemoryBankAD(this);
        this.regs = new Vector(3);
        MemoryBankAD memoryBankAD = new MemoryBankAD(this);
        memoryBankAD.bankDescription = "A/D Control and Status";
        memoryBankAD.generalPurposeMemory = false;
        memoryBankAD.startPhysicalAddress = 8;
        memoryBankAD.readWrite = true;
        memoryBankAD.readOnly = false;
        this.regs.addElement(memoryBankAD);
        memoryBankAD = new MemoryBankAD(this);
        memoryBankAD.bankDescription = "A/D Alarm Settings";
        memoryBankAD.generalPurposeMemory = false;
        memoryBankAD.startPhysicalAddress = 16;
        memoryBankAD.readWrite = true;
        memoryBankAD.readOnly = false;
        this.regs.addElement(memoryBankAD);
        memoryBankAD = new MemoryBankAD(this);
        memoryBankAD.bankDescription = "A/D Calibration";
        memoryBankAD.generalPurposeMemory = false;
        memoryBankAD.startPhysicalAddress = 24;
        memoryBankAD.readWrite = true;
        memoryBankAD.readOnly = false;
        this.regs.addElement(memoryBankAD);
    }

    private static long byteArrayToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            l <<= 8;
            l |= (long)(byArray[n + n3] & 0xFF);
            --n3;
        }
        return l;
    }

    private void doADConvert(byte by, byte by2, int n, byte[] byArray) throws OneWireIOException, OneWireException {
        if (by == 0) {
            throw new IllegalArgumentException("No conversion will take place.  No channel selected.");
        }
        byte[] byArray2 = new byte[]{60, by, by2, -1, -1};
        int n2 = CRC16.compute(byArray2, 0, 3, 0);
        if (this.adapter.select(this.address)) {
            if (this.isPowerExternal(byArray)) {
                this.adapter.dataBlock(byArray2, 0, 5);
                try {
                    Thread.sleep(n / 1000 + 10);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 = CRC16.compute(byArray2, 3, 2, n2);
            } else {
                this.adapter.dataBlock(byArray2, 0, 4);
                this.adapter.setPowerDuration(5);
                this.adapter.startPowerDelivery(2);
                byArray2[4] = (byte)this.adapter.getByte();
                n2 = CRC16.compute(byArray2, 3, 2, n2);
                try {
                    Thread.sleep(n / 1000 + 1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.adapter.setPowerNormal();
            }
        } else {
            throw new OneWireException("OneWireContainer20 - Device not found.");
        }
        if (n2 != 45057) {
            throw new OneWireIOException("OneWireContainer20 - Failure during conversion - Bad CRC");
        }
        if (this.adapter.getByte() == 0) {
            throw new OneWireIOException("Conversion failed to complete.");
        }
    }
}

