/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.SwitchContainer;
import com.dalsemi.onewire.utils.Bit;

public class OneWireContainer1F
extends OneWireContainer
implements SwitchContainer {
    protected static final int BITMAP_OFFSET = 3;
    protected static final int STATUS_OFFSET = 0;
    protected static final int MAIN_OFFSET = 1;
    protected static final int AUX_OFFSET = 2;
    protected static final int SWITCH_OFF = 0;
    protected static final int SWITCH_ON = 1;
    protected static final int SWITCH_SMART = 2;
    protected static final byte READ_WRITE_STATUS_COMMAND = 90;
    protected static final byte ALL_LINES_OFF_COMMAND = 102;
    protected static final byte DISCHARGE_COMMAND = -103;
    protected static final byte DIRECT_ON_MAIN_COMMAND = -91;
    protected static final byte SMART_ON_MAIN_COMMAND = -52;
    protected static final byte SMART_ON_AUX_COMMAND = 51;
    public static final int CHANNEL_MAIN = 0;
    public static final int CHANNEL_AUX = 1;
    private boolean clearActivityOnWrite = false;
    private boolean doSpeedEnable = true;
    private boolean devicesOnBranch = false;

    public OneWireContainer1F() {
    }

    public OneWireContainer1F(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer1F(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer1F(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2409";
    }

    public String getAlternateNames() {
        return "Coupler";
    }

    public String getDescription() {
        return "1-Wire Network Coupler with dual addressable switches and a general purpose open drain control output.  Provides a common ground for all connectedmulti-level MicroLan networks.  Keeps inactive branchesPulled to 5V.";
    }

    public synchronized void setSpeedCheck(boolean bl) {
        this.doSpeedEnable = bl;
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[4];
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        byte[] byArray2 = this.deviceOperation((byte)90, (byte)-1, 2);
        byArray[0] = byArray2[2];
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = 0;
        byte[] byArray2 = null;
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (Bit.arrayReadBit(1, 3, byArray) == 1 && Bit.arrayReadBit(2, 3, byArray) == 1 && byArray[1] != 0 && byArray[2] != 0) {
            throw new OneWireException("Attempting to set both channels on, only single channel on at a time");
        }
        if (Bit.arrayReadBit(0, 3, byArray) == 1) {
            byte by = 0;
            if (Bit.arrayReadBit(7, 0, byArray) == 1) {
                by = (byte)(by | 0x20);
            }
            if (Bit.arrayReadBit(6, 0, byArray) == 1) {
                by = (byte)(by | 0xFFFFFFC0);
            }
            byArray2 = this.deviceOperation((byte)90, by, 2);
            byArray[0] = byArray2[2];
        }
        int n2 = 0;
        if (Bit.arrayReadBit(2, 3, byArray) == 1) {
            if (byArray[2] == 1 || byArray[2] == 2) {
                n2 = 51;
                n = 2;
            } else {
                n2 = 102;
                n = 0;
            }
        }
        if (Bit.arrayReadBit(1, 3, byArray) == 1) {
            if (byArray[1] == 1) {
                n2 = -91;
                n = 0;
            } else if (byArray[1] == 2) {
                n2 = -52;
                n = 2;
            } else {
                n2 = 102;
                n = 0;
            }
        }
        if (this.clearActivityOnWrite && n2 != 102 && (Bit.arrayReadBit(4, 0, byArray) == 1 || Bit.arrayReadBit(5, 0, byArray) == 1)) {
            this.deviceOperation((byte)102, (byte)-1, 0);
            if (n2 == 0) {
                if (Bit.arrayReadBit(0, 0, byArray) == 0) {
                    n2 = -52;
                } else if (Bit.arrayReadBit(2, 0, byArray) == 0) {
                    n2 = 51;
                }
                n = 2;
            }
        }
        if (n2 != 0) {
            byArray2 = this.deviceOperation((byte)n2, (byte)-1, n);
        }
        this.devicesOnBranch = n2 == -52 || n2 == 51 ? byArray2[2] == 0 : false;
        this.clearActivityOnWrite = false;
        byArray[3] = 0;
    }

    public void dischargeLines(int n) throws OneWireIOException, OneWireException {
        if (n < 100) {
            n = 100;
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        this.deviceOperation((byte)-103, (byte)-1, 0);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.deviceOperation((byte)90, (byte)-1, 2);
    }

    public boolean isHighSideSwitch() {
        return true;
    }

    public boolean hasActivitySensing() {
        return true;
    }

    public boolean hasLevelSensing() {
        return true;
    }

    public boolean hasSmartOn() {
        return true;
    }

    public boolean onlySingleChannelOn() {
        return true;
    }

    public int getNumberChannels(byte[] byArray) {
        return 2;
    }

    public boolean getLevel(int n, byte[] byArray) throws OneWireException {
        return Bit.arrayReadBit(1 + n * 2, 0, byArray) == 1;
    }

    public boolean getLatchState(int n, byte[] byArray) {
        return Bit.arrayReadBit(n * 2, 0, byArray) == 0;
    }

    public boolean getSensedActivity(int n, byte[] byArray) throws OneWireException {
        return Bit.arrayReadBit(4 + n, 0, byArray) == 1;
    }

    public boolean isModeAuto(byte[] byArray) {
        return Bit.arrayReadBit(7, 0, byArray) == 0;
    }

    public int getControlChannelAssociation(byte[] byArray) {
        return Bit.arrayReadBit(6, 0, byArray);
    }

    public int getControlData(byte[] byArray) {
        return Bit.arrayReadBit(6, 0, byArray);
    }

    public boolean getLastSmartOnDeviceDetect() {
        return this.devicesOnBranch;
    }

    public void setLatchState(int n, boolean bl, boolean bl2, byte[] byArray) {
        byArray[n + 1] = bl ? (bl2 ? 2 : 1) : 0;
        Bit.arrayWriteBit(1, n + 1, 3, byArray);
    }

    public void clearActivity() throws OneWireException {
        this.clearActivityOnWrite = true;
    }

    public void setModeAuto(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 0 : 1, 7, 0, byArray);
        Bit.arrayWriteBit(1, 0, 3, byArray);
    }

    public void setControlChannelAssociation(int n, byte[] byArray) throws OneWireException {
        if (!this.isModeAuto(byArray)) {
            throw new OneWireException("Trying to set channel association in manual mode");
        }
        Bit.arrayWriteBit(n, 6, 0, byArray);
        Bit.arrayWriteBit(1, 0, 3, byArray);
    }

    public void setControlData(boolean bl, byte[] byArray) throws OneWireException {
        if (this.isModeAuto(byArray)) {
            throw new OneWireException("Trying to set control data when control is in automatic mode");
        }
        Bit.arrayWriteBit(bl ? 1 : 0, 6, 0, byArray);
        Bit.arrayWriteBit(1, 0, 3, byArray);
    }

    private byte[] deviceOperation(byte by, byte by2, int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[n + 2];
        byArray[0] = by;
        byArray[1] = by2;
        int n2 = 2;
        while (n2 < byArray.length) {
            byArray[n2] = -1;
            ++n2;
        }
        if (this.adapter.select(this.address)) {
            this.adapter.dataBlock(byArray, 0, byArray.length);
            if (by == 90 ? byArray[byArray.length - 1] != byArray[byArray.length - 2] : byArray[byArray.length - 1] != by) {
                throw new OneWireIOException("OneWireContainer1F verify on command incorrect");
            }
            return byArray;
        }
        throw new OneWireIOException("OneWireContainer1F failure - Device not found.");
    }
}

