/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankNVCRC;
import com.dalsemi.onewire.container.MemoryBankScratchEx;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.CRC16;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer1D
extends OneWireContainer {
    private static final byte READ_MEMORY_COMMAND = -91;
    private byte[] buffer = new byte[14];

    public OneWireContainer1D() {
    }

    public OneWireContainer1D(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer1D(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer1D(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2423";
    }

    public String getDescription() {
        return "1-Wire counter with 4096 bits of read/write, nonvolatile memory.  Memory is partitioned into sixteen pages of 256 bits each.  256 bit scratchpad ensures data transfer integrity.  Has overdrive mode.  Last four pages each have 32 bit read-only non rolling-over counter.  The first two counters increment on a page write cycle and the second two have active-low external triggers.";
    }

    public int getMaxSpeed() {
        return 2;
    }

    public Enumeration getMemoryBanks() {
        Vector<PagedMemoryBank> vector = new Vector<PagedMemoryBank>(4);
        MemoryBankScratchEx memoryBankScratchEx = new MemoryBankScratchEx(this);
        vector.addElement(memoryBankScratchEx);
        MemoryBankNVCRC memoryBankNVCRC = new MemoryBankNVCRC(this, memoryBankScratchEx);
        memoryBankNVCRC.numberPages = 12;
        memoryBankNVCRC.size = 384;
        memoryBankNVCRC.extraInfoLength = 8;
        memoryBankNVCRC.readContinuePossible = false;
        memoryBankNVCRC.numVerifyBytes = 8;
        vector.addElement(memoryBankNVCRC);
        memoryBankNVCRC = new MemoryBankNVCRC(this, memoryBankScratchEx);
        memoryBankNVCRC.numberPages = 2;
        memoryBankNVCRC.size = 64;
        memoryBankNVCRC.bankDescription = "Memory with write cycle counter";
        memoryBankNVCRC.startPhysicalAddress = 384;
        memoryBankNVCRC.extraInfo = true;
        memoryBankNVCRC.extraInfoDescription = "Write cycle counter";
        memoryBankNVCRC.extraInfoLength = 8;
        memoryBankNVCRC.readContinuePossible = false;
        memoryBankNVCRC.numVerifyBytes = 8;
        vector.addElement(memoryBankNVCRC);
        memoryBankNVCRC = new MemoryBankNVCRC(this, memoryBankScratchEx);
        memoryBankNVCRC.numberPages = 2;
        memoryBankNVCRC.size = 64;
        memoryBankNVCRC.bankDescription = "Memory with externally triggered counter";
        memoryBankNVCRC.startPhysicalAddress = 448;
        memoryBankNVCRC.extraInfo = true;
        memoryBankNVCRC.extraInfoDescription = "Externally triggered counter";
        memoryBankNVCRC.extraInfoLength = 8;
        vector.addElement(memoryBankNVCRC);
        return vector.elements();
    }

    public long readCounter(int n) throws OneWireIOException, OneWireException {
        if (n < 12 || n > 15) {
            throw new OneWireException("OneWireContainer1D-invalid counter page");
        }
        if (this.adapter.select(this.address)) {
            this.buffer[0] = -91;
            int n2 = CRC16.compute(-91);
            int n3 = (n << 5) + 31;
            this.buffer[1] = (byte)n3;
            n2 = CRC16.compute(this.buffer[1], n2);
            this.buffer[2] = (byte)(n3 >>> 8);
            n2 = CRC16.compute(this.buffer[2], n2);
            int n4 = 3;
            while (n4 < 14) {
                this.buffer[n4] = -1;
                ++n4;
            }
            this.adapter.dataBlock(this.buffer, 0, 14);
            if (CRC16.compute(this.buffer, 3, 11, n2) == 45057) {
                long l = 0L;
                int n5 = 4;
                while (n5 >= 1) {
                    l <<= 8;
                    l |= (long)(this.buffer[n5 + 3] & 0xFF);
                    --n5;
                }
                return l;
            }
        }
        throw new OneWireIOException("OneWireContainer1D-device not present");
    }
}

